/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.MemStore;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.regionserver.compactions.Compactor;
import org.apache.hadoop.hbase.util.CollectionBackedScanner;

@InterfaceAudience.Private
abstract class StoreFlusher {
    protected Configuration conf;
    protected Store store;

    public StoreFlusher(Configuration conf, Store store) {
        this.conf = conf;
        this.store = store;
    }

    public abstract List<Path> flushSnapshot(SortedSet<KeyValue> var1, long var2, TimeRangeTracker var4, AtomicLong var5, MonitoredTask var6) throws IOException;

    protected void finalizeWriter(StoreFile.Writer writer, long cacheFlushSeqNum, MonitoredTask status) throws IOException {
        status.setStatus("Flushing " + this.store + ": appending metadata");
        writer.appendMetadata(cacheFlushSeqNum, false);
        status.setStatus("Flushing " + this.store + ": closing flushed file");
        writer.close();
    }

    protected InternalScanner createScanner(SortedSet<KeyValue> snapshot, long smallestReadPoint) throws IOException {
        CollectionBackedScanner memstoreScanner = new CollectionBackedScanner(snapshot, this.store.getComparator());
        InternalScanner scanner = null;
        if (this.store.getCoprocessorHost() != null) {
            scanner = this.store.getCoprocessorHost().preFlushScannerOpen(this.store, memstoreScanner);
        }
        if (scanner == null) {
            Scan scan2 = new Scan();
            scan2.setMaxVersions(this.store.getScanInfo().getMaxVersions());
            scanner = new StoreScanner(this.store, this.store.getScanInfo(), scan2, Collections.singletonList(memstoreScanner), ScanType.COMPACT_RETAIN_DELETES, smallestReadPoint, Long.MIN_VALUE);
        }
        assert (scanner != null);
        if (this.store.getCoprocessorHost() != null) {
            try {
                return this.store.getCoprocessorHost().preFlush(this.store, scanner);
            }
            catch (IOException ioe) {
                scanner.close();
                throw ioe;
            }
        }
        return scanner;
    }

    protected long performFlush(InternalScanner scanner, Compactor.CellSink sink, long smallestReadPoint) throws IOException {
        boolean hasMore;
        int compactionKVMax = this.conf.getInt("hbase.hstore.compaction.kv.max", 10);
        ArrayList<Cell> kvs = new ArrayList<Cell>();
        long flushed = 0L;
        do {
            hasMore = scanner.next(kvs, compactionKVMax);
            if (kvs.isEmpty()) continue;
            for (Cell c : kvs) {
                KeyValue kv = KeyValueUtil.ensureKeyValue(c);
                if (kv.getMvccVersion() <= smallestReadPoint) {
                    kv = kv.shallowCopy();
                    kv.setMvccVersion(0L);
                }
                sink.append(kv);
                flushed += MemStore.heapSizeChange(kv, true);
            }
            kvs.clear();
        } while (hasMore);
        return flushed;
    }
}

