/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.OperationStatus;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;

@InterfaceAudience.Private
public class MiniBatchOperationInProgress<T> {
    private final T[] operations;
    private final OperationStatus[] retCodeDetails;
    private final WALEdit[] walEditsFromCoprocessors;
    private final int firstIndex;
    private final int lastIndexExclusive;

    public MiniBatchOperationInProgress(T[] operations, OperationStatus[] retCodeDetails, WALEdit[] walEditsFromCoprocessors, int firstIndex, int lastIndexExclusive) {
        this.operations = operations;
        this.retCodeDetails = retCodeDetails;
        this.walEditsFromCoprocessors = walEditsFromCoprocessors;
        this.firstIndex = firstIndex;
        this.lastIndexExclusive = lastIndexExclusive;
    }

    public int size() {
        return this.lastIndexExclusive - this.firstIndex;
    }

    public T getOperation(int index2) {
        return this.operations[this.getAbsoluteIndex(index2)];
    }

    public void setOperationStatus(int index2, OperationStatus opStatus) {
        this.retCodeDetails[this.getAbsoluteIndex((int)index2)] = opStatus;
    }

    public OperationStatus getOperationStatus(int index2) {
        return this.retCodeDetails[this.getAbsoluteIndex(index2)];
    }

    public void setWalEdit(int index2, WALEdit walEdit) {
        this.walEditsFromCoprocessors[this.getAbsoluteIndex((int)index2)] = walEdit;
    }

    public WALEdit getWalEdit(int index2) {
        return this.walEditsFromCoprocessors[this.getAbsoluteIndex(index2)];
    }

    private int getAbsoluteIndex(int index2) {
        if (index2 < 0 || this.firstIndex + index2 >= this.lastIndexExclusive) {
            throw new ArrayIndexOutOfBoundsException(index2);
        }
        return this.firstIndex + index2;
    }
}

