/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.rmi.UnexpectedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.regionserver.GetClosestRowBeforeTracker;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueSkipListSet;
import org.apache.hadoop.hbase.regionserver.MemStoreChunkPool;
import org.apache.hadoop.hbase.regionserver.MemStoreLAB;
import org.apache.hadoop.hbase.regionserver.NonLazyKeyValueScanner;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.cloudera.htrace.Trace;

@InterfaceAudience.Private
public class MemStore
implements HeapSize {
    private static final Log LOG = LogFactory.getLog(MemStore.class);
    static final String USEMSLAB_KEY = "hbase.hregion.memstore.mslab.enabled";
    private static final boolean USEMSLAB_DEFAULT = true;
    private Configuration conf;
    volatile KeyValueSkipListSet kvset;
    volatile KeyValueSkipListSet snapshot;
    final KeyValue.KVComparator comparator;
    final AtomicLong size;
    private volatile long snapshotSize;
    volatile long timeOfOldestEdit = Long.MAX_VALUE;
    TimeRangeTracker timeRangeTracker;
    TimeRangeTracker snapshotTimeRangeTracker;
    MemStoreChunkPool chunkPool;
    volatile MemStoreLAB allocator;
    volatile MemStoreLAB snapshotAllocator;
    public static final long FIXED_OVERHEAD = ClassSize.align(ClassSize.OBJECT + 10 * ClassSize.REFERENCE + 16);
    public static final long DEEP_OVERHEAD = ClassSize.align(FIXED_OVERHEAD + (long)ClassSize.ATOMIC_LONG + (long)(2 * ClassSize.TIMERANGE_TRACKER) + (long)(2 * ClassSize.KEYVALUE_SKIPLIST_SET) + (long)(2 * ClassSize.CONCURRENT_SKIPLISTMAP));

    public MemStore() {
        this(HBaseConfiguration.create(), KeyValue.COMPARATOR);
    }

    public MemStore(Configuration conf, KeyValue.KVComparator c) {
        this.conf = conf;
        this.comparator = c;
        this.kvset = new KeyValueSkipListSet(c);
        this.snapshot = new KeyValueSkipListSet(c);
        this.timeRangeTracker = new TimeRangeTracker();
        this.snapshotTimeRangeTracker = new TimeRangeTracker();
        this.size = new AtomicLong(DEEP_OVERHEAD);
        this.snapshotSize = 0L;
        if (conf.getBoolean(USEMSLAB_KEY, true)) {
            this.chunkPool = MemStoreChunkPool.getPool(conf);
            this.allocator = new MemStoreLAB(conf, this.chunkPool);
        } else {
            this.allocator = null;
            this.chunkPool = null;
        }
    }

    void dump() {
        for (KeyValue kv : this.kvset) {
            LOG.info(kv);
        }
        for (KeyValue kv : this.snapshot) {
            LOG.info(kv);
        }
    }

    void snapshot() {
        if (!this.snapshot.isEmpty()) {
            LOG.warn("Snapshot called again without clearing previous. Doing nothing. Another ongoing flush or did we fail last attempt?");
        } else if (!this.kvset.isEmpty()) {
            this.snapshotSize = this.keySize();
            this.snapshot = this.kvset;
            this.kvset = new KeyValueSkipListSet(this.comparator);
            this.snapshotTimeRangeTracker = this.timeRangeTracker;
            this.timeRangeTracker = new TimeRangeTracker();
            this.size.set(DEEP_OVERHEAD);
            this.snapshotAllocator = this.allocator;
            if (this.allocator != null) {
                this.allocator = new MemStoreLAB(this.conf, this.chunkPool);
            }
            this.timeOfOldestEdit = Long.MAX_VALUE;
        }
    }

    KeyValueSkipListSet getSnapshot() {
        return this.snapshot;
    }

    long getFlushableSize() {
        return this.snapshotSize > 0L ? this.snapshotSize : this.keySize();
    }

    void clearSnapshot(SortedSet<KeyValue> ss) throws UnexpectedException {
        MemStoreLAB tmpAllocator = null;
        if (this.snapshot != ss) {
            throw new UnexpectedException("Current snapshot is " + this.snapshot + ", was passed " + ss);
        }
        if (!ss.isEmpty()) {
            this.snapshot = new KeyValueSkipListSet(this.comparator);
            this.snapshotTimeRangeTracker = new TimeRangeTracker();
        }
        this.snapshotSize = 0L;
        if (this.snapshotAllocator != null) {
            tmpAllocator = this.snapshotAllocator;
            this.snapshotAllocator = null;
        }
        if (tmpAllocator != null) {
            tmpAllocator.close();
        }
    }

    long add(KeyValue kv) {
        KeyValue toAdd = this.maybeCloneWithAllocator(kv);
        return this.internalAdd(toAdd);
    }

    long timeOfOldestEdit() {
        return this.timeOfOldestEdit;
    }

    private boolean addToKVSet(KeyValue e) {
        boolean b = this.kvset.add(e);
        this.setOldestEditTimeToNow();
        return b;
    }

    private boolean removeFromKVSet(KeyValue e) {
        boolean b = this.kvset.remove(e);
        this.setOldestEditTimeToNow();
        return b;
    }

    void setOldestEditTimeToNow() {
        if (this.timeOfOldestEdit == Long.MAX_VALUE) {
            this.timeOfOldestEdit = EnvironmentEdgeManager.currentTimeMillis();
        }
    }

    private long internalAdd(KeyValue toAdd) {
        long s2 = MemStore.heapSizeChange(toAdd, this.addToKVSet(toAdd));
        this.timeRangeTracker.includeTimestamp(toAdd);
        this.size.addAndGet(s2);
        return s2;
    }

    private KeyValue maybeCloneWithAllocator(KeyValue kv) {
        if (this.allocator == null) {
            return kv;
        }
        int len = kv.getLength();
        MemStoreLAB.Allocation alloc = this.allocator.allocateBytes(len);
        if (alloc == null) {
            return kv;
        }
        assert (alloc.getData() != null);
        System.arraycopy(kv.getBuffer(), kv.getOffset(), alloc.getData(), alloc.getOffset(), len);
        KeyValue newKv = new KeyValue(alloc.getData(), alloc.getOffset(), len);
        newKv.setMvccVersion(kv.getMvccVersion());
        return newKv;
    }

    void rollback(KeyValue kv) {
        KeyValue found = this.snapshot.get(kv);
        if (found != null && found.getMvccVersion() == kv.getMvccVersion()) {
            this.snapshot.remove(kv);
            long sz = MemStore.heapSizeChange(kv, true);
            this.snapshotSize -= sz;
        }
        if ((found = this.kvset.get(kv)) != null && found.getMvccVersion() == kv.getMvccVersion()) {
            this.removeFromKVSet(kv);
            long s2 = MemStore.heapSizeChange(kv, true);
            this.size.addAndGet(-s2);
        }
    }

    long delete(KeyValue delete2) {
        long s2 = 0L;
        KeyValue toAdd = this.maybeCloneWithAllocator(delete2);
        this.timeRangeTracker.includeTimestamp(toAdd);
        this.size.addAndGet(s2 += MemStore.heapSizeChange(toAdd, this.addToKVSet(toAdd)));
        return s2;
    }

    KeyValue getNextRow(KeyValue kv) {
        return this.getLowest(this.getNextRow(kv, this.kvset), this.getNextRow(kv, this.snapshot));
    }

    private KeyValue getLowest(KeyValue a, KeyValue b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return this.comparator.compareRows(a, b) <= 0 ? a : b;
    }

    private KeyValue getNextRow(KeyValue key, NavigableSet<KeyValue> set) {
        KeyValue result2 = null;
        NavigableSet<KeyValue> tail = key == null ? set : set.tailSet(key);
        for (KeyValue kv : tail) {
            if (this.comparator.compareRows(kv, key) <= 0) continue;
            result2 = kv;
            break;
        }
        return result2;
    }

    void getRowKeyAtOrBefore(GetClosestRowBeforeTracker state) {
        this.getRowKeyAtOrBefore(this.kvset, state);
        this.getRowKeyAtOrBefore(this.snapshot, state);
    }

    private void getRowKeyAtOrBefore(NavigableSet<KeyValue> set, GetClosestRowBeforeTracker state) {
        if (set.isEmpty()) {
            return;
        }
        if (!this.walkForwardInSingleRow(set, state.getTargetKey(), state)) {
            this.getRowKeyBefore(set, state);
        }
    }

    private boolean walkForwardInSingleRow(SortedSet<KeyValue> set, KeyValue firstOnRow, GetClosestRowBeforeTracker state) {
        KeyValue kv;
        boolean foundCandidate = false;
        SortedSet<KeyValue> tail = set.tailSet(firstOnRow);
        if (tail.isEmpty()) {
            return foundCandidate;
        }
        Iterator i = tail.iterator();
        while (i.hasNext() && !state.isTooFar(kv = (KeyValue)i.next(), firstOnRow)) {
            if (state.isExpired(kv)) {
                i.remove();
                continue;
            }
            if (!state.handle(kv)) continue;
            foundCandidate = true;
            break;
        }
        return foundCandidate;
    }

    private void getRowKeyBefore(NavigableSet<KeyValue> set, GetClosestRowBeforeTracker state) {
        KeyValue firstOnRow = state.getTargetKey();
        Member p = this.memberOfPreviousRow(set, state, firstOnRow);
        while (p != null && state.isTargetTable(p.kv) && state.isBetterCandidate(p.kv) && !this.walkForwardInSingleRow(p.set, firstOnRow = new KeyValue(p.kv.getRowArray(), p.kv.getRowOffset(), p.kv.getRowLength(), Long.MAX_VALUE), state)) {
            p = this.memberOfPreviousRow(p.set, state, firstOnRow);
        }
    }

    long updateColumnValue(byte[] row, byte[] family, byte[] qualifier, long newValue, long now) {
        KeyValue kv;
        KeyValue snKv;
        KeyValue firstKv = KeyValue.createFirstOnRow(row, family, qualifier);
        SortedSet<KeyValue> snSs = this.snapshot.tailSet(firstKv);
        if (!snSs.isEmpty() && (snKv = snSs.first()).matchingRow(firstKv) && snKv.matchingQualifier(firstKv) && snKv.getTimestamp() == now) {
            ++now;
        }
        SortedSet<KeyValue> ss = this.kvset.tailSet(firstKv);
        Iterator i$ = ss.iterator();
        while (i$.hasNext() && (kv = (KeyValue)i$.next()).matchingColumn(family, qualifier) && kv.matchingRow(firstKv)) {
            if (kv.getTypeByte() != KeyValue.Type.Put.getCode() || kv.getTimestamp() <= now || !firstKv.matchingQualifier(kv)) continue;
            now = kv.getTimestamp();
        }
        ArrayList<Cell> cells = new ArrayList<Cell>(1);
        cells.add(new KeyValue(row, family, qualifier, now, Bytes.toBytes(newValue)));
        return this.upsert(cells, 1L);
    }

    public long upsert(Iterable<Cell> cells, long readpoint) {
        long size2 = 0L;
        for (Cell cell : cells) {
            size2 += this.upsert(cell, readpoint);
        }
        return size2;
    }

    private long upsert(Cell cell, long readpoint) {
        KeyValue kv = KeyValueUtil.ensureKeyValue(cell);
        long addedSize = this.internalAdd(kv);
        KeyValue firstKv = KeyValue.createFirstOnRow(kv.getBuffer(), kv.getRowOffset(), kv.getRowLength(), kv.getBuffer(), kv.getFamilyOffset(), kv.getFamilyLength(), kv.getBuffer(), kv.getQualifierOffset(), kv.getQualifierLength());
        SortedSet<KeyValue> ss = this.kvset.tailSet(firstKv);
        Iterator it = ss.iterator();
        int versionsVisible = 0;
        while (it.hasNext()) {
            KeyValue cur = (KeyValue)it.next();
            if (kv == cur) continue;
            if (!kv.matchingRow(cur) || !kv.matchingQualifier(cur)) break;
            if (cur.getTypeByte() != KeyValue.Type.Put.getCode() || cur.getMvccVersion() > readpoint) continue;
            if (versionsVisible >= 1) {
                long delta = MemStore.heapSizeChange(cur, true);
                addedSize -= delta;
                this.size.addAndGet(-delta);
                it.remove();
                this.setOldestEditTimeToNow();
                continue;
            }
            ++versionsVisible;
        }
        return addedSize;
    }

    private Member memberOfPreviousRow(NavigableSet<KeyValue> set, GetClosestRowBeforeTracker state, KeyValue firstOnRow) {
        NavigableSet<KeyValue> head2 = set.headSet(firstOnRow, false);
        if (head2.isEmpty()) {
            return null;
        }
        Iterator<KeyValue> i = head2.descendingIterator();
        while (i.hasNext()) {
            KeyValue found = i.next();
            if (state.isExpired(found)) {
                i.remove();
                continue;
            }
            return new Member(head2, found);
        }
        return null;
    }

    List<KeyValueScanner> getScanners(long readPt) {
        return Collections.singletonList(new MemStoreScanner(readPt));
    }

    public boolean shouldSeek(Scan scan2, long oldestUnexpiredTS) {
        return (this.timeRangeTracker.includesTimeRange(scan2.getTimeRange()) || this.snapshotTimeRangeTracker.includesTimeRange(scan2.getTimeRange())) && Math.max(this.timeRangeTracker.getMaximumTimestamp(), this.snapshotTimeRangeTracker.getMaximumTimestamp()) >= oldestUnexpiredTS;
    }

    public TimeRangeTracker getSnapshotTimeRangeTracker() {
        return this.snapshotTimeRangeTracker;
    }

    static long heapSizeChange(KeyValue kv, boolean notpresent) {
        return notpresent ? ClassSize.align((long)ClassSize.CONCURRENT_SKIPLISTMAP_ENTRY + kv.heapSize()) : 0L;
    }

    @Override
    public long heapSize() {
        return this.size.get();
    }

    public long keySize() {
        return this.heapSize() - DEEP_OVERHEAD;
    }

    public static void main(String[] args) {
        int i;
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        LOG.info("vmName=" + runtime.getVmName() + ", vmVendor=" + runtime.getVmVendor() + ", vmVersion=" + runtime.getVmVersion());
        LOG.info("vmInputArguments=" + runtime.getInputArguments());
        MemStore memstore1 = new MemStore();
        long size2 = 0L;
        int count2 = 10000;
        byte[] fam = Bytes.toBytes("col");
        byte[] qf = Bytes.toBytes("umn");
        byte[] empty = new byte[]{};
        for (i = 0; i < 10000; ++i) {
            size2 += memstore1.add(new KeyValue(Bytes.toBytes(i), fam, qf, (long)i, empty));
        }
        LOG.info("memstore1 estimated size=" + size2);
        for (i = 0; i < 10000; ++i) {
            size2 += memstore1.add(new KeyValue(Bytes.toBytes(i), fam, qf, (long)i, empty));
        }
        LOG.info("memstore1 estimated size (2nd loading of same data)=" + size2);
        MemStore memstore2 = new MemStore();
        for (int i2 = 0; i2 < 10000; ++i2) {
            size2 += memstore2.add(new KeyValue(Bytes.toBytes(i2), fam, qf, (long)i2, new byte[i2]));
        }
        LOG.info("memstore2 estimated size=" + size2);
        int seconds = 30;
        LOG.info("Waiting 30 seconds while heap dump is taken");
        for (int i3 = 0; i3 < 30; ++i3) {
        }
        LOG.info("Exiting.");
    }

    protected class MemStoreScanner
    extends NonLazyKeyValueScanner {
        private KeyValue kvsetNextRow = null;
        private KeyValue snapshotNextRow = null;
        private KeyValue kvsetItRow = null;
        private KeyValue snapshotItRow = null;
        private Iterator<KeyValue> kvsetIt;
        private Iterator<KeyValue> snapshotIt;
        private KeyValueSkipListSet kvsetAtCreation;
        private KeyValueSkipListSet snapshotAtCreation;
        private KeyValue theNext;
        volatile MemStoreLAB allocatorAtCreation;
        volatile MemStoreLAB snapshotAllocatorAtCreation;
        private boolean stopSkippingKVsIfNextRow = false;
        private long readPoint;

        MemStoreScanner(long readPoint) {
            this.readPoint = readPoint;
            this.kvsetAtCreation = MemStore.this.kvset;
            this.snapshotAtCreation = MemStore.this.snapshot;
            if (MemStore.this.allocator != null) {
                this.allocatorAtCreation = MemStore.this.allocator;
                this.allocatorAtCreation.incScannerCount();
            }
            if (MemStore.this.snapshotAllocator != null) {
                this.snapshotAllocatorAtCreation = MemStore.this.snapshotAllocator;
                this.snapshotAllocatorAtCreation.incScannerCount();
            }
            if (Trace.isTracing() && Trace.currentSpan() != null) {
                Trace.currentSpan().addTimelineAnnotation("Creating MemStoreScanner");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private KeyValue getNext(Iterator<KeyValue> it) {
            KeyValue startKV = this.theNext;
            KeyValue v = null;
            try {
                while (it.hasNext()) {
                    v = it.next();
                    if (v.getMvccVersion() <= this.readPoint) {
                        KeyValue keyValue = v;
                        return keyValue;
                    }
                    if (!this.stopSkippingKVsIfNextRow || startKV == null || MemStore.this.comparator.compareRows(v, startKV) <= 0) continue;
                    KeyValue keyValue = null;
                    return keyValue;
                }
                KeyValue keyValue = null;
                return keyValue;
            }
            finally {
                if (v != null) {
                    if (it == this.snapshotIt) {
                        this.snapshotItRow = v;
                    } else {
                        this.kvsetItRow = v;
                    }
                }
            }
        }

        @Override
        public synchronized boolean seek(KeyValue key) {
            if (key == null) {
                this.close();
                return false;
            }
            this.kvsetIt = this.kvsetAtCreation.tailSet(key).iterator();
            this.snapshotIt = this.snapshotAtCreation.tailSet(key).iterator();
            this.kvsetItRow = null;
            this.snapshotItRow = null;
            return this.seekInSubLists(key);
        }

        private synchronized boolean seekInSubLists(KeyValue key) {
            this.kvsetNextRow = this.getNext(this.kvsetIt);
            this.snapshotNextRow = this.getNext(this.snapshotIt);
            this.theNext = this.getLowest(this.kvsetNextRow, this.snapshotNextRow);
            return this.theNext != null;
        }

        @Override
        public synchronized boolean reseek(KeyValue key) {
            this.kvsetIt = this.kvsetAtCreation.tailSet(this.getHighest(key, this.kvsetItRow)).iterator();
            this.snapshotIt = this.snapshotAtCreation.tailSet(this.getHighest(key, this.snapshotItRow)).iterator();
            return this.seekInSubLists(key);
        }

        @Override
        public synchronized KeyValue peek() {
            return this.theNext;
        }

        @Override
        public synchronized KeyValue next() {
            if (this.theNext == null) {
                return null;
            }
            KeyValue ret = this.theNext;
            if (this.theNext == this.kvsetNextRow) {
                this.kvsetNextRow = this.getNext(this.kvsetIt);
            } else {
                this.snapshotNextRow = this.getNext(this.snapshotIt);
            }
            this.theNext = this.getLowest(this.kvsetNextRow, this.snapshotNextRow);
            return ret;
        }

        private KeyValue getLowest(KeyValue first, KeyValue second) {
            if (first == null && second == null) {
                return null;
            }
            if (first != null && second != null) {
                int compare = MemStore.this.comparator.compare(first, second);
                return compare <= 0 ? first : second;
            }
            return first != null ? first : second;
        }

        private KeyValue getHighest(KeyValue first, KeyValue second) {
            if (first == null && second == null) {
                return null;
            }
            if (first != null && second != null) {
                int compare = MemStore.this.comparator.compare(first, second);
                return compare > 0 ? first : second;
            }
            return first != null ? first : second;
        }

        @Override
        public synchronized void close() {
            this.kvsetNextRow = null;
            this.snapshotNextRow = null;
            this.kvsetIt = null;
            this.snapshotIt = null;
            if (this.allocatorAtCreation != null) {
                this.allocatorAtCreation.decScannerCount();
                this.allocatorAtCreation = null;
            }
            if (this.snapshotAllocatorAtCreation != null) {
                this.snapshotAllocatorAtCreation.decScannerCount();
                this.snapshotAllocatorAtCreation = null;
            }
            this.kvsetItRow = null;
            this.snapshotItRow = null;
        }

        @Override
        public long getSequenceID() {
            return Long.MAX_VALUE;
        }

        @Override
        public boolean shouldUseScanner(Scan scan2, SortedSet<byte[]> columns, long oldestUnexpiredTS) {
            return MemStore.this.shouldSeek(scan2, oldestUnexpiredTS);
        }

        @Override
        public synchronized boolean backwardSeek(KeyValue key) {
            this.seek(key);
            if (this.peek() == null || MemStore.this.comparator.compareRows(this.peek(), key) > 0) {
                return this.seekToPreviousRow(key);
            }
            return true;
        }

        @Override
        public synchronized boolean seekToPreviousRow(KeyValue key) {
            SortedSet<KeyValue> snapshotHead;
            KeyValue snapshotBeforeRow;
            KeyValue firstKeyOnRow = KeyValue.createFirstOnRow(key.getRow());
            SortedSet<KeyValue> kvHead = this.kvsetAtCreation.headSet(firstKeyOnRow);
            KeyValue kvsetBeforeRow = kvHead.isEmpty() ? null : kvHead.last();
            KeyValue lastKVBeforeRow = this.getHighest(kvsetBeforeRow, snapshotBeforeRow = (snapshotHead = this.snapshotAtCreation.headSet(firstKeyOnRow)).isEmpty() ? null : snapshotHead.last());
            if (lastKVBeforeRow == null) {
                this.theNext = null;
                return false;
            }
            KeyValue firstKeyOnPreviousRow = KeyValue.createFirstOnRow(lastKVBeforeRow.getRow());
            this.stopSkippingKVsIfNextRow = true;
            this.seek(firstKeyOnPreviousRow);
            this.stopSkippingKVsIfNextRow = false;
            if (this.peek() == null || MemStore.this.comparator.compareRows(this.peek(), firstKeyOnPreviousRow) > 0) {
                return this.seekToPreviousRow(lastKVBeforeRow);
            }
            return true;
        }

        @Override
        public synchronized boolean seekToLastRow() {
            KeyValue second;
            KeyValue first = this.kvsetAtCreation.isEmpty() ? null : this.kvsetAtCreation.last();
            KeyValue higherKv = this.getHighest(first, second = this.snapshotAtCreation.isEmpty() ? null : this.snapshotAtCreation.last());
            if (higherKv == null) {
                return false;
            }
            KeyValue firstKvOnLastRow = KeyValue.createFirstOnRow(higherKv.getRow());
            if (this.seek(firstKvOnLastRow)) {
                return true;
            }
            return this.seekToPreviousRow(higherKv);
        }
    }

    private static class Member {
        final KeyValue kv;
        final NavigableSet<KeyValue> set;

        Member(NavigableSet<KeyValue> s2, KeyValue kv) {
            this.kv = kv;
            this.set = s2;
        }
    }
}

