/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.procedure.Procedure;
import org.apache.hadoop.hbase.procedure.ProcedureCoordinator;
import org.apache.hadoop.hbase.procedure.ProcedureCoordinatorRpcs;
import org.apache.hadoop.hbase.procedure.ZKProcedureUtil;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class ZKProcedureCoordinatorRpcs
implements ProcedureCoordinatorRpcs {
    public static final Log LOG = LogFactory.getLog(ZKProcedureCoordinatorRpcs.class);
    private ZKProcedureUtil zkProc = null;
    protected ProcedureCoordinator coordinator = null;
    ZooKeeperWatcher watcher;
    String procedureType;
    String coordName;

    public ZKProcedureCoordinatorRpcs(ZooKeeperWatcher watcher, String procedureClass, String coordName) throws KeeperException {
        this.watcher = watcher;
        this.procedureType = procedureClass;
        this.coordName = coordName;
    }

    @Override
    public final void sendGlobalBarrierAcquire(Procedure proc, byte[] info, List<String> nodeNames) throws IOException, IllegalArgumentException {
        String procName = proc.getName();
        String abortNode = this.zkProc.getAbortZNode(procName);
        try {
            if (ZKUtil.watchAndCheckExists(this.zkProc.getWatcher(), abortNode)) {
                this.abort(abortNode);
            }
        }
        catch (KeeperException e) {
            LOG.error("Failed to watch abort", e);
            throw new IOException("Failed while watching abort node:" + abortNode, e);
        }
        String acquire = this.zkProc.getAcquiredBarrierNode(procName);
        LOG.debug("Creating acquire znode:" + acquire);
        try {
            byte[] data2 = ProtobufUtil.prependPBMagic(info);
            ZKUtil.createWithParents(this.zkProc.getWatcher(), acquire, data2);
            for (String node : nodeNames) {
                String znode = ZKUtil.joinZNode(acquire, node);
                LOG.debug("Watching for acquire node:" + znode);
                if (!ZKUtil.watchAndCheckExists(this.zkProc.getWatcher(), znode)) continue;
                this.coordinator.memberAcquiredBarrier(procName, node);
            }
        }
        catch (KeeperException e) {
            throw new IOException("Failed while creating acquire node:" + acquire, e);
        }
    }

    @Override
    public void sendGlobalBarrierReached(Procedure proc, List<String> nodeNames) throws IOException {
        String procName = proc.getName();
        String reachedNode = this.zkProc.getReachedBarrierNode(procName);
        LOG.debug("Creating reached barrier zk node:" + reachedNode);
        try {
            ZKUtil.createWithParents(this.zkProc.getWatcher(), reachedNode);
            for (String node : nodeNames) {
                String znode = ZKUtil.joinZNode(reachedNode, node);
                if (!ZKUtil.watchAndCheckExists(this.zkProc.getWatcher(), znode)) continue;
                this.coordinator.memberFinishedBarrier(procName, node);
            }
        }
        catch (KeeperException e) {
            throw new IOException("Failed while creating reached node:" + reachedNode, e);
        }
    }

    @Override
    public final void resetMembers(Procedure proc) throws IOException {
        String procName = proc.getName();
        boolean stillGettingNotifications = false;
        do {
            try {
                LOG.debug("Attempting to clean out zk node for op:" + procName);
                this.zkProc.clearZNodes(procName);
                stillGettingNotifications = false;
            }
            catch (KeeperException.NotEmptyException e) {
                stillGettingNotifications = true;
            }
            catch (KeeperException e) {
                throw new IOException("Failed to complete reset procedure " + procName, e);
            }
        } while (stillGettingNotifications);
    }

    @Override
    public final boolean start(final ProcedureCoordinator coordinator) {
        if (this.coordinator != null) {
            throw new IllegalStateException("ZKProcedureCoordinator already started and already has listener installed");
        }
        this.coordinator = coordinator;
        try {
            this.zkProc = new ZKProcedureUtil(this.watcher, this.procedureType){

                @Override
                public void nodeCreated(String path) {
                    if (!this.isInProcedurePath(path)) {
                        return;
                    }
                    LOG.debug("Node created: " + path);
                    this.logZKTree(this.baseZNode);
                    if (this.isAcquiredPathNode(path)) {
                        coordinator.memberAcquiredBarrier(ZKUtil.getNodeName(ZKUtil.getParent(path)), ZKUtil.getNodeName(path));
                    } else if (this.isReachedPathNode(path)) {
                        coordinator.memberFinishedBarrier(ZKUtil.getNodeName(ZKUtil.getParent(path)), ZKUtil.getNodeName(path));
                    } else if (this.isAbortPathNode(path)) {
                        ZKProcedureCoordinatorRpcs.this.abort(path);
                    } else {
                        LOG.debug("Ignoring created notification for node:" + path);
                    }
                }
            };
            this.zkProc.clearChildZNodes();
        }
        catch (KeeperException e) {
            LOG.error("Unable to start the ZK-based Procedure Coordinator rpcs.", e);
            return false;
        }
        LOG.debug("Starting the controller for procedure member:" + this.coordName);
        return true;
    }

    @Override
    public final void sendAbortToMembers(Procedure proc, ForeignException ee) {
        String procName = proc.getName();
        LOG.debug("Aborting procedure '" + procName + "' in zk");
        String procAbortNode = this.zkProc.getAbortZNode(procName);
        try {
            LOG.debug("Creating abort znode:" + procAbortNode);
            String source = ee.getSource() == null ? this.coordName : ee.getSource();
            byte[] errorInfo = ProtobufUtil.prependPBMagic(ForeignException.serialize(source, ee));
            ZKUtil.createAndFailSilent(this.zkProc.getWatcher(), procAbortNode, errorInfo);
            LOG.debug("Finished creating abort node:" + procAbortNode);
        }
        catch (KeeperException e) {
            this.zkProc.logZKTree(this.zkProc.baseZNode);
            this.coordinator.rpcConnectionFailure("Failed to post zk node:" + procAbortNode + " to abort procedure '" + procName + "'", new IOException(e));
        }
    }

    protected void abort(String abortNode) {
        String procName = ZKUtil.getNodeName(abortNode);
        ForeignException ee = null;
        try {
            byte[] data2 = ZKUtil.getData(this.zkProc.getWatcher(), abortNode);
            if (!ProtobufUtil.isPBMagicPrefix(data2)) {
                LOG.warn("Got an error notification for op:" + abortNode + " but we can't read the information. Killing the procedure.");
                ee = new ForeignException(this.coordName, "Data in abort node is illegally formatted.  ignoring content.");
            } else {
                data2 = Arrays.copyOfRange(data2, ProtobufUtil.lengthOfPBMagic(), data2.length);
                ee = ForeignException.deserialize(data2);
            }
        }
        catch (InvalidProtocolBufferException e) {
            LOG.warn("Got an error notification for op:" + abortNode + " but we can't read the information. Killing the procedure.");
            ee = new ForeignException(this.coordName, e);
        }
        catch (KeeperException e) {
            this.coordinator.rpcConnectionFailure("Failed to get data for abort node:" + abortNode + this.zkProc.getAbortZnode(), new IOException(e));
        }
        this.coordinator.abortProcedure(procName, ee);
    }

    @Override
    public final void close() throws IOException {
        this.zkProc.close();
    }

    final ZKProcedureUtil getZkProcedureUtil() {
        return this.zkProc;
    }
}

