/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.handler.TableEventHandler;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class TableDeleteFamilyHandler
extends TableEventHandler {
    private byte[] familyName;

    public TableDeleteFamilyHandler(TableName tableName, byte[] familyName, Server server, MasterServices masterServices) throws IOException {
        super(EventType.C_M_DELETE_FAMILY, tableName, server, masterServices);
        this.familyName = familyName;
    }

    @Override
    protected void prepareWithTableLock() throws IOException {
        super.prepareWithTableLock();
        HTableDescriptor htd = this.getTableDescriptor();
        this.familyName = this.hasColumnFamily(htd, this.familyName);
    }

    @Override
    protected void handleTableOperation(List<HRegionInfo> hris) throws IOException {
        MasterCoprocessorHost cpHost = ((HMaster)this.server).getCoprocessorHost();
        if (cpHost != null) {
            cpHost.preDeleteColumnHandler(this.tableName, this.familyName);
        }
        this.masterServices.getMasterFileSystem().deleteColumn(this.tableName, this.familyName);
        MasterFileSystem mfs = this.masterServices.getMasterFileSystem();
        for (HRegionInfo hri : hris) {
            mfs.deleteFamilyFromFS(hri, this.familyName);
        }
        if (cpHost != null) {
            cpHost.postDeleteColumnHandler(this.tableName, this.familyName);
        }
    }

    @Override
    public String toString() {
        String name = "UnknownServerName";
        if (this.server != null && this.server.getServerName() != null) {
            name = this.server.getServerName().toString();
        }
        String family = "UnknownFamily";
        if (this.familyName != null) {
            family = Bytes.toString(this.familyName);
        }
        return this.getClass().getSimpleName() + "-" + name + "-" + this.getSeqid() + "-" + this.tableName + "-" + family;
    }
}

