/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.handler.TableEventHandler;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class ModifyTableHandler
extends TableEventHandler {
    private static final Log LOG = LogFactory.getLog(ModifyTableHandler.class);
    private final HTableDescriptor htd;

    public ModifyTableHandler(TableName tableName, HTableDescriptor htd, Server server, MasterServices masterServices) {
        super(EventType.C_M_MODIFY_TABLE, tableName, server, masterServices);
        this.htd = htd;
    }

    @Override
    protected void prepareWithTableLock() throws IOException {
        super.prepareWithTableLock();
        this.getTableDescriptor();
    }

    @Override
    protected void handleTableOperation(List<HRegionInfo> hris) throws IOException {
        MasterCoprocessorHost cpHost = ((HMaster)this.server).getCoprocessorHost();
        if (cpHost != null) {
            cpHost.preModifyTableHandler(this.tableName, this.htd);
        }
        HTableDescriptor oldHtd = this.getTableDescriptor();
        this.masterServices.getTableDescriptors().add(this.htd);
        this.deleteFamilyFromFS(hris, oldHtd.getFamiliesKeys());
        if (cpHost != null) {
            cpHost.postModifyTableHandler(this.tableName, this.htd);
        }
    }

    private void deleteFamilyFromFS(List<HRegionInfo> hris, Set<byte[]> oldFamilies) {
        try {
            Set<byte[]> newFamilies = this.htd.getFamiliesKeys();
            MasterFileSystem mfs = this.masterServices.getMasterFileSystem();
            for (byte[] familyName : oldFamilies) {
                if (newFamilies.contains(familyName)) continue;
                LOG.debug("Removing family=" + Bytes.toString(familyName) + " from table=" + this.tableName);
                for (HRegionInfo hri : hris) {
                    mfs.deleteFamilyFromFS(hri, familyName);
                }
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to remove on-disk directories for the removed families", e);
        }
    }

    @Override
    public String toString() {
        String name = "UnknownServerName";
        if (this.server != null && this.server.getServerName() != null) {
            name = this.server.getServerName().toString();
        }
        return this.getClass().getSimpleName() + "-" + name + "-" + this.getSeqid() + "-" + this.tableName;
    }
}

