/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.GeneralBulkAssigner;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class EnableTableHandler
extends EventHandler {
    private static final Log LOG = LogFactory.getLog(EnableTableHandler.class);
    private final TableName tableName;
    private final AssignmentManager assignmentManager;
    private final TableLockManager tableLockManager;
    private final CatalogTracker catalogTracker;
    private boolean skipTableStateCheck = false;
    private TableLockManager.TableLock tableLock;

    public EnableTableHandler(Server server, TableName tableName, CatalogTracker catalogTracker, AssignmentManager assignmentManager, TableLockManager tableLockManager, boolean skipTableStateCheck) {
        super(server, EventType.C_M_ENABLE_TABLE);
        this.tableName = tableName;
        this.catalogTracker = catalogTracker;
        this.assignmentManager = assignmentManager;
        this.tableLockManager = tableLockManager;
        this.skipTableStateCheck = skipTableStateCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableTableHandler prepare() throws TableNotFoundException, TableNotDisabledException, IOException {
        this.tableLock = this.tableLockManager.writeLock(this.tableName, EventType.C_M_ENABLE_TABLE.toString());
        this.tableLock.acquire();
        boolean success2 = false;
        try {
            if (!MetaReader.tableExists(this.catalogTracker, this.tableName)) {
                if (!this.skipTableStateCheck) {
                    throw new TableNotFoundException(this.tableName);
                }
                try {
                    this.assignmentManager.getZKTable().removeEnablingTable(this.tableName, true);
                    throw new TableNotFoundException(this.tableName);
                }
                catch (KeeperException e) {
                    LOG.warn("Failed to delete the ENABLING node for the table " + this.tableName + ".  The table will remain unusable. Run HBCK to manually fix the problem.");
                }
            }
            if (!this.skipTableStateCheck) {
                try {
                    if (!this.assignmentManager.getZKTable().checkDisabledAndSetEnablingTable(this.tableName)) {
                        LOG.info("Table " + this.tableName + " isn't disabled; skipping enable");
                        throw new TableNotDisabledException(this.tableName);
                    }
                }
                catch (KeeperException e) {
                    throw new IOException("Unable to ensure that the table will be enabling because of a ZooKeeper issue", e);
                }
            }
            success2 = true;
        }
        finally {
            if (!success2) {
                this.releaseTableLock();
            }
        }
        return this;
    }

    @Override
    public String toString() {
        String name = "UnknownServerName";
        if (this.server != null && this.server.getServerName() != null) {
            name = this.server.getServerName().toString();
        }
        return this.getClass().getSimpleName() + "-" + name + "-" + this.getSeqid() + "-" + this.tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        try {
            LOG.info("Attempting to enable the table " + this.tableName);
            MasterCoprocessorHost cpHost = ((HMaster)this.server).getCoprocessorHost();
            if (cpHost != null) {
                cpHost.preEnableTableHandler(this.tableName);
            }
            this.handleEnableTable();
            if (cpHost != null) {
                cpHost.postEnableTableHandler(this.tableName);
            }
        }
        catch (IOException e) {
            LOG.error("Error trying to enable the table " + this.tableName, e);
        }
        catch (KeeperException e) {
            LOG.error("Error trying to enable the table " + this.tableName, e);
        }
        catch (InterruptedException e) {
            LOG.error("Error trying to enable the table " + this.tableName, e);
        }
        finally {
            this.releaseTableLock();
        }
    }

    private void releaseTableLock() {
        if (this.tableLock != null) {
            try {
                this.tableLock.release();
            }
            catch (IOException ex) {
                LOG.warn("Could not release the table lock", ex);
            }
        }
    }

    private void handleEnableTable() throws IOException, KeeperException, InterruptedException {
        this.assignmentManager.getZKTable().setEnablingTable(this.tableName);
        boolean done = false;
        ServerManager serverManager = ((HMaster)this.server).getServerManager();
        List<Pair<HRegionInfo, ServerName>> tableRegionsAndLocations = MetaReader.getTableRegionsAndLocations(this.catalogTracker, this.tableName, true);
        int countOfRegionsInTable = tableRegionsAndLocations.size();
        Map<HRegionInfo, ServerName> regionsToAssign = this.regionsToAssignWithServerName(tableRegionsAndLocations);
        int regionsCount = regionsToAssign.size();
        if (regionsCount == 0) {
            done = true;
        }
        LOG.info("Table '" + this.tableName + "' has " + countOfRegionsInTable + " regions, of which " + regionsCount + " are offline.");
        List<ServerName> onlineServers = serverManager.createDestinationServersList();
        Map<ServerName, List<HRegionInfo>> bulkPlan = this.assignmentManager.getBalancer().retainAssignment(regionsToAssign, onlineServers);
        LOG.info("Bulk assigning " + regionsCount + " region(s) across " + bulkPlan.size() + " server(s), retainAssignment=true");
        GeneralBulkAssigner ba = new GeneralBulkAssigner(this.server, bulkPlan, this.assignmentManager, true);
        try {
            if (ba.bulkAssign()) {
                done = true;
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Enable operation was interrupted when enabling table '" + this.tableName + "'");
            Thread.currentThread().interrupt();
        }
        if (done) {
            this.assignmentManager.getZKTable().setEnabledTable(this.tableName);
            LOG.info("Table '" + this.tableName + "' was successfully enabled. Status: done=" + done);
        } else {
            LOG.warn("Table '" + this.tableName + "' wasn't successfully enabled. Status: done=" + done);
        }
    }

    private Map<HRegionInfo, ServerName> regionsToAssignWithServerName(List<Pair<HRegionInfo, ServerName>> regionsInMeta) throws IOException {
        HashMap<HRegionInfo, ServerName> regionsToAssign = new HashMap<HRegionInfo, ServerName>(regionsInMeta.size());
        RegionStates regionStates = this.assignmentManager.getRegionStates();
        for (Pair<HRegionInfo, ServerName> regionLocation : regionsInMeta) {
            HRegionInfo hri = regionLocation.getFirst();
            ServerName sn = regionLocation.getSecond();
            if (regionStates.isRegionOffline(hri)) {
                regionsToAssign.put(hri, sn);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Skipping assign for the region " + hri + " during enable table " + hri.getTable() + " because its already in tranition or assigned.");
        }
        return regionsToAssign;
    }
}

