/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.exceptions.RegionOpeningException;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.master.CatalogJanitor;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.Private
public class DispatchMergingRegionHandler
extends EventHandler {
    private static final Log LOG = LogFactory.getLog(DispatchMergingRegionHandler.class);
    private final MasterServices masterServices;
    private final CatalogJanitor catalogJanitor;
    private HRegionInfo region_a;
    private HRegionInfo region_b;
    private final boolean forcible;
    private final int timeout;

    public DispatchMergingRegionHandler(MasterServices services, CatalogJanitor catalogJanitor, HRegionInfo region_a, HRegionInfo region_b, boolean forcible) {
        super(services, EventType.C_M_MERGE_REGION);
        this.masterServices = services;
        this.catalogJanitor = catalogJanitor;
        this.region_a = region_a;
        this.region_b = region_b;
        this.forcible = forcible;
        this.timeout = this.server.getConfiguration().getInt("hbase.master.regionmerge.timeout", 120000);
    }

    @Override
    public void process() throws IOException {
        boolean regionAHasMergeQualifier;
        boolean bl = regionAHasMergeQualifier = !this.catalogJanitor.cleanMergeQualifier(this.region_a);
        if (regionAHasMergeQualifier || !this.catalogJanitor.cleanMergeQualifier(this.region_b)) {
            LOG.info("Skip merging regions " + this.region_a.getRegionNameAsString() + ", " + this.region_b.getRegionNameAsString() + ", because region " + (regionAHasMergeQualifier ? this.region_a.getEncodedName() : this.region_b.getEncodedName()) + " has merge qualifier");
            return;
        }
        RegionStates regionStates = this.masterServices.getAssignmentManager().getRegionStates();
        ServerName region_a_location = regionStates.getRegionServerOfRegion(this.region_a);
        ServerName region_b_location = regionStates.getRegionServerOfRegion(this.region_b);
        if (region_a_location == null || region_b_location == null) {
            LOG.info("Skip merging regions " + this.region_a.getRegionNameAsString() + ", " + this.region_b.getRegionNameAsString() + ", because region " + (region_a_location == null ? this.region_a.getEncodedName() : this.region_b.getEncodedName()) + " is not online now");
            return;
        }
        long startTime = EnvironmentEdgeManager.currentTimeMillis();
        boolean onSameRS = region_a_location.equals(region_b_location);
        if (!onSameRS) {
            RegionLoad loadOfRegionA = this.getRegionLoad(region_a_location, this.region_a);
            RegionLoad loadOfRegionB = this.getRegionLoad(region_b_location, this.region_b);
            if (loadOfRegionA != null && loadOfRegionB != null && loadOfRegionA.getRequestsCount() < loadOfRegionB.getRequestsCount()) {
                HRegionInfo tmpRegion = this.region_a;
                this.region_a = this.region_b;
                this.region_b = tmpRegion;
                ServerName tmpLocation = region_a_location;
                region_a_location = region_b_location;
                region_b_location = tmpLocation;
            }
            RegionPlan regionPlan = new RegionPlan(this.region_b, region_b_location, region_a_location);
            LOG.info("Moving regions to same server for merge: " + regionPlan.toString());
            this.masterServices.getAssignmentManager().balance(regionPlan);
            while (!this.masterServices.isStopped()) {
                try {
                    Thread.sleep(20L);
                    boolean isRIT = regionStates.isRegionInTransition(this.region_b);
                    region_b_location = this.masterServices.getAssignmentManager().getRegionStates().getRegionServerOfRegion(this.region_b);
                    onSameRS = region_a_location.equals(region_b_location);
                    if (!onSameRS && isRIT && EnvironmentEdgeManager.currentTimeMillis() - startTime <= (long)this.timeout) continue;
                    break;
                }
                catch (InterruptedException e) {
                    InterruptedIOException iioe = new InterruptedIOException();
                    iioe.initCause(e);
                    throw iioe;
                }
            }
        }
        if (onSameRS) {
            startTime = EnvironmentEdgeManager.currentTimeMillis();
            while (!this.masterServices.isStopped()) {
                try {
                    this.masterServices.getServerManager().sendRegionsMerge(region_a_location, this.region_a, this.region_b, this.forcible);
                    LOG.info("Sent merge to server " + region_a_location + " for region " + this.region_a.getEncodedName() + "," + this.region_b.getEncodedName() + ", focible=" + this.forcible);
                }
                catch (RegionOpeningException roe) {
                    if (EnvironmentEdgeManager.currentTimeMillis() - startTime <= (long)this.timeout) continue;
                    LOG.warn("Failed sending merge to " + region_a_location + " after " + this.timeout + "ms", roe);
                }
                catch (IOException ie) {
                    LOG.warn("Failed sending merge to " + region_a_location + " for region " + this.region_a.getEncodedName() + "," + this.region_b.getEncodedName() + ", focible=" + this.forcible, ie);
                }
                break;
            }
        } else {
            LOG.info("Cancel merging regions " + this.region_a.getRegionNameAsString() + ", " + this.region_b.getRegionNameAsString() + ", because can't move them together after " + (EnvironmentEdgeManager.currentTimeMillis() - startTime) + "ms");
        }
    }

    private RegionLoad getRegionLoad(ServerName sn, HRegionInfo hri) {
        Map<byte[], RegionLoad> regionsLoad;
        ServerManager serverManager = this.masterServices.getServerManager();
        ServerLoad load = serverManager.getLoad(sn);
        if (load != null && (regionsLoad = load.getRegionsLoad()) != null) {
            return regionsLoad.get(hri.getRegionName());
        }
        return null;
    }
}

