/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.balancer.FavoredNodeAssignmentHelper;

@InterfaceAudience.Private
public class FavoredNodesPlan {
    protected static final Log LOG = LogFactory.getLog(FavoredNodesPlan.class.getName());
    private Map<HRegionInfo, List<ServerName>> favoredNodesMap = new ConcurrentHashMap<HRegionInfo, List<ServerName>>();

    public synchronized void updateFavoredNodesMap(HRegionInfo region, List<ServerName> servers) {
        if (region == null || servers == null || servers.size() == 0) {
            return;
        }
        this.favoredNodesMap.put(region, servers);
    }

    public synchronized List<ServerName> getFavoredNodes(HRegionInfo region) {
        return this.favoredNodesMap.get(region);
    }

    public static Position getFavoredServerPosition(List<ServerName> favoredNodes, ServerName server) {
        if (favoredNodes == null || server == null || favoredNodes.size() != 3) {
            return null;
        }
        for (Position p : Position.values()) {
            if (!ServerName.isSameHostnameAndPort(favoredNodes.get(p.ordinal()), server)) continue;
            return p;
        }
        return null;
    }

    public synchronized Map<HRegionInfo, List<ServerName>> getAssignmentMap() {
        return this.favoredNodesMap;
    }

    public synchronized void updateAssignmentPlan(HRegionInfo region, List<ServerName> servers) {
        if (region == null || servers == null || servers.size() == 0) {
            return;
        }
        this.favoredNodesMap.put(region, servers);
        LOG.info("Update the assignment plan for region " + region.getRegionNameAsString() + " ; favored nodes " + FavoredNodeAssignmentHelper.getFavoredNodesAsString(servers));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Map<HRegionInfo, List<ServerName>> comparedMap = ((FavoredNodesPlan)o).getAssignmentMap();
        if (comparedMap.size() != this.favoredNodesMap.size()) {
            return false;
        }
        for (Map.Entry<HRegionInfo, List<ServerName>> entry2 : comparedMap.entrySet()) {
            List<ServerName> serverList = this.favoredNodesMap.get(entry2.getKey());
            if (serverList == null && entry2.getValue() != null) {
                return false;
            }
            if (serverList == null || serverList.equals(entry2.getValue())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.favoredNodesMap.hashCode();
    }

    public static enum Position {
        PRIMARY,
        SECONDARY,
        TERTIARY;

    }
}

