/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.ScriptBasedMapping;

@InterfaceAudience.Private
public class RackManager {
    static final Log LOG = LogFactory.getLog(RackManager.class);
    public static final String UNKNOWN_RACK = "Unknown Rack";
    private DNSToSwitchMapping switchMapping;

    public RackManager(Configuration conf) {
        this.switchMapping = (DNSToSwitchMapping)ReflectionUtils.instantiateWithCustomCtor(conf.getClass("hbase.util.ip.to.rack.determiner", ScriptBasedMapping.class, DNSToSwitchMapping.class).getName(), new Class[]{Configuration.class}, new Object[]{conf});
    }

    public String getRack(ServerName server) {
        if (server == null) {
            return UNKNOWN_RACK;
        }
        List<String> racks = this.switchMapping.resolve(Arrays.asList(server.getHostname()));
        if (racks != null && !racks.isEmpty()) {
            return racks.get(0);
        }
        return UNKNOWN_RACK;
    }
}

