/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.MetricsSnapshotSource;
import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.metrics2.lib.MutableHistogram;

@InterfaceAudience.Private
public class MetricsSnapshotSourceImpl
extends BaseSourceImpl
implements MetricsSnapshotSource {
    private MutableHistogram snapshotTimeHisto;
    private MutableHistogram snapshotCloneTimeHisto;
    private MutableHistogram snapshotRestoreTimeHisto;

    public MetricsSnapshotSourceImpl() {
        this("Snapshots", "Metrics about HBase master server", "master", "Master,sub=Snapshots");
    }

    public MetricsSnapshotSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
    }

    @Override
    public void init() {
        this.snapshotTimeHisto = this.metricsRegistry.newHistogram("snapshotTime", "Time it takes to finish snapshot()");
        this.snapshotCloneTimeHisto = this.metricsRegistry.newHistogram("snapshotCloneTime", "Time it takes to finish cloneSnapshot()");
        this.snapshotRestoreTimeHisto = this.metricsRegistry.newHistogram("snapshotRestoreTime", "Time it takes to finish restoreSnapshot()");
    }

    @Override
    public void updateSnapshotTime(long time) {
        this.snapshotTimeHisto.add(time);
    }

    @Override
    public void updateSnapshotCloneTime(long time) {
        this.snapshotCloneTimeHisto.add(time);
    }

    @Override
    public void updateSnapshotRestoreTime(long time) {
        this.snapshotRestoreTimeHisto.add(time);
    }
}

