/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.MetricsMasterFileSystemSource;
import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.metrics2.lib.MutableHistogram;

@InterfaceAudience.Private
public class MetricsMasterFilesystemSourceImpl
extends BaseSourceImpl
implements MetricsMasterFileSystemSource {
    private MutableHistogram splitSizeHisto;
    private MutableHistogram splitTimeHisto;
    private MutableHistogram metaSplitTimeHisto;
    private MutableHistogram metaSplitSizeHisto;

    public MetricsMasterFilesystemSourceImpl() {
        this("FileSystem", "Metrics about HBase master file system.", "master", "Master,sub=FileSystem");
    }

    public MetricsMasterFilesystemSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
    }

    @Override
    public void init() {
        this.splitSizeHisto = this.metricsRegistry.newHistogram("hlogSplitSize", "Size of HLog files being split");
        this.splitTimeHisto = this.metricsRegistry.newHistogram("hlogSplitTime", "Time it takes to finish HLog.splitLog()");
        this.metaSplitTimeHisto = this.metricsRegistry.newHistogram("metaHlogSplitTime", "Time it takes to finish splitMetaLog()");
        this.metaSplitSizeHisto = this.metricsRegistry.newHistogram("metaHlogSplitSize", "Size of hbase:meta HLog files being split");
    }

    @Override
    public void updateSplitTime(long time) {
        this.splitTimeHisto.add(time);
    }

    @Override
    public void updateSplitSize(long size2) {
        this.splitSizeHisto.add(size2);
    }

    @Override
    public void updateMetaWALSplitTime(long time) {
        this.metaSplitTimeHisto.add(time);
    }

    @Override
    public void updateMetaWALSplitSize(long size2) {
        this.metaSplitSizeHisto.add(size2);
    }
}

