/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.mapreduce.TableInputFormatBase;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class TableInputFormat
extends TableInputFormatBase
implements Configurable {
    private final Log LOG = LogFactory.getLog(TableInputFormat.class);
    public static final String INPUT_TABLE = "hbase.mapreduce.inputtable";
    private static final String SPLIT_TABLE = "hbase.mapreduce.splittable";
    public static final String SCAN = "hbase.mapreduce.scan";
    public static final String SCAN_ROW_START = "hbase.mapreduce.scan.row.start";
    public static final String SCAN_ROW_STOP = "hbase.mapreduce.scan.row.stop";
    public static final String SCAN_COLUMN_FAMILY = "hbase.mapreduce.scan.column.family";
    public static final String SCAN_COLUMNS = "hbase.mapreduce.scan.columns";
    public static final String SCAN_TIMESTAMP = "hbase.mapreduce.scan.timestamp";
    public static final String SCAN_TIMERANGE_START = "hbase.mapreduce.scan.timerange.start";
    public static final String SCAN_TIMERANGE_END = "hbase.mapreduce.scan.timerange.end";
    public static final String SCAN_MAXVERSIONS = "hbase.mapreduce.scan.maxversions";
    public static final String SCAN_CACHEBLOCKS = "hbase.mapreduce.scan.cacheblocks";
    public static final String SCAN_CACHEDROWS = "hbase.mapreduce.scan.cachedrows";
    public static final String SCAN_BATCHSIZE = "hbase.mapreduce.scan.batchsize";
    private Configuration conf = null;

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void setConf(Configuration configuration) {
        this.conf = configuration;
        String tableName = this.conf.get(INPUT_TABLE);
        try {
            this.setHTable(new HTable(new Configuration(this.conf), tableName));
        }
        catch (Exception e) {
            this.LOG.error(StringUtils.stringifyException(e));
        }
        Scan scan2 = null;
        if (this.conf.get(SCAN) != null) {
            try {
                scan2 = TableMapReduceUtil.convertStringToScan(this.conf.get(SCAN));
            }
            catch (IOException e) {
                this.LOG.error("An error occurred.", e);
            }
        } else {
            try {
                scan2 = new Scan();
                if (this.conf.get(SCAN_ROW_START) != null) {
                    scan2.setStartRow(Bytes.toBytes(this.conf.get(SCAN_ROW_START)));
                }
                if (this.conf.get(SCAN_ROW_STOP) != null) {
                    scan2.setStopRow(Bytes.toBytes(this.conf.get(SCAN_ROW_STOP)));
                }
                if (this.conf.get(SCAN_COLUMNS) != null) {
                    TableInputFormat.addColumns(scan2, this.conf.get(SCAN_COLUMNS));
                }
                if (this.conf.get(SCAN_COLUMN_FAMILY) != null) {
                    scan2.addFamily(Bytes.toBytes(this.conf.get(SCAN_COLUMN_FAMILY)));
                }
                if (this.conf.get(SCAN_TIMESTAMP) != null) {
                    scan2.setTimeStamp(Long.parseLong(this.conf.get(SCAN_TIMESTAMP)));
                }
                if (this.conf.get(SCAN_TIMERANGE_START) != null && this.conf.get(SCAN_TIMERANGE_END) != null) {
                    scan2.setTimeRange(Long.parseLong(this.conf.get(SCAN_TIMERANGE_START)), Long.parseLong(this.conf.get(SCAN_TIMERANGE_END)));
                }
                if (this.conf.get(SCAN_MAXVERSIONS) != null) {
                    scan2.setMaxVersions(Integer.parseInt(this.conf.get(SCAN_MAXVERSIONS)));
                }
                if (this.conf.get(SCAN_CACHEDROWS) != null) {
                    scan2.setCaching(Integer.parseInt(this.conf.get(SCAN_CACHEDROWS)));
                }
                if (this.conf.get(SCAN_BATCHSIZE) != null) {
                    scan2.setBatch(Integer.parseInt(this.conf.get(SCAN_BATCHSIZE)));
                }
                scan2.setCacheBlocks(this.conf.getBoolean(SCAN_CACHEBLOCKS, false));
            }
            catch (Exception e) {
                this.LOG.error(StringUtils.stringifyException(e));
            }
        }
        this.setScan(scan2);
    }

    private static void addColumn(Scan scan2, byte[] familyAndQualifier) {
        byte[][] fq = KeyValue.parseColumn(familyAndQualifier);
        if (fq.length == 1) {
            scan2.addFamily(fq[0]);
        } else if (fq.length == 2) {
            scan2.addColumn(fq[0], fq[1]);
        } else {
            throw new IllegalArgumentException("Invalid familyAndQualifier provided.");
        }
    }

    public static void addColumns(Scan scan2, byte[][] columns) {
        for (byte[] column : columns) {
            TableInputFormat.addColumn(scan2, column);
        }
    }

    private static void addColumns(Scan scan2, String columns) {
        String[] cols;
        for (String col : cols = columns.split(" ")) {
            TableInputFormat.addColumn(scan2, Bytes.toBytes(col));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Pair<byte[][], byte[][]> getStartEndKeys() throws IOException {
        if (this.conf.get(SPLIT_TABLE) != null) {
            TableName splitTableName = TableName.valueOf(this.conf.get(SPLIT_TABLE));
            HTable rl = new HTable(this.getConf(), splitTableName);
            try {
                Pair<byte[][], byte[][]> pair2 = rl.getStartEndKeys();
                return pair2;
            }
            finally {
                rl.close();
            }
        }
        return super.getStartEndKeys();
    }

    public static void configureSplitTable(Job job, TableName tableName) {
        job.getConfiguration().set(SPLIT_TABLE, tableName.getNameAsString());
    }
}

