/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class PutSortReducer
extends Reducer<ImmutableBytesWritable, Put, ImmutableBytesWritable, KeyValue> {
    @Override
    protected void reduce(ImmutableBytesWritable row, Iterable<Put> puts, Reducer.Context context) throws IOException, InterruptedException {
        long threshold = context.getConfiguration().getLong("putsortreducer.row.threshold", 0x40000000L);
        Iterator<Put> iter2 = puts.iterator();
        while (iter2.hasNext()) {
            TreeSet<Cell> map2 = new TreeSet<Cell>(KeyValue.COMPARATOR);
            long curSize = 0L;
            while (iter2.hasNext() && curSize < threshold) {
                Put p = iter2.next();
                for (List list2 : p.getFamilyCellMap().values()) {
                    for (Cell cell : list2) {
                        KeyValue kv = KeyValueUtil.ensureKeyValue(cell);
                        map2.add(kv);
                        curSize += kv.heapSize();
                    }
                }
            }
            context.setStatus("Read " + map2.size() + " entries of " + map2.getClass() + "(" + StringUtils.humanReadableInt(curSize) + ")");
            int index2 = 0;
            for (KeyValue keyValue : map2) {
                context.write(row, keyValue);
                if (++index2 % 100 != 0) continue;
                context.setStatus("Wrote " + index2);
            }
            if (!iter2.hasNext()) continue;
            context.write(null, null);
        }
    }
}

