/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.HFileOutputFormat;
import org.apache.hadoop.hbase.mapreduce.KeyValueSortReducer;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKClusterId;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class Import {
    private static final Log LOG = LogFactory.getLog(Import.class);
    static final String NAME = "import";
    public static final String CF_RENAME_PROP = "HBASE_IMPORTER_RENAME_CFS";
    public static final String BULK_OUTPUT_CONF_KEY = "import.bulk.output";
    public static final String FILTER_CLASS_CONF_KEY = "import.filter.class";
    public static final String FILTER_ARGS_CONF_KEY = "import.filter.args";
    public static final String TABLE_NAME = "import.table.name";
    public static final String WAL_DURABILITY = "import.wal.durability";

    public static Filter instantiateFilter(Configuration conf) {
        Class<Filter> filterClass = conf.getClass(FILTER_CLASS_CONF_KEY, null, Filter.class);
        if (filterClass == null) {
            LOG.debug("No configured filter class, accepting all keyvalues.");
            return null;
        }
        LOG.debug("Attempting to create filter:" + filterClass);
        String[] filterArgs = conf.getStrings(FILTER_ARGS_CONF_KEY);
        ArrayList<byte[]> quotedArgs = Import.toQuotedByteArrays(filterArgs);
        try {
            Method m = filterClass.getMethod("createFilterFromArguments", ArrayList.class);
            return (Filter)m.invoke(null, quotedArgs);
        }
        catch (IllegalAccessException e) {
            LOG.error("Couldn't instantiate filter!", e);
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            LOG.error("Couldn't instantiate filter!", e);
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            LOG.error("Couldn't instantiate filter!", e);
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            LOG.error("Couldn't instantiate filter!", e);
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            LOG.error("Couldn't instantiate filter!", e);
            throw new RuntimeException(e);
        }
    }

    private static ArrayList<byte[]> toQuotedByteArrays(String ... stringArgs) {
        ArrayList<byte[]> quotedArgs = new ArrayList<byte[]>();
        for (String stringArg : stringArgs) {
            quotedArgs.add(Bytes.toBytes("'" + stringArg + "'"));
        }
        return quotedArgs;
    }

    public static Cell filterKv(Filter filter2, Cell kv) throws IOException {
        if (filter2 != null) {
            Filter.ReturnCode code = filter2.filterKeyValue(kv);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Filter returned:" + (Object)((Object)code) + " for the key value:" + kv);
            }
            if (!code.equals((Object)Filter.ReturnCode.INCLUDE) && !code.equals((Object)Filter.ReturnCode.INCLUDE_AND_NEXT_COL)) {
                return null;
            }
        }
        return kv;
    }

    private static Cell convertKv(Cell kv, Map<byte[], byte[]> cfRenameMap) {
        byte[] newCfName;
        if (cfRenameMap != null && (newCfName = cfRenameMap.get(CellUtil.cloneFamily(kv))) != null) {
            kv = new KeyValue(kv.getRowArray(), kv.getRowOffset(), kv.getRowLength(), newCfName, 0, newCfName.length, kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength(), kv.getTimestamp(), KeyValue.Type.codeToType(kv.getTypeByte()), kv.getValueArray(), kv.getValueOffset(), kv.getValueLength());
        }
        return kv;
    }

    private static Map<byte[], byte[]> createCfRenameMap(Configuration conf) {
        TreeMap<byte[], byte[]> cfRenameMap = null;
        String allMappingsPropVal = conf.get(CF_RENAME_PROP);
        if (allMappingsPropVal != null) {
            String[] allMappings;
            for (String mapping : allMappings = allMappingsPropVal.split(",")) {
                String[] srcAndDest;
                if (cfRenameMap == null) {
                    cfRenameMap = new TreeMap<byte[], byte[]>(Bytes.BYTES_COMPARATOR);
                }
                if ((srcAndDest = mapping.split(":")).length != 2) continue;
                cfRenameMap.put(srcAndDest[0].getBytes(), srcAndDest[1].getBytes());
            }
        }
        return cfRenameMap;
    }

    public static void configureCfRenaming(Configuration conf, Map<String, String> renameMap) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry2 : renameMap.entrySet()) {
            String sourceCf = entry2.getKey();
            String destCf = entry2.getValue();
            if (sourceCf.contains(":") || sourceCf.contains(",") || destCf.contains(":") || destCf.contains(",")) {
                throw new IllegalArgumentException("Illegal character in CF names: " + sourceCf + ", " + destCf);
            }
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append(sourceCf + ":" + destCf);
        }
        conf.set(CF_RENAME_PROP, sb.toString());
    }

    public static void addFilterAndArguments(Configuration conf, Class<? extends Filter> clazz, List<String> filterArgs) throws IOException {
        conf.set(FILTER_CLASS_CONF_KEY, clazz.getName());
        conf.setStrings(FILTER_ARGS_CONF_KEY, filterArgs.toArray(new String[filterArgs.size()]));
    }

    public static Job createSubmittableJob(Configuration conf, String[] args) throws IOException {
        String tableName = args[0];
        conf.set(TABLE_NAME, tableName);
        Path inputDir = new Path(args[1]);
        Job job = new Job(conf, "import_" + tableName);
        job.setJarByClass(Importer.class);
        FileInputFormat.setInputPaths(job, inputDir);
        job.setInputFormatClass(SequenceFileInputFormat.class);
        String hfileOutPath = conf.get(BULK_OUTPUT_CONF_KEY);
        try {
            Class<Filter> filter2 = conf.getClass(FILTER_CLASS_CONF_KEY, null, Filter.class);
            if (filter2 != null) {
                TableMapReduceUtil.addDependencyJars(conf, filter2);
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        if (hfileOutPath != null) {
            job.setMapperClass(KeyValueImporter.class);
            HTable table = new HTable(conf, tableName);
            job.setReducerClass(KeyValueSortReducer.class);
            Path outputDir = new Path(hfileOutPath);
            FileOutputFormat.setOutputPath(job, outputDir);
            job.setMapOutputKeyClass(ImmutableBytesWritable.class);
            job.setMapOutputValueClass(KeyValue.class);
            HFileOutputFormat.configureIncrementalLoad(job, table);
            TableMapReduceUtil.addDependencyJars(job.getConfiguration(), Preconditions.class);
        } else {
            job.setMapperClass(Importer.class);
            TableMapReduceUtil.initTableReducerJob(tableName, null, job);
            job.setNumReduceTasks(0);
        }
        return job;
    }

    private static void usage(String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 0) {
            System.err.println("ERROR: " + errorMsg);
        }
        System.err.println("Usage: Import [options] <tablename> <inputdir>");
        System.err.println("By default Import will load data directly into HBase. To instead generate");
        System.err.println("HFiles of data to prepare for a bulk data load, pass the option:");
        System.err.println("  -Dimport.bulk.output=/path/for/output");
        System.err.println(" To apply a generic org.apache.hadoop.hbase.filter.Filter to the input, use");
        System.err.println("  -Dimport.filter.class=<name of filter class>");
        System.err.println("  -Dimport.filter.args=<comma separated list of args for filter");
        System.err.println(" NOTE: The filter will be applied BEFORE doing key renames via the HBASE_IMPORTER_RENAME_CFS property. Futher, filters will only use the Filter#filterRowKey(byte[] buffer, int offset, int length) method to identify  whether the current row needs to be ignored completely for processing and  Filter#filterKeyValue(KeyValue) method to determine if the KeyValue should be added; Filter.ReturnCode#INCLUDE and #INCLUDE_AND_NEXT_COL will be considered as including the KeyValue.");
        System.err.println("For performance consider the following options:\n  -Dmapred.map.tasks.speculative.execution=false\n  -Dmapred.reduce.tasks.speculative.execution=false\n  -Dimport.wal.durability=<Used while writing data to hbase. Allowed values are the supported durability values like SKIP_WAL/ASYNC_WAL/SYNC_WAL/...>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushRegionsIfNecessary(Configuration conf) throws IOException, InterruptedException {
        String tableName = conf.get(TABLE_NAME);
        HBaseAdmin hAdmin = null;
        String durability = conf.get(WAL_DURABILITY);
        if (conf.get(BULK_OUTPUT_CONF_KEY) == null && durability != null && Durability.SKIP_WAL.name().equalsIgnoreCase(durability)) {
            try {
                hAdmin = new HBaseAdmin(conf);
                hAdmin.flush(tableName);
            }
            finally {
                if (hAdmin != null) {
                    hAdmin.close();
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Job job;
        boolean isJobSuccessful;
        String inputVersionString;
        Configuration conf = HBaseConfiguration.create();
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        if (otherArgs.length < 2) {
            Import.usage("Wrong number of arguments: " + otherArgs.length);
            System.exit(-1);
        }
        if ((inputVersionString = System.getProperty("hbase.import.version")) != null) {
            conf.set("hbase.import.version", inputVersionString);
        }
        if (isJobSuccessful = (job = Import.createSubmittableJob(conf, otherArgs)).waitForCompletion(true)) {
            Import.flushRegionsIfNecessary(conf);
        }
        System.exit(job.waitForCompletion(true) ? 0 : 1);
    }

    public static class Importer
    extends TableMapper<ImmutableBytesWritable, Mutation> {
        private Map<byte[], byte[]> cfRenameMap;
        private List<UUID> clusterIds;
        private Filter filter;
        private Durability durability;

        @Override
        public void map(ImmutableBytesWritable row, Result value2, Mapper.Context context) throws IOException {
            try {
                this.writeResult(row, value2, context);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        private void writeResult(ImmutableBytesWritable key, Result result2, Mapper.Context context) throws IOException, InterruptedException {
            Put put2 = null;
            Delete delete2 = null;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Considering the row." + Bytes.toString(key.get(), key.getOffset(), key.getLength()));
            }
            if (this.filter == null || !this.filter.filterRowKey(key.get(), key.getOffset(), key.getLength())) {
                this.processKV(key, result2, context, put2, delete2);
            }
        }

        protected void processKV(ImmutableBytesWritable key, Result result2, Mapper.Context context, Put put2, Delete delete2) throws IOException, InterruptedException {
            for (Cell kv : result2.rawCells()) {
                if ((kv = Import.filterKv(this.filter, kv)) == null) continue;
                if (CellUtil.isDeleteFamily(kv = Import.convertKv(kv, this.cfRenameMap))) {
                    Delete deleteFamily = new Delete(key.get());
                    deleteFamily.addDeleteMarker(kv);
                    if (this.durability != null) {
                        deleteFamily.setDurability(this.durability);
                    }
                    deleteFamily.setClusterIds(this.clusterIds);
                    context.write(key, deleteFamily);
                    continue;
                }
                if (CellUtil.isDelete(kv)) {
                    if (delete2 == null) {
                        delete2 = new Delete(key.get());
                    }
                    delete2.addDeleteMarker(kv);
                    continue;
                }
                if (put2 == null) {
                    put2 = new Put(key.get());
                }
                this.addPutToKv(put2, kv);
            }
            if (put2 != null) {
                if (this.durability != null) {
                    put2.setDurability(this.durability);
                }
                put2.setClusterIds(this.clusterIds);
                context.write(key, put2);
            }
            if (delete2 != null) {
                if (this.durability != null) {
                    delete2.setDurability(this.durability);
                }
                delete2.setClusterIds(this.clusterIds);
                context.write(key, delete2);
            }
        }

        protected void addPutToKv(Put put2, Cell kv) throws IOException {
            put2.add(kv);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setup(Mapper.Context context) {
            Configuration conf = context.getConfiguration();
            this.cfRenameMap = Import.createCfRenameMap(conf);
            this.filter = Import.instantiateFilter(conf);
            String durabilityStr = conf.get(Import.WAL_DURABILITY);
            if (durabilityStr != null) {
                this.durability = Durability.valueOf(durabilityStr.toUpperCase());
            }
            ZooKeeperWatcher zkw = null;
            Exception ex = null;
            try {
                zkw = new ZooKeeperWatcher(conf, context.getTaskAttemptID().toString(), null);
                this.clusterIds = Collections.singletonList(ZKClusterId.getUUIDForCluster(zkw));
            }
            catch (ZooKeeperConnectionException e) {
                ex = e;
                LOG.error("Problem connecting to ZooKeper during task setup", e);
            }
            catch (KeeperException e) {
                ex = e;
                LOG.error("Problem reading ZooKeeper data during task setup", e);
            }
            catch (IOException e) {
                ex = e;
                LOG.error("Problem setting up task", e);
            }
            finally {
                if (zkw != null) {
                    zkw.close();
                }
            }
            if (this.clusterIds == null) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static class KeyValueImporter
    extends TableMapper<ImmutableBytesWritable, KeyValue> {
        private Map<byte[], byte[]> cfRenameMap;
        private Filter filter;
        private static final Log LOG = LogFactory.getLog(KeyValueImporter.class);

        @Override
        public void map(ImmutableBytesWritable row, Result value2, Mapper.Context context) throws IOException {
            try {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Considering the row." + Bytes.toString(row.get(), row.getOffset(), row.getLength()));
                }
                if (this.filter == null || !this.filter.filterRowKey(row.get(), row.getOffset(), row.getLength())) {
                    for (Cell kv : value2.rawCells()) {
                        if ((kv = Import.filterKv(this.filter, kv)) == null) continue;
                        context.write(row, KeyValueUtil.ensureKeyValue(Import.convertKv(kv, this.cfRenameMap)));
                    }
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void setup(Mapper.Context context) {
            this.cfRenameMap = Import.createCfRenameMap(context.getConfiguration());
            this.filter = Import.instantiateFilter(context.getConfiguration());
        }
    }
}

