/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.mapreduce.VisibilityExpressionResolver;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.security.visibility.VisibilityLabelOrdinalProvider;
import org.apache.hadoop.hbase.security.visibility.VisibilityUtils;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class DefaultVisibilityExpressionResolver
implements VisibilityExpressionResolver {
    private static final Log LOG = LogFactory.getLog(DefaultVisibilityExpressionResolver.class);
    private Configuration conf;
    private final Map<String, Integer> labels = new HashMap<String, Integer>();

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        HTable labelsTable = null;
        try {
            labelsTable = new HTable(this.conf, VisibilityConstants.LABELS_TABLE_NAME);
        }
        catch (TableNotFoundException e) {
            return;
        }
        catch (IOException e) {
            LOG.error("Error opening 'labels' table", e);
            return;
        }
        Scan scan2 = new Scan();
        scan2.setAuthorizations(new Authorizations("system"));
        scan2.addColumn(VisibilityConstants.LABELS_TABLE_FAMILY, VisibilityConstants.LABEL_QUALIFIER);
        ResultScanner scanner = null;
        try {
            scanner = labelsTable.getScanner(scan2);
            Result next2 = null;
            while ((next2 = scanner.next()) != null) {
                byte[] row = next2.getRow();
                byte[] value2 = next2.getValue(VisibilityConstants.LABELS_TABLE_FAMILY, VisibilityConstants.LABEL_QUALIFIER);
                this.labels.put(Bytes.toString(value2), Bytes.toInt(row));
            }
        }
        catch (IOException e) {
            LOG.error("Error reading 'labels' table", e);
        }
        finally {
            try {
                if (scanner != null) {
                    scanner.close();
                }
            }
            finally {
                try {
                    labelsTable.close();
                }
                catch (IOException e) {
                    LOG.warn("Error on closing 'labels' table", e);
                }
            }
        }
    }

    @Override
    public List<Tag> createVisibilityExpTags(String visExpression) throws IOException {
        VisibilityLabelOrdinalProvider provider = new VisibilityLabelOrdinalProvider(){

            @Override
            public int getLabelOrdinal(String label) {
                return (Integer)DefaultVisibilityExpressionResolver.this.labels.get(label);
            }

            @Override
            public String getLabel(int ordinal) {
                throw new UnsupportedOperationException("getLabel should not be used in VisibilityExpressionResolver");
            }
        };
        return VisibilityUtils.createVisibilityExpTags(visExpression, true, false, null, provider);
    }
}

