/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapred.InputSplit;

@Deprecated
@InterfaceAudience.Public
@InterfaceStability.Stable
public class TableSplit
implements InputSplit,
Comparable<TableSplit> {
    private TableName m_tableName;
    private byte[] m_startRow;
    private byte[] m_endRow;
    private String m_regionLocation;

    public TableSplit() {
        this((TableName)null, HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, "");
    }

    public TableSplit(TableName tableName, byte[] startRow, byte[] endRow, String location) {
        this.m_tableName = tableName;
        this.m_startRow = startRow;
        this.m_endRow = endRow;
        this.m_regionLocation = location;
    }

    public TableSplit(byte[] tableName, byte[] startRow, byte[] endRow, String location) {
        this(TableName.valueOf(tableName), startRow, endRow, location);
    }

    public TableName getTable() {
        return this.m_tableName;
    }

    public byte[] getTableName() {
        return this.m_tableName.getName();
    }

    public byte[] getStartRow() {
        return this.m_startRow;
    }

    public byte[] getEndRow() {
        return this.m_endRow;
    }

    public String getRegionLocation() {
        return this.m_regionLocation;
    }

    @Override
    public String[] getLocations() {
        return new String[]{this.m_regionLocation};
    }

    @Override
    public long getLength() {
        return 0L;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.m_tableName = TableName.valueOf(Bytes.readByteArray(in));
        this.m_startRow = Bytes.readByteArray(in);
        this.m_endRow = Bytes.readByteArray(in);
        this.m_regionLocation = Bytes.toString(Bytes.readByteArray(in));
    }

    @Override
    public void write(DataOutput out) throws IOException {
        Bytes.writeByteArray(out, this.m_tableName.getName());
        Bytes.writeByteArray(out, this.m_startRow);
        Bytes.writeByteArray(out, this.m_endRow);
        Bytes.writeByteArray(out, Bytes.toBytes(this.m_regionLocation));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HBase table split(");
        sb.append("table name: ").append(this.m_tableName);
        sb.append(", start row: ").append(Bytes.toStringBinary(this.m_startRow));
        sb.append(", end row: ").append(Bytes.toStringBinary(this.m_endRow));
        sb.append(", region location: ").append(this.m_regionLocation);
        sb.append(")");
        return sb.toString();
    }

    @Override
    public int compareTo(TableSplit o) {
        return Bytes.compareTo(this.getStartRow(), o.getStartRow());
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof TableSplit)) {
            return false;
        }
        TableSplit other = (TableSplit)o;
        return this.m_tableName.equals(other.m_tableName) && Bytes.equals(this.m_startRow, other.m_startRow) && Bytes.equals(this.m_endRow, other.m_endRow) && this.m_regionLocation.equals(other.m_regionLocation);
    }
}

