/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.ipc.MetricsHBaseServerSource;
import org.apache.hadoop.hbase.ipc.MetricsHBaseServerWrapper;
import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableHistogram;

@InterfaceAudience.Private
public class MetricsHBaseServerSourceImpl
extends BaseSourceImpl
implements MetricsHBaseServerSource {
    private final MetricsHBaseServerWrapper wrapper;
    private final MutableCounterLong authorizationSuccesses;
    private final MutableCounterLong authorizationFailures;
    private final MutableCounterLong authenticationSuccesses;
    private final MutableCounterLong authenticationFailures;
    private final MutableCounterLong sentBytes;
    private final MutableCounterLong receivedBytes;
    private MutableHistogram queueCallTime;
    private MutableHistogram processCallTime;

    public MetricsHBaseServerSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext, MetricsHBaseServerWrapper wrapper) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
        this.wrapper = wrapper;
        this.authorizationSuccesses = this.getMetricsRegistry().newCounter("authorizationSuccesses", "Number of authorization successes.", 0L);
        this.authorizationFailures = this.getMetricsRegistry().newCounter("authorizationFailures", "Number of authorization failures.", 0L);
        this.authenticationSuccesses = this.getMetricsRegistry().newCounter("authenticationSuccesses", "Number of authentication successes.", 0L);
        this.authenticationFailures = this.getMetricsRegistry().newCounter("authenticationFailures", "Number of authentication failures.", 0L);
        this.sentBytes = this.getMetricsRegistry().newCounter("sentBytes", "Number of bytes sent.", 0L);
        this.receivedBytes = this.getMetricsRegistry().newCounter("receivedBytes", "Number of bytes received.", 0L);
        this.queueCallTime = this.getMetricsRegistry().newHistogram("queueCallTime", "Queue Call Time.");
        this.processCallTime = this.getMetricsRegistry().newHistogram("processCallTime", "Processing call time.");
    }

    @Override
    public void authorizationSuccess() {
        this.authorizationSuccesses.incr();
    }

    @Override
    public void authorizationFailure() {
        this.authorizationFailures.incr();
    }

    @Override
    public void authenticationFailure() {
        this.authenticationFailures.incr();
    }

    @Override
    public void authenticationSuccess() {
        this.authenticationSuccesses.incr();
    }

    @Override
    public void sentBytes(long count2) {
        this.sentBytes.incr(count2);
    }

    @Override
    public void receivedBytes(int count2) {
        this.receivedBytes.incr(count2);
    }

    @Override
    public void dequeuedCall(int qTime) {
        this.queueCallTime.add(qTime);
    }

    @Override
    public void processedCall(int processingTime) {
        this.processCallTime.add(processingTime);
    }

    @Override
    public void getMetrics(MetricsCollector metricsCollector, boolean all) {
        MetricsRecordBuilder mrb = metricsCollector.addRecord(this.metricsName);
        if (this.wrapper != null) {
            mrb.addGauge(Interns.info("queueSize", "Number of bytes in the call queues."), this.wrapper.getTotalQueueSize()).addGauge(Interns.info("numCallsInGeneralQueue", "Number of calls in the general call queue."), this.wrapper.getGeneralQueueLength()).addGauge(Interns.info("numCallsInReplicationQueue", "Number of calls in the replication call queue."), this.wrapper.getReplicationQueueLength()).addGauge(Interns.info("numCallsInPriorityQueue", "Number of calls in the priority call queue."), this.wrapper.getPriorityQueueLength()).addGauge(Interns.info("numOpenConnections", "Number of open connections."), this.wrapper.getNumOpenConnections()).addGauge(Interns.info("numActiveHandler", "Number of active rpc handlers."), this.wrapper.getActiveRpcHandlerCount());
        }
        this.metricsRegistry.snapshot(mrb, all);
    }
}

