/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.RpcExecutor;
import org.apache.hadoop.hbase.util.ReflectionUtils;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor", "Phoenix"})
@InterfaceStability.Evolving
public class BalancedQueueRpcExecutor
extends RpcExecutor {
    protected final List<BlockingQueue<CallRunner>> queues;
    private final RpcExecutor.QueueBalancer balancer;

    public BalancedQueueRpcExecutor(String name, int handlerCount, int numQueues, int maxQueueLength) {
        this(name, handlerCount, numQueues, maxQueueLength, null, null);
    }

    public BalancedQueueRpcExecutor(String name, int handlerCount, int numQueues, int maxQueueLength, Configuration conf, Abortable abortable) {
        this(name, handlerCount, numQueues, conf, abortable, LinkedBlockingQueue.class, maxQueueLength);
    }

    public BalancedQueueRpcExecutor(String name, int handlerCount, int numQueues, Configuration conf, Abortable abortable, Class<? extends BlockingQueue> queueClass, Object ... initargs) {
        super(name, Math.max(handlerCount, numQueues), conf, abortable);
        this.queues = new ArrayList<BlockingQueue<CallRunner>>(numQueues);
        this.balancer = BalancedQueueRpcExecutor.getBalancer(numQueues);
        this.initializeQueues(numQueues, queueClass, initargs);
    }

    protected void initializeQueues(int numQueues, Class<? extends BlockingQueue> queueClass, Object ... initargs) {
        for (int i = 0; i < numQueues; ++i) {
            this.queues.add(ReflectionUtils.newInstance(queueClass, initargs));
        }
    }

    @Override
    public void dispatch(CallRunner callTask) throws InterruptedException {
        int queueIndex = this.balancer.getNextQueue();
        this.queues.get(queueIndex).put(callTask);
    }

    @Override
    public int getQueueLength() {
        int length = 0;
        for (BlockingQueue<CallRunner> queue : this.queues) {
            length += queue.size();
        }
        return length;
    }

    @Override
    public List<BlockingQueue<CallRunner>> getQueues() {
        return this.queues;
    }
}

