/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.util;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.util.Pair;

@InterfaceAudience.Private
public class StreamUtils {
    public static void writeRawVInt32(OutputStream output, int value2) throws IOException {
        while (true) {
            if ((value2 & 0xFFFFFF80) == 0) {
                output.write(value2);
                return;
            }
            output.write(value2 & 0x7F | 0x80);
            value2 >>>= 7;
        }
    }

    public static int readRawVarint32(InputStream input2) throws IOException {
        byte tmp = (byte)input2.read();
        if (tmp >= 0) {
            return tmp;
        }
        int result2 = tmp & 0x7F;
        tmp = (byte)input2.read();
        if (tmp >= 0) {
            result2 |= tmp << 7;
        } else {
            result2 |= (tmp & 0x7F) << 7;
            tmp = (byte)input2.read();
            if (tmp >= 0) {
                result2 |= tmp << 14;
            } else {
                result2 |= (tmp & 0x7F) << 14;
                tmp = (byte)input2.read();
                if (tmp >= 0) {
                    result2 |= tmp << 21;
                } else {
                    result2 |= (tmp & 0x7F) << 21;
                    tmp = (byte)input2.read();
                    result2 |= tmp << 28;
                    if (tmp < 0) {
                        for (int i = 0; i < 5; ++i) {
                            if (input2.read() < 0) continue;
                            return result2;
                        }
                        throw new IOException("Malformed varint");
                    }
                }
            }
        }
        return result2;
    }

    public static int readRawVarint32(ByteBuffer input2) throws IOException {
        byte tmp = input2.get();
        if (tmp >= 0) {
            return tmp;
        }
        int result2 = tmp & 0x7F;
        tmp = input2.get();
        if (tmp >= 0) {
            result2 |= tmp << 7;
        } else {
            result2 |= (tmp & 0x7F) << 7;
            tmp = input2.get();
            if (tmp >= 0) {
                result2 |= tmp << 14;
            } else {
                result2 |= (tmp & 0x7F) << 14;
                tmp = input2.get();
                if (tmp >= 0) {
                    result2 |= tmp << 21;
                } else {
                    result2 |= (tmp & 0x7F) << 21;
                    tmp = input2.get();
                    result2 |= tmp << 28;
                    if (tmp < 0) {
                        for (int i = 0; i < 5; ++i) {
                            if (input2.get() < 0) continue;
                            return result2;
                        }
                        throw new IOException("Malformed varint");
                    }
                }
            }
        }
        return result2;
    }

    public static Pair<Integer, Integer> readRawVarint32(byte[] input2, int offset) throws IOException {
        byte tmp;
        int newOffset = offset;
        if ((tmp = input2[newOffset++]) >= 0) {
            return new Pair<Integer, Integer>(Integer.valueOf(tmp), newOffset - offset);
        }
        int result2 = tmp & 0x7F;
        if ((tmp = input2[newOffset++]) >= 0) {
            result2 |= tmp << 7;
        } else {
            result2 |= (tmp & 0x7F) << 7;
            if ((tmp = input2[newOffset++]) >= 0) {
                result2 |= tmp << 14;
            } else {
                result2 |= (tmp & 0x7F) << 14;
                if ((tmp = input2[newOffset++]) >= 0) {
                    result2 |= tmp << 21;
                } else {
                    result2 |= (tmp & 0x7F) << 21;
                    tmp = input2[newOffset++];
                    result2 |= tmp << 28;
                    if (tmp < 0) {
                        for (int i = 0; i < 5; ++i) {
                            if ((tmp = input2[newOffset++]) < 0) continue;
                            return new Pair<Integer, Integer>(result2, newOffset - offset);
                        }
                        throw new IOException("Malformed varint");
                    }
                }
            }
        }
        return new Pair<Integer, Integer>(result2, newOffset - offset);
    }

    public static short toShort(byte hi, byte lo) {
        short s2 = (short)((hi & 0xFF) << 8 | lo & 0xFF);
        Preconditions.checkArgument(s2 >= 0);
        return s2;
    }

    public static void writeShort(OutputStream out, short v) throws IOException {
        Preconditions.checkArgument(v >= 0);
        out.write((byte)(0xFF & v >> 8));
        out.write((byte)(0xFF & v));
    }
}

