/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.slab;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.BlockCacheUtil;
import org.apache.hadoop.hbase.io.hfile.BlockPriority;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheStats;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.CachedBlock;
import org.apache.hadoop.hbase.io.hfile.slab.SingleSizeCache;
import org.apache.hadoop.hbase.io.hfile.slab.SlabItemActionWatcher;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.HasThread;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
@Deprecated
public class SlabCache
implements SlabItemActionWatcher,
BlockCache,
HeapSize {
    private final ConcurrentHashMap<BlockCacheKey, SingleSizeCache> backingStore;
    private final TreeMap<Integer, SingleSizeCache> slabs;
    static final Log LOG = LogFactory.getLog(SlabCache.class);
    static final int STAT_THREAD_PERIOD_SECS = 300;
    private final ScheduledExecutorService scheduleThreadPool = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Slab Statistics #%d").build());
    long size;
    private final CacheStats stats;
    final SlabStats requestStats;
    final SlabStats successfullyCachedStats;
    private final long avgBlockSize;
    private static final long CACHE_FIXED_OVERHEAD = ClassSize.estimateBase(SlabCache.class, false);

    public SlabCache(long size2, long avgBlockSize) {
        this.avgBlockSize = avgBlockSize;
        this.size = size2;
        this.stats = new CacheStats();
        this.requestStats = new SlabStats();
        this.successfullyCachedStats = new SlabStats();
        this.backingStore = new ConcurrentHashMap();
        this.slabs = new TreeMap();
        this.scheduleThreadPool.scheduleAtFixedRate(new StatisticsThread(this), 300L, 300L, TimeUnit.SECONDS);
    }

    public Map<Integer, SingleSizeCache> getSizer() {
        return this.slabs;
    }

    public void addSlabByConf(Configuration conf) {
        String[] sizes;
        String[] porportions = conf.getStrings("hbase.offheapcache.slab.proportions", "0.80", "0.20");
        if (porportions.length != (sizes = conf.getStrings("hbase.offheapcache.slab.sizes", Long.valueOf(this.avgBlockSize * 11L / 10L).toString(), Long.valueOf(this.avgBlockSize * 21L / 10L).toString())).length) {
            throw new IllegalArgumentException("SlabCache conf not initialized, error in configuration. hbase.offheap.slab.proportions specifies " + porportions.length + " slabs while hbase.offheap.slab.sizes specifies " + sizes.length + " slabs " + "offheapslabporportions and offheapslabsizes");
        }
        BigDecimal[] parsedProportions = this.stringArrayToBigDecimalArray(porportions);
        BigDecimal[] parsedSizes = this.stringArrayToBigDecimalArray(sizes);
        BigDecimal sumProportions = new BigDecimal(0);
        for (BigDecimal b : parsedProportions) {
            Preconditions.checkArgument(b.compareTo(BigDecimal.ZERO) == 1, "Proportions in hbase.offheap.slab.proportions must be greater than 0!");
            sumProportions = sumProportions.add(b);
        }
        Preconditions.checkArgument(sumProportions.compareTo(BigDecimal.ONE) != 1, "Sum of all proportions in hbase.offheap.slab.proportions must be less than 1");
        if (sumProportions.compareTo(new BigDecimal("0.99")) == -1) {
            LOG.warn("Sum of hbase.offheap.slab.proportions is less than 0.99! Memory is being wasted");
        }
        for (int i = 0; i < parsedProportions.length; ++i) {
            int blockSize = parsedSizes[i].intValue();
            int numBlocks = new BigDecimal(this.size).multiply(parsedProportions[i]).divide(parsedSizes[i], 1).intValue();
            this.addSlab(blockSize, numBlocks);
        }
    }

    Map.Entry<Integer, SingleSizeCache> getHigherBlock(int size2) {
        return this.slabs.higherEntry(size2 - 1);
    }

    private BigDecimal[] stringArrayToBigDecimalArray(String[] parsee) {
        BigDecimal[] parsed = new BigDecimal[parsee.length];
        for (int i = 0; i < parsee.length; ++i) {
            parsed[i] = new BigDecimal(parsee[i].trim());
        }
        return parsed;
    }

    private void addSlab(int blockSize, int numBlocks) {
        LOG.info("Creating a slab of blockSize " + blockSize + " with " + numBlocks + " blocks, " + StringUtils.humanReadableInt((long)blockSize * (long)numBlocks) + "bytes.");
        this.slabs.put(blockSize, new SingleSizeCache(blockSize, numBlocks, this));
    }

    @Override
    public void cacheBlock(BlockCacheKey cacheKey, Cacheable cachedItem) {
        Map.Entry<Integer, SingleSizeCache> scacheEntry = this.getHigherBlock(cachedItem.getSerializedLength());
        this.requestStats.addin(cachedItem.getSerializedLength());
        if (scacheEntry == null) {
            return;
        }
        this.successfullyCachedStats.addin(cachedItem.getSerializedLength());
        SingleSizeCache scache = scacheEntry.getValue();
        scache.cacheBlock(cacheKey, cachedItem);
    }

    @Override
    public void cacheBlock(BlockCacheKey cacheKey, Cacheable buf, boolean inMemory) {
        this.cacheBlock(cacheKey, buf);
    }

    @Override
    public CacheStats getStats() {
        return this.stats;
    }

    @Override
    public Cacheable getBlock(BlockCacheKey key, boolean caching, boolean repeat, boolean updateCacheMetrics) {
        SingleSizeCache cachedBlock = this.backingStore.get(key);
        if (cachedBlock == null) {
            if (!repeat) {
                this.stats.miss(caching);
            }
            return null;
        }
        Cacheable contentBlock = cachedBlock.getBlock(key, caching, false, updateCacheMetrics);
        if (contentBlock != null) {
            if (updateCacheMetrics) {
                this.stats.hit(caching);
            }
        } else if (!repeat && updateCacheMetrics) {
            this.stats.miss(caching);
        }
        return contentBlock;
    }

    @Override
    public boolean evictBlock(BlockCacheKey cacheKey) {
        SingleSizeCache cacheEntry = this.backingStore.get(cacheKey);
        if (cacheEntry == null) {
            return false;
        }
        cacheEntry.evictBlock(cacheKey);
        return true;
    }

    @Override
    public void onEviction(BlockCacheKey key, SingleSizeCache notifier) {
        this.stats.evicted();
        this.backingStore.remove(key);
    }

    @Override
    public void onInsertion(BlockCacheKey key, SingleSizeCache notifier) {
        this.backingStore.put(key, notifier);
    }

    @Override
    public void shutdown() {
        for (SingleSizeCache s2 : this.slabs.values()) {
            s2.shutdown();
        }
        this.scheduleThreadPool.shutdown();
    }

    @Override
    public long heapSize() {
        long childCacheSize = 0L;
        for (SingleSizeCache s2 : this.slabs.values()) {
            childCacheSize += s2.heapSize();
        }
        return CACHE_FIXED_OVERHEAD + childCacheSize;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public long getFreeSize() {
        long childFreeSize = 0L;
        for (SingleSizeCache s2 : this.slabs.values()) {
            childFreeSize += s2.getFreeSize();
        }
        return childFreeSize;
    }

    @Override
    public long getBlockCount() {
        long count2 = 0L;
        for (SingleSizeCache cache : this.slabs.values()) {
            count2 += cache.getBlockCount();
        }
        return count2;
    }

    @Override
    public long getCurrentSize() {
        return this.size;
    }

    public long getEvictedCount() {
        return this.stats.getEvictedCount();
    }

    @Override
    public int evictBlocksByHfileName(String hfileName) {
        int numEvicted = 0;
        for (BlockCacheKey key : this.backingStore.keySet()) {
            if (!key.getHfileName().equals(hfileName) || !this.evictBlock(key)) continue;
            ++numEvicted;
        }
        return numEvicted;
    }

    @Override
    public Iterator<CachedBlock> iterator() {
        final Iterator<Map.Entry<BlockCacheKey, SingleSizeCache>> i = this.backingStore.entrySet().iterator();
        return new Iterator<CachedBlock>(){
            private final long now = System.nanoTime();

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public CachedBlock next() {
                final Map.Entry e = (Map.Entry)i.next();
                final Cacheable cacheable = ((SingleSizeCache)e.getValue()).getBlock((BlockCacheKey)e.getKey(), false, false, false);
                return new CachedBlock(){

                    public String toString() {
                        return BlockCacheUtil.toString(this, now);
                    }

                    @Override
                    public BlockPriority getBlockPriority() {
                        return null;
                    }

                    @Override
                    public BlockType getBlockType() {
                        return cacheable.getBlockType();
                    }

                    @Override
                    public long getOffset() {
                        return ((BlockCacheKey)e.getKey()).getOffset();
                    }

                    @Override
                    public long getSize() {
                        return cacheable == null ? 0L : (long)cacheable.getSerializedLength();
                    }

                    @Override
                    public long getCachedTime() {
                        return -1L;
                    }

                    @Override
                    public String getFilename() {
                        return ((BlockCacheKey)e.getKey()).getHfileName();
                    }

                    @Override
                    public int compareTo(CachedBlock other) {
                        return (int)(this.getOffset() - other.getOffset());
                    }
                };
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public BlockCache[] getBlockCaches() {
        return null;
    }

    static class SlabStats {
        static final int MULTIPLIER = 10;
        final int NUMDIVISIONS = (int)(Math.log(2.147483647E9) * 10.0);
        private final AtomicLong[] counts = new AtomicLong[this.NUMDIVISIONS];

        public SlabStats() {
            for (int i = 0; i < this.NUMDIVISIONS; ++i) {
                this.counts[i] = new AtomicLong();
            }
        }

        public void addin(int size2) {
            int index2 = (int)(Math.log(size2) * 10.0);
            this.counts[index2].incrementAndGet();
        }

        public AtomicLong[] getUsage() {
            return this.counts;
        }

        double getUpperBound(int index2) {
            return Math.pow(Math.E, ((double)index2 + 0.5) / 10.0);
        }

        double getLowerBound(int index2) {
            return Math.pow(Math.E, ((double)index2 - 0.5) / 10.0);
        }

        public void logStats() {
            AtomicLong[] fineGrainedStats = this.getUsage();
            for (int i = 0; i < fineGrainedStats.length; ++i) {
                if (fineGrainedStats[i].get() <= 0L) continue;
                LOG.info("From  " + StringUtils.humanReadableInt((long)this.getLowerBound(i)) + "- " + StringUtils.humanReadableInt((long)this.getUpperBound(i)) + ": " + StringUtils.humanReadableInt(fineGrainedStats[i].get()) + " requests");
            }
        }
    }

    static class StatisticsThread
    extends HasThread {
        SlabCache ourcache;

        public StatisticsThread(SlabCache slabCache) {
            super("SlabCache.StatisticsThread");
            this.setDaemon(true);
            this.ourcache = slabCache;
        }

        @Override
        public void run() {
            for (SingleSizeCache s2 : this.ourcache.slabs.values()) {
                s2.logStats();
            }
            LOG.info("Current heap size is: " + StringUtils.humanReadableInt(this.ourcache.heapSize()));
            LOG.info("Request Stats");
            this.ourcache.requestStats.logStats();
            LOG.info("Successfully Cached Stats");
            this.ourcache.successfullyCachedStats.logStats();
        }
    }
}

