/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.slab;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.DirectMemoryUtils;

@InterfaceAudience.Private
@Deprecated
class Slab
implements HeapSize {
    static final Log LOG = LogFactory.getLog(Slab.class);
    private LinkedBlockingQueue<ByteBuffer> buffers = new LinkedBlockingQueue();
    private ConcurrentLinkedQueue<ByteBuffer> slabs = new ConcurrentLinkedQueue();
    private final int blockSize;
    private final int numBlocks;
    private long heapSize;

    Slab(int blockSize, int numBlocks) {
        this.blockSize = blockSize;
        this.numBlocks = numBlocks;
        this.heapSize = ClassSize.estimateBase(this.getClass(), false);
        int maxBlocksPerSlab = Integer.MAX_VALUE / blockSize;
        int maxSlabSize = maxBlocksPerSlab * blockSize;
        int numFullSlabs = numBlocks / maxBlocksPerSlab;
        int partialSlabSize = numBlocks % maxBlocksPerSlab * blockSize;
        for (int i = 0; i < numFullSlabs; ++i) {
            this.allocateAndSlice(maxSlabSize, blockSize);
        }
        if (partialSlabSize > 0) {
            this.allocateAndSlice(partialSlabSize, blockSize);
        }
    }

    private void allocateAndSlice(int size2, int sliceSize) {
        ByteBuffer newSlab = ByteBuffer.allocateDirect(size2);
        this.slabs.add(newSlab);
        for (int j = 0; j < newSlab.capacity(); j += sliceSize) {
            newSlab.limit(j + sliceSize).position(j);
            ByteBuffer aSlice = newSlab.slice();
            this.buffers.add(aSlice);
            this.heapSize += ClassSize.estimateBase(aSlice.getClass(), false);
        }
    }

    void shutdown() {
        for (ByteBuffer aSlab : this.slabs) {
            try {
                DirectMemoryUtils.destroyDirectByteBuffer(aSlab);
            }
            catch (Exception e) {
                LOG.warn("Unable to deallocate direct memory during shutdown", e);
            }
        }
    }

    int getBlockSize() {
        return this.blockSize;
    }

    int getBlockCapacity() {
        return this.numBlocks;
    }

    int getBlocksRemaining() {
        return this.buffers.size();
    }

    ByteBuffer alloc(int bufferSize) throws InterruptedException {
        int newCapacity = Preconditions.checkPositionIndex(bufferSize, this.blockSize);
        ByteBuffer returnedBuffer = this.buffers.take();
        returnedBuffer.clear().limit(newCapacity);
        return returnedBuffer;
    }

    void free(ByteBuffer toBeFreed) {
        Preconditions.checkArgument(toBeFreed.capacity() == this.blockSize);
        this.buffers.add(toBeFreed);
    }

    @Override
    public long heapSize() {
        return this.heapSize;
    }
}

