/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.Checksum;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ChecksumType;

public class ChecksumUtil {
    private static byte[] DUMMY_VALUE = new byte[512];
    private static boolean generateExceptions = false;

    static void generateChecksums(byte[] indata, int startOffset, int endOffset, byte[] outdata, int outOffset, ChecksumType checksumType, int bytesPerChecksum) throws IOException {
        int count2;
        if (checksumType == ChecksumType.NULL) {
            return;
        }
        Checksum checksum = checksumType.getChecksumObject();
        int chunkNum = 0;
        for (int bytesLeft = endOffset - startOffset; bytesLeft > 0; bytesLeft -= count2) {
            checksum.reset();
            count2 = Math.min(bytesLeft, bytesPerChecksum);
            checksum.update(indata, startOffset, count2);
            int cksumValue = (int)checksum.getValue();
            outOffset = Bytes.putInt(outdata, outOffset, cksumValue);
            ++chunkNum;
            startOffset += count2;
        }
    }

    static boolean validateBlockChecksum(Path path, HFileBlock block, byte[] data2, int hdrSize) throws IOException {
        if (!block.getHFileContext().isUseHBaseChecksum()) {
            return false;
        }
        ChecksumType cktype = ChecksumType.codeToType(block.getChecksumType());
        if (cktype == ChecksumType.NULL) {
            return true;
        }
        Checksum checksumObject = cktype.getChecksumObject();
        checksumObject.reset();
        int bytesPerChecksum = block.getBytesPerChecksum();
        if (bytesPerChecksum < hdrSize) {
            String msg = "Unsupported value of bytesPerChecksum.  Minimum is " + hdrSize + " but the configured value is " + bytesPerChecksum;
            HFile.LOG.warn(msg);
            return false;
        }
        ByteBuffer hdr = block.getBufferWithHeader();
        checksumObject.update(hdr.array(), hdr.arrayOffset(), hdrSize);
        int off = hdrSize;
        int consumed = hdrSize;
        int bytesLeft = block.getOnDiskDataSizeWithHeader() - off;
        int cksumOffset = block.getOnDiskDataSizeWithHeader();
        while (bytesLeft > 0) {
            int thisChunkSize = bytesPerChecksum - consumed;
            int count2 = Math.min(bytesLeft, thisChunkSize);
            checksumObject.update(data2, off, count2);
            int storedChecksum = Bytes.toInt(data2, cksumOffset);
            if (storedChecksum != (int)checksumObject.getValue()) {
                String msg = "File " + path + " Stored checksum value of " + storedChecksum + " at offset " + cksumOffset + " does not match computed checksum " + checksumObject.getValue() + ", total data size " + data2.length + " Checksum data range offset " + off + " len " + count2 + HFileBlock.toStringHeader(block.getBufferReadOnly());
                HFile.LOG.warn(msg);
                if (generateExceptions) {
                    throw new IOException(msg);
                }
                return false;
            }
            cksumOffset += 4;
            bytesLeft -= count2;
            off += count2;
            consumed = 0;
            checksumObject.reset();
        }
        return true;
    }

    static long numBytes(long datasize, int bytesPerChecksum) {
        return ChecksumUtil.numChunks(datasize, bytesPerChecksum) * 4L;
    }

    static long numChunks(long datasize, int bytesPerChecksum) {
        long numChunks = datasize / (long)bytesPerChecksum;
        if (datasize % (long)bytesPerChecksum != 0L) {
            ++numChunks;
        }
        return numChunks;
    }

    static void reserveSpaceForChecksums(ByteArrayOutputStream baos, int numBytes, int bytesPerChecksum) throws IOException {
        long count2;
        long numChunks = ChecksumUtil.numChunks(numBytes, bytesPerChecksum);
        for (long bytesLeft = numChunks * 4L; bytesLeft > 0L; bytesLeft -= count2) {
            count2 = Math.min(bytesLeft, (long)DUMMY_VALUE.length);
            baos.write(DUMMY_VALUE, 0, (int)count2);
        }
    }

    public static void generateExceptionForChecksumFailureForTest(boolean value2) {
        generateExceptions = value2;
    }
}

