/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.CacheableDeserializer;

@InterfaceAudience.Private
public class CacheableDeserializerIdManager {
    private static final Map<Integer, CacheableDeserializer<Cacheable>> registeredDeserializers = new HashMap<Integer, CacheableDeserializer<Cacheable>>();
    private static final AtomicInteger identifier = new AtomicInteger(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int registerDeserializer(CacheableDeserializer<Cacheable> cd) {
        int idx = identifier.incrementAndGet();
        Map<Integer, CacheableDeserializer<Cacheable>> map2 = registeredDeserializers;
        synchronized (map2) {
            registeredDeserializers.put(idx, cd);
        }
        return idx;
    }

    public static CacheableDeserializer<Cacheable> getDeserializer(int id) {
        return registeredDeserializers.get(id);
    }
}

