/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.commons.lang.NotImplementedException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.encoding.HFileBlockEncodingContext;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.compress.Compressor;

@InterfaceAudience.Private
public class EncodedDataBlock {
    private byte[] rawKVs;
    private ByteBuffer rawBuffer;
    private DataBlockEncoder dataBlockEncoder;
    private byte[] cachedEncodedData;
    private final HFileBlockEncodingContext encodingCtx;
    private HFileContext meta;

    public EncodedDataBlock(DataBlockEncoder dataBlockEncoder, DataBlockEncoding encoding, byte[] rawKVs, HFileContext meta) {
        Preconditions.checkNotNull(encoding, "Cannot create encoded data block with null encoder");
        this.dataBlockEncoder = dataBlockEncoder;
        this.encodingCtx = dataBlockEncoder.newDataBlockEncodingContext(encoding, HConstants.HFILEBLOCK_DUMMY_HEADER, meta);
        this.rawKVs = rawKVs;
        this.meta = meta;
    }

    public Iterator<Cell> getIterator(int headerSize) {
        final int rawSize = this.rawKVs.length;
        byte[] encodedDataWithHeader = this.getEncodedData();
        int bytesToSkip = headerSize + 2;
        ByteArrayInputStream bais = new ByteArrayInputStream(encodedDataWithHeader, bytesToSkip, encodedDataWithHeader.length - bytesToSkip);
        final DataInputStream dis = new DataInputStream(bais);
        return new Iterator<Cell>(){
            private ByteBuffer decompressedData = null;

            @Override
            public boolean hasNext() {
                if (this.decompressedData == null) {
                    return rawSize > 0;
                }
                return this.decompressedData.hasRemaining();
            }

            @Override
            public Cell next() {
                if (this.decompressedData == null) {
                    try {
                        this.decompressedData = EncodedDataBlock.this.dataBlockEncoder.decodeKeyValues(dis, EncodedDataBlock.this.dataBlockEncoder.newDataBlockDecodingContext(EncodedDataBlock.this.meta));
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Problem with data block encoder, most likely it requested more bytes than are available.", e);
                    }
                    this.decompressedData.rewind();
                }
                int offset = this.decompressedData.position();
                int klen = this.decompressedData.getInt();
                int vlen = this.decompressedData.getInt();
                int tagsLen = 0;
                ByteBufferUtils.skip(this.decompressedData, klen + vlen);
                if (EncodedDataBlock.this.meta.isIncludesTags()) {
                    tagsLen = (this.decompressedData.get() & 0xFF) << 8 ^ this.decompressedData.get() & 0xFF;
                    ByteBufferUtils.skip(this.decompressedData, tagsLen);
                }
                KeyValue kv = new KeyValue(this.decompressedData.array(), offset, (int)KeyValue.getKeyValueDataStructureSize(klen, vlen, tagsLen));
                if (EncodedDataBlock.this.meta.isIncludesMvcc()) {
                    long mvccVersion = ByteBufferUtils.readVLong(this.decompressedData);
                    kv.setMvccVersion(mvccVersion);
                }
                return kv;
            }

            @Override
            public void remove() {
                throw new NotImplementedException("remove() is not supported!");
            }

            public String toString() {
                return "Iterator of: " + EncodedDataBlock.this.dataBlockEncoder.getClass().getName();
            }
        };
    }

    public int getSize() {
        return this.getEncodedData().length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCompressedSize(Compression.Algorithm algo, Compressor compressor, byte[] inputBuffer, int offset, int length) throws IOException {
        DataOutputStream compressedStream = new DataOutputStream(new IOUtils.NullOutputStream());
        if (compressor != null) {
            compressor.reset();
        }
        OutputStream compressingStream = null;
        try {
            compressingStream = algo.createCompressionStream(compressedStream, compressor, 0);
            compressingStream.write(inputBuffer, offset, length);
            compressingStream.flush();
            int n = compressedStream.size();
            return n;
        }
        finally {
            if (compressingStream != null) {
                compressingStream.close();
            }
        }
    }

    public int getEncodedCompressedSize(Compression.Algorithm comprAlgo, Compressor compressor) throws IOException {
        byte[] compressedBytes = this.getEncodedData();
        return EncodedDataBlock.getCompressedSize(comprAlgo, compressor, compressedBytes, 0, compressedBytes.length);
    }

    private byte[] getEncodedData() {
        if (this.cachedEncodedData != null) {
            return this.cachedEncodedData;
        }
        this.cachedEncodedData = this.encodeData();
        return this.cachedEncodedData;
    }

    private ByteBuffer getUncompressedBuffer() {
        if (this.rawBuffer == null || this.rawBuffer.limit() < this.rawKVs.length) {
            this.rawBuffer = ByteBuffer.wrap(this.rawKVs);
        }
        return this.rawBuffer;
    }

    public byte[] encodeData() {
        try {
            this.dataBlockEncoder.encodeKeyValues(this.getUncompressedBuffer(), this.encodingCtx);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Bug in encoding part of algorithm %s. Probably it requested more bytes than are available.", this.toString()), e);
        }
        return this.encodingCtx.getUncompressedBytesWithHeader();
    }

    public String toString() {
        return this.dataBlockEncoder.toString();
    }
}

