/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.encoding.BufferedDataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.CompressionState;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.EncoderBufferTooSmallException;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDecodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultDecodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultEncodingContext;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class DiffKeyDeltaEncoder
extends BufferedDataBlockEncoder {
    static final int FLAG_SAME_KEY_LENGTH = 1;
    static final int FLAG_SAME_VALUE_LENGTH = 2;
    static final int FLAG_SAME_TYPE = 4;
    static final int FLAG_TIMESTAMP_IS_DIFF = 8;
    static final int MASK_TIMESTAMP_LENGTH = 112;
    static final int SHIFT_TIMESTAMP_LENGTH = 4;
    static final int FLAG_TIMESTAMP_SIGN = 128;

    private void compressSingleKeyValue(DiffCompressionState previousState, DiffCompressionState currentState, DataOutputStream out, ByteBuffer in) throws IOException {
        int commonPrefix;
        int timestampFitsInBytes;
        long timestamp;
        int flag = 0;
        int kvPos = in.position();
        int keyLength = in.getInt();
        int valueLength = in.getInt();
        long diffTimestamp = 0L;
        int diffTimestampFitsInBytes = 0;
        if (previousState.isFirst()) {
            currentState.readKey(in, keyLength, valueLength);
            currentState.prevOffset = kvPos;
            timestamp = currentState.timestamp;
            if (timestamp < 0L) {
                flag = (byte)(flag | 0x80);
                timestamp = -timestamp;
            }
            timestampFitsInBytes = ByteBufferUtils.longFitsIn(timestamp);
            flag = (byte)(flag | timestampFitsInBytes - 1 << 4);
            commonPrefix = 0;
            in.mark();
            ByteBufferUtils.skip(in, currentState.rowLength + 2);
            ByteBufferUtils.moveBufferToStream(out, in, currentState.familyLength + 1);
            in.reset();
        } else {
            boolean minusDiffTimestamp;
            boolean negativeTimestamp;
            commonPrefix = ByteBufferUtils.findCommonPrefix(in, in.position(), previousState.prevOffset + 8, keyLength - 9);
            currentState.readKey(in, keyLength, valueLength, commonPrefix, previousState);
            currentState.prevOffset = kvPos;
            timestamp = currentState.timestamp;
            boolean bl = negativeTimestamp = timestamp < 0L;
            if (negativeTimestamp) {
                timestamp = -timestamp;
            }
            timestampFitsInBytes = ByteBufferUtils.longFitsIn(timestamp);
            if (keyLength == previousState.keyLength) {
                flag = (byte)(flag | 1);
            }
            if (valueLength == previousState.valueLength) {
                flag = (byte)(flag | 2);
            }
            if (currentState.type == previousState.type) {
                flag = (byte)(flag | 4);
            }
            boolean bl2 = minusDiffTimestamp = (diffTimestamp = previousState.timestamp - currentState.timestamp) < 0L;
            if (minusDiffTimestamp) {
                diffTimestamp = -diffTimestamp;
            }
            if ((diffTimestampFitsInBytes = ByteBufferUtils.longFitsIn(diffTimestamp)) < timestampFitsInBytes) {
                flag = (byte)(flag | diffTimestampFitsInBytes - 1 << 4);
                flag = (byte)(flag | 8);
                if (minusDiffTimestamp) {
                    flag = (byte)(flag | 0x80);
                }
            } else {
                flag = (byte)(flag | timestampFitsInBytes - 1 << 4);
                if (negativeTimestamp) {
                    flag = (byte)(flag | 0x80);
                }
            }
        }
        out.write(flag);
        if ((flag & 1) == 0) {
            ByteBufferUtils.putCompressedInt(out, keyLength);
        }
        if ((flag & 2) == 0) {
            ByteBufferUtils.putCompressedInt(out, valueLength);
        }
        ByteBufferUtils.putCompressedInt(out, commonPrefix);
        ByteBufferUtils.skip(in, commonPrefix);
        if (previousState.isFirst() || commonPrefix < currentState.rowLength + 2) {
            int restRowLength = currentState.rowLength + 2 - commonPrefix;
            ByteBufferUtils.moveBufferToStream(out, in, restRowLength);
            ByteBufferUtils.skip(in, currentState.familyLength + 1);
            ByteBufferUtils.moveBufferToStream(out, in, currentState.qualifierLength);
        } else {
            ByteBufferUtils.moveBufferToStream(out, in, keyLength - commonPrefix - 9);
        }
        if ((flag & 8) == 0) {
            ByteBufferUtils.putLong(out, timestamp, timestampFitsInBytes);
        } else {
            ByteBufferUtils.putLong(out, diffTimestamp, diffTimestampFitsInBytes);
        }
        if ((flag & 4) == 0) {
            out.write(currentState.type);
        }
        ByteBufferUtils.skip(in, 9);
        ByteBufferUtils.moveBufferToStream(out, in, valueLength);
    }

    private void uncompressSingleKeyValue(DataInputStream source, ByteBuffer buffer, DiffCompressionState state) throws IOException, EncoderBufferTooSmallException {
        int keyRestLength;
        byte flag;
        if (state.isFirst()) {
            state.familyLength = source.readByte();
            state.familyNameWithSize = new byte[(state.familyLength & 0xFF) + 1];
            state.familyNameWithSize[0] = state.familyLength;
            int read2 = source.read(state.familyNameWithSize, 1, state.familyLength);
            assert (read2 == state.familyLength);
        }
        int keyLength = ((flag = source.readByte()) & 1) != 0 ? state.keyLength : ByteBufferUtils.readCompressedInt(source);
        int valueLength = (flag & 2) != 0 ? state.valueLength : ByteBufferUtils.readCompressedInt(source);
        int commonPrefix = ByteBufferUtils.readCompressedInt(source);
        int keyOffset = buffer.position();
        DiffKeyDeltaEncoder.ensureSpace(buffer, keyLength + valueLength + 8);
        buffer.putInt(keyLength);
        buffer.putInt(valueLength);
        if (commonPrefix > 0) {
            ByteBufferUtils.copyFromBufferToBuffer(buffer, buffer, state.prevOffset + 8, commonPrefix);
        }
        if (state.isFirst() || commonPrefix < state.rowLength + 2) {
            int rowRestLength;
            short rowLength;
            if (commonPrefix < 2) {
                ByteBufferUtils.copyFromStreamToBuffer(buffer, source, 2 - commonPrefix);
                ByteBufferUtils.skip(buffer, -2);
                rowLength = buffer.getShort();
                rowRestLength = rowLength;
            } else {
                rowLength = buffer.getShort(keyOffset + 8);
                rowRestLength = rowLength + 2 - commonPrefix;
            }
            ByteBufferUtils.copyFromStreamToBuffer(buffer, source, rowRestLength);
            state.rowLength = rowLength;
            buffer.put(state.familyNameWithSize);
            keyRestLength = keyLength - rowLength - state.familyNameWithSize.length - 11;
        } else {
            keyRestLength = keyLength - commonPrefix - 9;
        }
        ByteBufferUtils.copyFromStreamToBuffer(buffer, source, keyRestLength);
        int timestampFitsInBytes = ((flag & 0x70) >>> 4) + 1;
        long timestamp = ByteBufferUtils.readLong(source, timestampFitsInBytes);
        if ((flag & 0x80) != 0) {
            timestamp = -timestamp;
        }
        if ((flag & 8) != 0) {
            timestamp = state.timestamp - timestamp;
        }
        buffer.putLong(timestamp);
        byte type = (flag & 4) != 0 ? state.type : source.readByte();
        buffer.put(type);
        ByteBufferUtils.copyFromStreamToBuffer(buffer, source, valueLength);
        state.keyLength = keyLength;
        state.valueLength = valueLength;
        state.prevOffset = keyOffset;
        state.timestamp = timestamp;
        state.type = type;
    }

    @Override
    public void internalEncodeKeyValues(DataOutputStream out, ByteBuffer in, HFileBlockDefaultEncodingContext encodingCtx) throws IOException {
        in.rewind();
        ByteBufferUtils.putInt(out, in.limit());
        DiffCompressionState previousState = new DiffCompressionState();
        DiffCompressionState currentState = new DiffCompressionState();
        while (in.hasRemaining()) {
            this.compressSingleKeyValue(previousState, currentState, out, in);
            this.afterEncodingKeyValue(in, out, encodingCtx);
            DiffCompressionState tmp = previousState;
            previousState = currentState;
            currentState = tmp;
        }
    }

    @Override
    public ByteBuffer getFirstKeyInBlock(ByteBuffer block) {
        block.mark();
        block.position(4);
        byte familyLength = block.get();
        ByteBufferUtils.skip(block, familyLength);
        byte flag = block.get();
        int keyLength = ByteBufferUtils.readCompressedInt(block);
        ByteBufferUtils.readCompressedInt(block);
        ByteBufferUtils.readCompressedInt(block);
        ByteBuffer result2 = ByteBuffer.allocate(keyLength);
        int pos = result2.arrayOffset();
        block.get(result2.array(), pos, 2);
        short rowLength = result2.getShort();
        block.get(result2.array(), pos += 2, rowLength);
        int savePosition = block.position();
        block.position(4);
        block.get(result2.array(), pos += rowLength, familyLength + 1);
        block.position(savePosition);
        int qualifierLength = keyLength - (pos += familyLength + 1) + result2.arrayOffset() - 9;
        block.get(result2.array(), pos, qualifierLength);
        pos += qualifierLength;
        int timestampFitInBytes = ((flag & 0x70) >>> 4) + 1;
        long timestamp = ByteBufferUtils.readLong(block, timestampFitInBytes);
        if ((flag & 0x80) != 0) {
            timestamp = -timestamp;
        }
        result2.putLong(pos, timestamp);
        block.get(result2.array(), pos += 8, 1);
        block.reset();
        return result2;
    }

    public String toString() {
        return DiffKeyDeltaEncoder.class.getSimpleName();
    }

    @Override
    public DataBlockEncoder.EncodedSeeker createSeeker(KeyValue.KVComparator comparator, HFileBlockDecodingContext decodingCtx) {
        return new BufferedDataBlockEncoder.BufferedEncodedSeeker<DiffSeekerState>(comparator, decodingCtx){
            private byte[] familyNameWithSize;
            private static final int TIMESTAMP_WITH_TYPE_LENGTH = 9;

            private void decode(boolean isFirst) {
                byte flag = this.currentBuffer.get();
                byte type = 0;
                if ((flag & 1) == 0) {
                    if (!isFirst) {
                        type = ((DiffSeekerState)this.current).keyBuffer[((DiffSeekerState)this.current).keyLength - 1];
                    }
                    ((DiffSeekerState)this.current).keyLength = ByteBufferUtils.readCompressedInt(this.currentBuffer);
                }
                if ((flag & 2) == 0) {
                    ((DiffSeekerState)this.current).valueLength = ByteBufferUtils.readCompressedInt(this.currentBuffer);
                }
                ((DiffSeekerState)this.current).lastCommonPrefix = ByteBufferUtils.readCompressedInt(this.currentBuffer);
                ((DiffSeekerState)this.current).ensureSpaceForKey();
                if (((DiffSeekerState)this.current).lastCommonPrefix < 2) {
                    this.currentBuffer.get(((DiffSeekerState)this.current).keyBuffer, ((DiffSeekerState)this.current).lastCommonPrefix, 2 - ((DiffSeekerState)this.current).lastCommonPrefix);
                    ((DiffSeekerState)this.current).rowLengthWithSize = Bytes.toShort(((DiffSeekerState)this.current).keyBuffer, 0) + 2;
                    this.currentBuffer.get(((DiffSeekerState)this.current).keyBuffer, 2, ((DiffSeekerState)this.current).rowLengthWithSize - 2);
                    System.arraycopy(this.familyNameWithSize, 0, ((DiffSeekerState)this.current).keyBuffer, ((DiffSeekerState)this.current).rowLengthWithSize, this.familyNameWithSize.length);
                    this.currentBuffer.get(((DiffSeekerState)this.current).keyBuffer, ((DiffSeekerState)this.current).rowLengthWithSize + this.familyNameWithSize.length, ((DiffSeekerState)this.current).keyLength - ((DiffSeekerState)this.current).rowLengthWithSize - this.familyNameWithSize.length - 9);
                } else if (((DiffSeekerState)this.current).lastCommonPrefix < ((DiffSeekerState)this.current).rowLengthWithSize) {
                    this.currentBuffer.get(((DiffSeekerState)this.current).keyBuffer, ((DiffSeekerState)this.current).lastCommonPrefix, ((DiffSeekerState)this.current).rowLengthWithSize - ((DiffSeekerState)this.current).lastCommonPrefix);
                    this.currentBuffer.get(((DiffSeekerState)this.current).keyBuffer, ((DiffSeekerState)this.current).rowLengthWithSize + this.familyNameWithSize.length, ((DiffSeekerState)this.current).keyLength - ((DiffSeekerState)this.current).rowLengthWithSize - this.familyNameWithSize.length - 9);
                } else {
                    this.currentBuffer.get(((DiffSeekerState)this.current).keyBuffer, ((DiffSeekerState)this.current).lastCommonPrefix, ((DiffSeekerState)this.current).keyLength - 9 - ((DiffSeekerState)this.current).lastCommonPrefix);
                }
                int pos = ((DiffSeekerState)this.current).keyLength - 9;
                int timestampFitInBytes = 1 + ((flag & 0x70) >>> 4);
                long timestampOrDiff = ByteBufferUtils.readLong(this.currentBuffer, timestampFitInBytes);
                if ((flag & 0x80) != 0) {
                    timestampOrDiff = -timestampOrDiff;
                }
                if ((flag & 8) == 0) {
                    ((DiffSeekerState)this.current).timestamp = timestampOrDiff;
                } else {
                    ((DiffSeekerState)this.current).timestamp = ((DiffSeekerState)this.current).timestamp - timestampOrDiff;
                }
                Bytes.putLong(((DiffSeekerState)this.current).keyBuffer, pos, ((DiffSeekerState)this.current).timestamp);
                pos += 8;
                if ((flag & 4) == 0) {
                    this.currentBuffer.get(((DiffSeekerState)this.current).keyBuffer, pos, 1);
                } else if ((flag & 1) == 0) {
                    ((DiffSeekerState)this.current).keyBuffer[pos] = type;
                }
                ((DiffSeekerState)this.current).valueOffset = this.currentBuffer.position();
                ByteBufferUtils.skip(this.currentBuffer, ((DiffSeekerState)this.current).valueLength);
                if (this.includesTags()) {
                    this.decodeTags();
                }
                ((DiffSeekerState)this.current).memstoreTS = this.includesMvcc() ? ByteBufferUtils.readVLong(this.currentBuffer) : 0L;
                ((DiffSeekerState)this.current).nextKvOffset = this.currentBuffer.position();
            }

            @Override
            protected void decodeFirst() {
                ByteBufferUtils.skip(this.currentBuffer, 4);
                byte familyNameLength = this.currentBuffer.get();
                this.familyNameWithSize = new byte[familyNameLength + 1];
                this.familyNameWithSize[0] = familyNameLength;
                this.currentBuffer.get(this.familyNameWithSize, 1, familyNameLength);
                this.decode(true);
            }

            @Override
            protected void decodeNext() {
                this.decode(false);
            }

            @Override
            protected DiffSeekerState createSeekerState() {
                return new DiffSeekerState();
            }
        };
    }

    @Override
    protected ByteBuffer internalDecodeKeyValues(DataInputStream source, int allocateHeaderLength, int skipLastBytes, HFileBlockDefaultDecodingContext decodingCtx) throws IOException {
        int decompressedSize = source.readInt();
        ByteBuffer buffer = ByteBuffer.allocate(decompressedSize + allocateHeaderLength);
        buffer.position(allocateHeaderLength);
        DiffCompressionState state = new DiffCompressionState();
        while (source.available() > skipLastBytes) {
            this.uncompressSingleKeyValue(source, buffer, state);
            this.afterDecodingKeyValue(source, buffer, decodingCtx);
        }
        if (source.available() != skipLastBytes) {
            throw new IllegalStateException("Read too much bytes.");
        }
        return buffer;
    }

    protected static class DiffSeekerState
    extends BufferedDataBlockEncoder.SeekerState {
        private int rowLengthWithSize;
        private long timestamp;

        protected DiffSeekerState() {
        }

        @Override
        protected void copyFromNext(BufferedDataBlockEncoder.SeekerState that) {
            super.copyFromNext(that);
            DiffSeekerState other = (DiffSeekerState)that;
            this.rowLengthWithSize = other.rowLengthWithSize;
            this.timestamp = other.timestamp;
        }
    }

    protected static class DiffCompressionState
    extends CompressionState {
        long timestamp;
        byte[] familyNameWithSize;

        protected DiffCompressionState() {
        }

        @Override
        protected void readTimestamp(ByteBuffer in) {
            this.timestamp = in.getLong();
        }

        @Override
        void copyFrom(CompressionState state) {
            super.copyFrom(state);
            DiffCompressionState state2 = (DiffCompressionState)state;
            this.timestamp = state2.timestamp;
        }
    }
}

