/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.io.crypto.Cipher;
import org.apache.hadoop.hbase.io.crypto.Decryptor;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.crypto.Encryptor;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestEncryption {
    private static final Log LOG = LogFactory.getLog(TestEncryption.class);

    @Test
    public void testSmallBlocks() throws Exception {
        byte[] key = new byte[16];
        Bytes.random(key);
        byte[] iv = new byte[16];
        Bytes.random(iv);
        for (int size2 : new int[]{4, 8, 16, 32, 64, 128, 256, 512}) {
            this.checkTransformSymmetry(key, iv, this.getRandomBlock(size2));
        }
    }

    @Test
    public void testLargeBlocks() throws Exception {
        byte[] key = new byte[16];
        Bytes.random(key);
        byte[] iv = new byte[16];
        Bytes.random(iv);
        for (int size2 : new int[]{262144, 524288, 0x100000}) {
            this.checkTransformSymmetry(key, iv, this.getRandomBlock(size2));
        }
    }

    @Test
    public void testOddSizedBlocks() throws Exception {
        byte[] key = new byte[16];
        Bytes.random(key);
        byte[] iv = new byte[16];
        Bytes.random(iv);
        for (int size2 : new int[]{3, 7, 11, 23, 47, 79, 119, 175}) {
            this.checkTransformSymmetry(key, iv, this.getRandomBlock(size2));
        }
    }

    @Test
    public void testTypicalHFileBlocks() throws Exception {
        byte[] key = new byte[16];
        Bytes.random(key);
        byte[] iv = new byte[16];
        Bytes.random(iv);
        for (int size2 : new int[]{4096, 8192, 65536, 131072}) {
            this.checkTransformSymmetry(key, iv, this.getRandomBlock(size2));
        }
    }

    private void checkTransformSymmetry(byte[] keyBytes, byte[] iv, byte[] plaintext) throws Exception {
        LOG.info("checkTransformSymmetry: AES, plaintext length = " + plaintext.length);
        Configuration conf = HBaseConfiguration.create();
        String algorithm = conf.get("hbase.crypto.key.algorithm", "AES");
        Cipher aes = Encryption.getCipher(conf, algorithm);
        SecretKeySpec key = new SecretKeySpec(keyBytes, algorithm);
        Encryptor e = aes.getEncryptor();
        e.setKey(key);
        e.setIv(iv);
        e.reset();
        ByteArrayOutputStream encOut = new ByteArrayOutputStream();
        Encryption.encrypt(encOut, plaintext, 0, plaintext.length, e);
        byte[] encrypted = encOut.toByteArray();
        Decryptor d = aes.getDecryptor();
        d.setKey(key);
        d.setIv(iv);
        d.reset();
        ByteArrayInputStream encIn = new ByteArrayInputStream(encrypted);
        ByteArrayOutputStream decOut = new ByteArrayOutputStream();
        Encryption.decrypt(decOut, encIn, plaintext.length, d);
        byte[] result2 = decOut.toByteArray();
        Assert.assertEquals((String)"Decrypted result has different length than plaintext", (long)result2.length, (long)plaintext.length);
        Assert.assertTrue((String)"Transformation was not symmetric", (boolean)Bytes.equals(result2, plaintext));
    }

    private byte[] getRandomBlock(int size2) {
        byte[] b = new byte[size2];
        Bytes.random(b);
        return b;
    }
}

