/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.FSProtos;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class Reference {
    private byte[] splitkey;
    private Range region;

    public static Reference createTopReference(byte[] splitRow) {
        return new Reference(splitRow, Range.top);
    }

    public static Reference createBottomReference(byte[] splitRow) {
        return new Reference(splitRow, Range.bottom);
    }

    Reference(byte[] splitRow, Range fr) {
        this.splitkey = splitRow == null ? null : KeyValue.createFirstOnRow(splitRow).getKey();
        this.region = fr;
    }

    @Deprecated
    public Reference() {
        this(null, Range.bottom);
    }

    public Range getFileRegion() {
        return this.region;
    }

    public byte[] getSplitKey() {
        return this.splitkey;
    }

    public String toString() {
        return "" + (Object)((Object)this.region);
    }

    public static boolean isTopFileRegion(Range r) {
        return r.equals((Object)Range.top);
    }

    @Deprecated
    public void readFields(DataInput in) throws IOException {
        boolean tmp = in.readBoolean();
        this.region = tmp ? Range.top : Range.bottom;
        this.splitkey = Bytes.readByteArray(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path write(FileSystem fs, Path p) throws IOException {
        FSDataOutputStream out = fs.create(p, false);
        try {
            out.write(this.toByteArray());
        }
        finally {
            out.close();
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Reference read(FileSystem fs, Path p) throws IOException {
        DataInputStream in = fs.open(p);
        try {
            DataInputStream dis;
            in = ((InputStream)in).markSupported() ? in : new BufferedInputStream(in);
            int pblen = ProtobufUtil.lengthOfPBMagic();
            ((InputStream)in).mark(pblen);
            byte[] pbuf = new byte[pblen];
            int read2 = ((InputStream)in).read(pbuf);
            if (read2 != pblen) {
                throw new IOException("read=" + read2 + ", wanted=" + pblen);
            }
            if (ProtobufUtil.isPBMagicPrefix(pbuf)) {
                Reference reference = Reference.convert(FSProtos.Reference.parseFrom(in));
                return reference;
            }
            ((InputStream)in).reset();
            Reference r = new Reference();
            in = dis = new DataInputStream(in);
            r.readFields(dis);
            Reference reference = r;
            return reference;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    public FSProtos.Reference convert() {
        FSProtos.Reference.Builder builder = FSProtos.Reference.newBuilder();
        builder.setRange(Reference.isTopFileRegion(this.getFileRegion()) ? FSProtos.Reference.Range.TOP : FSProtos.Reference.Range.BOTTOM);
        builder.setSplitkey(ByteStringer.wrap(this.getSplitKey()));
        return builder.build();
    }

    public static Reference convert(FSProtos.Reference r) {
        Reference result2 = new Reference();
        result2.splitkey = r.getSplitkey().toByteArray();
        result2.region = r.getRange() == FSProtos.Reference.Range.TOP ? Range.top : Range.bottom;
        return result2;
    }

    byte[] toByteArray() throws IOException {
        return ProtobufUtil.prependPBMagic(this.convert().toByteArray());
    }

    static enum Range {
        top,
        bottom;

    }
}

