/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class FirstKeyValueMatchingQualifiersFilter
extends FirstKeyOnlyFilter {
    private Set<byte[]> qualifiers;

    public FirstKeyValueMatchingQualifiersFilter(Set<byte[]> qualifiers) {
        this.qualifiers = qualifiers;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(Cell v) {
        if (this.hasFoundKV()) {
            return Filter.ReturnCode.NEXT_ROW;
        }
        if (this.hasOneMatchingQualifier(v)) {
            this.setFoundKV(true);
        }
        return Filter.ReturnCode.INCLUDE;
    }

    private boolean hasOneMatchingQualifier(Cell v) {
        for (byte[] q : this.qualifiers) {
            KeyValue kv = KeyValueUtil.ensureKeyValue(v);
            if (!kv.matchingQualifier(q)) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.FirstKeyValueMatchingQualifiersFilter.Builder builder = FilterProtos.FirstKeyValueMatchingQualifiersFilter.newBuilder();
        for (byte[] qualifier : this.qualifiers) {
            if (qualifier == null) continue;
            builder.addQualifiers(ByteStringer.wrap(qualifier));
        }
        return builder.build().toByteArray();
    }

    public static FirstKeyValueMatchingQualifiersFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.FirstKeyValueMatchingQualifiersFilter proto;
        try {
            proto = FilterProtos.FirstKeyValueMatchingQualifiersFilter.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        TreeSet<byte[]> qualifiers = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        for (ByteString qualifier : proto.getQualifiersList()) {
            qualifiers.add(qualifier.toByteArray());
        }
        return new FirstKeyValueMatchingQualifiersFilter(qualifiers);
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FirstKeyValueMatchingQualifiersFilter)) {
            return false;
        }
        FirstKeyValueMatchingQualifiersFilter other = (FirstKeyValueMatchingQualifiersFilter)o;
        return this.qualifiers.equals(other.qualifiers);
    }
}

