/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.filter.Filter;

@InterfaceAudience.Private
public abstract class FilterBase
extends Filter {
    @Override
    public void reset() throws IOException {
    }

    @Override
    public boolean filterRowKey(byte[] buffer, int offset, int length) throws IOException {
        return false;
    }

    @Override
    public boolean filterAllRemaining() throws IOException {
        return false;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(Cell ignored) throws IOException {
        return Filter.ReturnCode.INCLUDE;
    }

    @Override
    public Cell transformCell(Cell v) throws IOException {
        return this.transform(KeyValueUtil.ensureKeyValue(v));
    }

    @Override
    @Deprecated
    public KeyValue transform(KeyValue currentKV) throws IOException {
        return currentKV;
    }

    @Override
    public void filterRowCells(List<Cell> ignored) throws IOException {
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>(ignored.size());
        for (Cell c : ignored) {
            kvs.add(KeyValueUtil.ensureKeyValue(c));
        }
        this.filterRow(kvs);
        ignored.clear();
        ignored.addAll(kvs);
    }

    @Override
    @Deprecated
    public void filterRow(List<KeyValue> kvs) throws IOException {
    }

    @Override
    public boolean hasFilterRow() {
        return false;
    }

    @Override
    public boolean filterRow() throws IOException {
        return false;
    }

    @Override
    @Deprecated
    public KeyValue getNextKeyHint(KeyValue currentKV) throws IOException {
        return null;
    }

    @Override
    public Cell getNextCellHint(Cell currentKV) throws IOException {
        return this.getNextKeyHint(KeyValueUtil.ensureKeyValue(currentKV));
    }

    @Override
    public boolean isFamilyEssential(byte[] name) throws IOException {
        return true;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        throw new IllegalArgumentException("This method has not been implemented");
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public byte[] toByteArray() throws IOException {
        return new byte[0];
    }

    @Override
    boolean areSerializedFieldsEqual(Filter other) {
        return true;
    }
}

