/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.CoprocessorHConnection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CoprocessorClassLoader;
import org.apache.hadoop.hbase.util.SortedCopyOnWriteSet;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.hadoop.io.MultipleIOException;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor"})
@InterfaceStability.Evolving
public abstract class CoprocessorHost<E extends CoprocessorEnvironment> {
    public static final String REGION_COPROCESSOR_CONF_KEY = "hbase.coprocessor.region.classes";
    public static final String REGIONSERVER_COPROCESSOR_CONF_KEY = "hbase.coprocessor.regionserver.classes";
    public static final String USER_REGION_COPROCESSOR_CONF_KEY = "hbase.coprocessor.user.region.classes";
    public static final String MASTER_COPROCESSOR_CONF_KEY = "hbase.coprocessor.master.classes";
    public static final String WAL_COPROCESSOR_CONF_KEY = "hbase.coprocessor.wal.classes";
    public static final String ABORT_ON_ERROR_KEY = "hbase.coprocessor.abortonerror";
    public static final boolean DEFAULT_ABORT_ON_ERROR = true;
    public static final String COPROCESSORS_ENABLED_CONF_KEY = "hbase.coprocessor.enabled";
    public static final boolean DEFAULT_COPROCESSORS_ENABLED = true;
    public static final String USER_COPROCESSORS_ENABLED_CONF_KEY = "hbase.coprocessor.user.enabled";
    public static final boolean DEFAULT_USER_COPROCESSORS_ENABLED = true;
    protected static final Log LOG = LogFactory.getLog(CoprocessorHost.class);
    protected Abortable abortable;
    protected SortedSet<E> coprocessors = new SortedCopyOnWriteSet<CoprocessorEnvironment>(new EnvironmentPriorityComparator());
    protected Configuration conf;
    protected String pathPrefix;
    protected AtomicInteger loadSequence = new AtomicInteger();
    private static Set<String> coprocessorNames = Collections.synchronizedSet(new HashSet());

    public CoprocessorHost(Abortable abortable) {
        this.abortable = abortable;
        this.pathPrefix = UUID.randomUUID().toString();
    }

    public static Set<String> getLoadedCoprocessors() {
        return coprocessorNames;
    }

    public Set<String> getCoprocessors() {
        TreeSet<String> returnValue = new TreeSet<String>();
        for (CoprocessorEnvironment e : this.coprocessors) {
            returnValue.add(e.getInstance().getClass().getSimpleName());
        }
        return returnValue;
    }

    protected void loadSystemCoprocessors(Configuration conf, String confKey) {
        boolean coprocessorsEnabled = conf.getBoolean(COPROCESSORS_ENABLED_CONF_KEY, true);
        if (!coprocessorsEnabled) {
            return;
        }
        Class<?> implClass = null;
        String[] defaultCPClasses = conf.getStrings(confKey);
        if (defaultCPClasses == null || defaultCPClasses.length == 0) {
            return;
        }
        int priority = 0x1FFFFFFF;
        ArrayList<E> configured = new ArrayList<E>();
        for (String className : defaultCPClasses) {
            if (this.findCoprocessor(className = className.trim()) != null) continue;
            ClassLoader cl = this.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(cl);
            try {
                implClass = cl.loadClass(className);
                configured.add(this.loadInstance(implClass, 0x1FFFFFFF, conf));
                LOG.info("System coprocessor " + className + " was loaded " + "successfully with priority (" + priority++ + ").");
            }
            catch (Throwable t) {
                this.abortServer(className, t);
            }
        }
        this.coprocessors.addAll(configured);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E load(Path path, String className, int priority, Configuration conf) throws IOException {
        Class<?> implClass = null;
        LOG.debug("Loading coprocessor class " + className + " with path " + path + " and priority " + priority);
        CoprocessorClassLoader cl = null;
        if (path == null) {
            try {
                implClass = this.getClass().getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new IOException("No jar path specified for " + className);
            }
        }
        cl = CoprocessorClassLoader.getClassLoader(path, this.getClass().getClassLoader(), this.pathPrefix, conf);
        try {
            implClass = ((ClassLoader)cl).loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Cannot load external coprocessor class " + className, e);
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader hostClassLoader = currentThread.getContextClassLoader();
        try {
            E cpInstance;
            currentThread.setContextClassLoader(cl);
            E e = cpInstance = this.loadInstance(implClass, priority, conf);
            return e;
        }
        finally {
            currentThread.setContextClassLoader(hostClassLoader);
        }
    }

    public void load(Class<?> implClass, int priority, Configuration conf) throws IOException {
        E env = this.loadInstance(implClass, priority, conf);
        this.coprocessors.add(env);
    }

    public E loadInstance(Class<?> implClass, int priority, Configuration conf) throws IOException {
        Coprocessor impl;
        if (!Coprocessor.class.isAssignableFrom(implClass)) {
            throw new IOException("Configured class " + implClass.getName() + " must implement " + Coprocessor.class.getName() + " interface ");
        }
        Object o = null;
        try {
            o = implClass.newInstance();
            impl = o;
        }
        catch (InstantiationException e) {
            throw new IOException(e);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
        E env = this.createEnvironment(implClass, impl, priority, this.loadSequence.incrementAndGet(), conf);
        if (env instanceof Environment) {
            ((Environment)env).startup();
        }
        coprocessorNames.add(implClass.getName());
        return env;
    }

    public abstract E createEnvironment(Class<?> var1, Coprocessor var2, int var3, int var4, Configuration var5);

    public void shutdown(CoprocessorEnvironment e) {
        if (e instanceof Environment) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stop coprocessor " + e.getInstance().getClass().getName());
            }
            ((Environment)e).shutdown();
        } else {
            LOG.warn("Shutdown called on unknown environment: " + e.getClass().getName());
        }
    }

    public Coprocessor findCoprocessor(String className) {
        for (CoprocessorEnvironment env : this.coprocessors) {
            if (!env.getInstance().getClass().getName().equals(className) && !env.getInstance().getClass().getSimpleName().equals(className)) continue;
            return env.getInstance();
        }
        return null;
    }

    public <T extends Coprocessor> List<T> findCoprocessors(Class<T> cls) {
        ArrayList<Coprocessor> ret = new ArrayList<Coprocessor>();
        for (CoprocessorEnvironment env : this.coprocessors) {
            Coprocessor cp = env.getInstance();
            if (cp == null || !cls.isAssignableFrom(cp.getClass())) continue;
            ret.add(cp);
        }
        return ret;
    }

    public CoprocessorEnvironment findCoprocessorEnvironment(String className) {
        for (CoprocessorEnvironment env : this.coprocessors) {
            if (!env.getInstance().getClass().getName().equals(className) && !env.getInstance().getClass().getSimpleName().equals(className)) continue;
            return env;
        }
        return null;
    }

    Set<ClassLoader> getExternalClassLoaders() {
        HashSet<ClassLoader> externalClassLoaders = new HashSet<ClassLoader>();
        ClassLoader systemClassLoader = this.getClass().getClassLoader();
        for (CoprocessorEnvironment env : this.coprocessors) {
            ClassLoader cl = env.getInstance().getClass().getClassLoader();
            if (cl == systemClassLoader) continue;
            externalClassLoaders.add(cl);
        }
        return externalClassLoaders;
    }

    protected void abortServer(CoprocessorEnvironment environment, Throwable e) {
        this.abortServer(environment.getInstance().getClass().getName(), e);
    }

    protected void abortServer(String coprocessorName, Throwable e) {
        String message = "The coprocessor " + coprocessorName + " threw " + e.toString();
        LOG.error(message, e);
        if (this.abortable != null) {
            this.abortable.abort(message, e);
        } else {
            LOG.warn("No available Abortable, process was not aborted");
        }
    }

    protected void handleCoprocessorThrowable(CoprocessorEnvironment env, Throwable e) throws IOException {
        if (e instanceof IOException) {
            throw (IOException)e;
        }
        if (!env.getConfiguration().getBoolean(ABORT_ON_ERROR_KEY, true)) {
            LOG.error("Removing coprocessor '" + env.toString() + "' from " + "environment because it threw:  " + e, e);
            this.coprocessors.remove(env);
            try {
                this.shutdown(env);
            }
            catch (Exception x) {
                LOG.error("Uncaught exception when shutting down coprocessor '" + env.toString() + "'", x);
            }
            throw new DoNotRetryIOException("Coprocessor: '" + env.toString() + "' threw: '" + e + "' and has been removed from the active " + "coprocessor set.", e);
        }
        this.abortServer(env, e);
    }

    public static class Environment
    implements CoprocessorEnvironment {
        public Coprocessor impl;
        protected int priority = 0x3FFFFFFF;
        Coprocessor.State state = Coprocessor.State.UNINSTALLED;
        protected List<HTableInterface> openTables = Collections.synchronizedList(new ArrayList());
        private int seq;
        private Configuration conf;
        private ClassLoader classLoader;

        public Environment(Coprocessor impl, int priority, int seq, Configuration conf) {
            this.impl = impl;
            this.classLoader = impl.getClass().getClassLoader();
            this.priority = priority;
            this.state = Coprocessor.State.INSTALLED;
            this.seq = seq;
            this.conf = conf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startup() throws IOException {
            if (this.state == Coprocessor.State.INSTALLED || this.state == Coprocessor.State.STOPPED) {
                this.state = Coprocessor.State.STARTING;
                Thread currentThread = Thread.currentThread();
                ClassLoader hostClassLoader = currentThread.getContextClassLoader();
                try {
                    currentThread.setContextClassLoader(this.getClassLoader());
                    this.impl.start(this);
                    this.state = Coprocessor.State.ACTIVE;
                }
                finally {
                    currentThread.setContextClassLoader(hostClassLoader);
                }
            } else {
                LOG.warn("Not starting coprocessor " + this.impl.getClass().getName() + " because not inactive (state=" + this.state.toString() + ")");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void shutdown() {
            if (this.state == Coprocessor.State.ACTIVE) {
                this.state = Coprocessor.State.STOPPING;
                Thread currentThread = Thread.currentThread();
                ClassLoader hostClassLoader = currentThread.getContextClassLoader();
                try {
                    currentThread.setContextClassLoader(this.getClassLoader());
                    this.impl.stop(this);
                    this.state = Coprocessor.State.STOPPED;
                }
                catch (IOException ioe) {
                    LOG.error("Error stopping coprocessor " + this.impl.getClass().getName(), ioe);
                }
                finally {
                    currentThread.setContextClassLoader(hostClassLoader);
                }
            } else {
                LOG.warn("Not stopping coprocessor " + this.impl.getClass().getName() + " because not active (state=" + this.state.toString() + ")");
            }
            for (HTableInterface table : this.openTables) {
                try {
                    ((HTableWrapper)table).internalClose();
                }
                catch (IOException e) {
                    LOG.warn("Failed to close " + Bytes.toStringBinary(table.getTableName()), e);
                }
            }
        }

        @Override
        public Coprocessor getInstance() {
            return this.impl;
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public int getLoadSequence() {
            return this.seq;
        }

        @Override
        public int getVersion() {
            return 1;
        }

        @Override
        public String getHBaseVersion() {
            return VersionInfo.getVersion();
        }

        @Override
        public Configuration getConfiguration() {
            return this.conf;
        }

        @Override
        public HTableInterface getTable(TableName tableName) throws IOException {
            return this.getTable(tableName, HTable.getDefaultExecutor(this.getConfiguration()));
        }

        @Override
        public HTableInterface getTable(TableName tableName, ExecutorService pool) throws IOException {
            return new HTableWrapper(tableName, CoprocessorHConnection.getConnectionForEnvironment(this), pool);
        }

        class HTableWrapper
        implements HTableInterface {
            private TableName tableName;
            private HTable table;
            private HConnection connection;

            public HTableWrapper(TableName tableName, HConnection connection, ExecutorService pool) throws IOException {
                this.tableName = tableName;
                this.table = new HTable(tableName, connection, pool);
                this.connection = connection;
                Environment.this.openTables.add(this);
            }

            void internalClose() throws IOException {
                ArrayList<IOException> exceptions = new ArrayList<IOException>(2);
                try {
                    this.table.close();
                }
                catch (IOException e) {
                    exceptions.add(e);
                }
                try {
                    if (this.connection != null) {
                        this.connection.close();
                    }
                }
                catch (IOException e) {
                    exceptions.add(e);
                }
                if (!exceptions.isEmpty()) {
                    throw MultipleIOException.createIOException(exceptions);
                }
            }

            @Override
            public Configuration getConfiguration() {
                return this.table.getConfiguration();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                try {
                    this.internalClose();
                }
                finally {
                    Environment.this.openTables.remove(this);
                }
            }

            @Override
            public Result getRowOrBefore(byte[] row, byte[] family) throws IOException {
                return this.table.getRowOrBefore(row, family);
            }

            @Override
            public Result get(Get get2) throws IOException {
                return this.table.get(get2);
            }

            @Override
            public boolean exists(Get get2) throws IOException {
                return this.table.exists(get2);
            }

            @Override
            public Boolean[] exists(List<Get> gets) throws IOException {
                return this.table.exists(gets);
            }

            @Override
            public void put(Put put2) throws IOException {
                this.table.put(put2);
            }

            @Override
            public void put(List<Put> puts) throws IOException {
                this.table.put(puts);
            }

            @Override
            public void delete(Delete delete2) throws IOException {
                this.table.delete(delete2);
            }

            @Override
            public void delete(List<Delete> deletes) throws IOException {
                this.table.delete(deletes);
            }

            @Override
            public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, byte[] value2, Put put2) throws IOException {
                return this.table.checkAndPut(row, family, qualifier, value2, put2);
            }

            @Override
            public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, byte[] value2, Delete delete2) throws IOException {
                return this.table.checkAndDelete(row, family, qualifier, value2, delete2);
            }

            @Override
            public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
                return this.table.incrementColumnValue(row, family, qualifier, amount);
            }

            @Override
            public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, Durability durability) throws IOException {
                return this.table.incrementColumnValue(row, family, qualifier, amount, durability);
            }

            @Override
            public Result append(Append append2) throws IOException {
                return this.table.append(append2);
            }

            @Override
            public Result increment(Increment increment) throws IOException {
                return this.table.increment(increment);
            }

            @Override
            public void flushCommits() throws IOException {
                this.table.flushCommits();
            }

            @Override
            public boolean isAutoFlush() {
                return this.table.isAutoFlush();
            }

            @Override
            public ResultScanner getScanner(Scan scan2) throws IOException {
                return this.table.getScanner(scan2);
            }

            @Override
            public ResultScanner getScanner(byte[] family) throws IOException {
                return this.table.getScanner(family);
            }

            @Override
            public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
                return this.table.getScanner(family, qualifier);
            }

            @Override
            public HTableDescriptor getTableDescriptor() throws IOException {
                return this.table.getTableDescriptor();
            }

            @Override
            public byte[] getTableName() {
                return this.tableName.getName();
            }

            @Override
            public TableName getName() {
                return this.table.getName();
            }

            @Override
            public void batch(List<? extends Row> actions, Object[] results) throws IOException, InterruptedException {
                this.table.batch(actions, results);
            }

            @Override
            public Object[] batch(List<? extends Row> actions) throws IOException, InterruptedException {
                return this.table.batch(actions);
            }

            @Override
            public <R> void batchCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
                this.table.batchCallback(actions, results, callback);
            }

            @Override
            public <R> Object[] batchCallback(List<? extends Row> actions, Batch.Callback<R> callback) throws IOException, InterruptedException {
                return this.table.batchCallback(actions, callback);
            }

            @Override
            public Result[] get(List<Get> gets) throws IOException {
                return this.table.get(gets);
            }

            @Override
            public CoprocessorRpcChannel coprocessorService(byte[] row) {
                return this.table.coprocessorService(row);
            }

            @Override
            public <T extends Service, R> Map<byte[], R> coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable) throws ServiceException, Throwable {
                return this.table.coprocessorService(service, startKey, endKey, callable);
            }

            @Override
            public <T extends Service, R> void coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable, Batch.Callback<R> callback) throws ServiceException, Throwable {
                this.table.coprocessorService(service, startKey, endKey, callable, callback);
            }

            @Override
            public void mutateRow(RowMutations rm2) throws IOException {
                this.table.mutateRow(rm2);
            }

            @Override
            public void setAutoFlush(boolean autoFlush) {
                this.table.setAutoFlush(autoFlush, autoFlush);
            }

            @Override
            public void setAutoFlush(boolean autoFlush, boolean clearBufferOnFail) {
                this.table.setAutoFlush(autoFlush, clearBufferOnFail);
            }

            @Override
            public void setAutoFlushTo(boolean autoFlush) {
                this.table.setAutoFlushTo(autoFlush);
            }

            @Override
            public long getWriteBufferSize() {
                return this.table.getWriteBufferSize();
            }

            @Override
            public void setWriteBufferSize(long writeBufferSize) throws IOException {
                this.table.setWriteBufferSize(writeBufferSize);
            }

            @Override
            public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, boolean writeToWAL) throws IOException {
                return this.table.incrementColumnValue(row, family, qualifier, amount, writeToWAL);
            }

            @Override
            public <R extends Message> Map<byte[], R> batchCoprocessorService(Descriptors.MethodDescriptor method, Message request, byte[] startKey, byte[] endKey, R responsePrototype) throws ServiceException, Throwable {
                return this.table.batchCoprocessorService(method, request, startKey, endKey, responsePrototype);
            }

            @Override
            public <R extends Message> void batchCoprocessorService(Descriptors.MethodDescriptor method, Message request, byte[] startKey, byte[] endKey, R responsePrototype, Batch.Callback<R> callback) throws ServiceException, Throwable {
                this.table.batchCoprocessorService(method, request, startKey, endKey, responsePrototype, callback);
            }

            @Override
            public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value2, RowMutations mutation) throws IOException {
                return this.table.checkAndMutate(row, family, qualifier, compareOp, value2, mutation);
            }
        }
    }

    static class EnvironmentPriorityComparator
    implements Comparator<CoprocessorEnvironment> {
        EnvironmentPriorityComparator() {
        }

        @Override
        public int compare(CoprocessorEnvironment env1, CoprocessorEnvironment env2) {
            if (env1.getPriority() < env2.getPriority()) {
                return -1;
            }
            if (env1.getPriority() > env2.getPriority()) {
                return 1;
            }
            if (env1.getLoadSequence() < env2.getLoadSequence()) {
                return -1;
            }
            if (env1.getLoadSequence() > env2.getLoadSequence()) {
                return 1;
            }
            return 0;
        }
    }
}

