/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree.decode.timestamp;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.codec.prefixtree.PrefixTreeBlockMeta;
import org.apache.hadoop.hbase.util.vint.UFIntTool;

@InterfaceAudience.Private
public class MvccVersionDecoder {
    protected PrefixTreeBlockMeta blockMeta;
    protected byte[] block;

    public void initOnBlock(PrefixTreeBlockMeta blockMeta, byte[] block) {
        this.block = block;
        this.blockMeta = blockMeta;
    }

    public long getMvccVersion(int index2) {
        if (this.blockMeta.getMvccVersionIndexWidth() == 0) {
            return this.blockMeta.getMinMvccVersion();
        }
        int startIndex = this.blockMeta.getAbsoluteMvccVersionOffset() + this.blockMeta.getMvccVersionDeltaWidth() * index2;
        long delta = UFIntTool.fromBytes(this.block, startIndex, this.blockMeta.getMvccVersionDeltaWidth());
        return this.blockMeta.getMinMvccVersion() + delta;
    }
}

