/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.codec.BaseDecoder;
import org.apache.hadoop.hbase.codec.BaseEncoder;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
@InterfaceStability.Unstable
public class CellCodecWithTags
implements Codec {
    @Override
    public Codec.Decoder getDecoder(InputStream is) {
        return new CellDecoder(is);
    }

    @Override
    public Codec.Encoder getEncoder(OutputStream os) {
        return new CellEncoder(os);
    }

    static class CellDecoder
    extends BaseDecoder {
        public CellDecoder(InputStream in) {
            super(in);
        }

        @Override
        protected Cell parseCell() throws IOException {
            byte[] row = this.readByteArray(this.in);
            byte[] family = this.readByteArray(this.in);
            byte[] qualifier = this.readByteArray(this.in);
            byte[] longArray = new byte[8];
            IOUtils.readFully(this.in, longArray);
            long timestamp = Bytes.toLong(longArray);
            byte type = (byte)this.in.read();
            byte[] value2 = this.readByteArray(this.in);
            byte[] tags = this.readByteArray(this.in);
            byte[] memstoreTSArray = new byte[8];
            IOUtils.readFully(this.in, memstoreTSArray);
            long memstoreTS = Bytes.toLong(memstoreTSArray);
            return CellUtil.createCell(row, family, qualifier, timestamp, type, value2, tags, memstoreTS);
        }

        private byte[] readByteArray(InputStream in) throws IOException {
            byte[] intArray = new byte[4];
            IOUtils.readFully(in, intArray);
            int length = Bytes.toInt(intArray);
            byte[] bytes = new byte[length];
            IOUtils.readFully(in, bytes);
            return bytes;
        }
    }

    static class CellEncoder
    extends BaseEncoder {
        CellEncoder(OutputStream out) {
            super(out);
        }

        @Override
        public void write(Cell cell) throws IOException {
            this.checkFlushed();
            this.write(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength());
            this.write(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength());
            this.write(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
            this.out.write(Bytes.toBytes(cell.getTimestamp()));
            this.out.write(cell.getTypeByte());
            this.write(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
            this.write(cell.getTagsArray(), cell.getTagsOffset(), cell.getTagsLengthUnsigned());
            this.out.write(Bytes.toBytes(cell.getMvccVersion()));
        }

        private void write(byte[] bytes, int offset, int length) throws IOException {
            this.out.write(Bytes.toBytes(length));
            this.out.write(bytes, offset, length);
        }
    }
}

