/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.replication;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerZKImpl;
import org.apache.hadoop.hbase.replication.ReplicationPeers;
import org.apache.hadoop.hbase.replication.ReplicationQueuesClient;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ReplicationAdmin
implements Closeable {
    private static final Log LOG = LogFactory.getLog(ReplicationAdmin.class);
    public static final String TNAME = "tableName";
    public static final String CFNAME = "columnFamlyName";
    public static final String REPLICATIONTYPE = "replicationType";
    public static final String REPLICATIONGLOBAL = Integer.toString(1);
    private final HConnection connection;
    private final ReplicationQueuesClient replicationQueuesClient;
    private final ReplicationPeers replicationPeers;
    private final ZooKeeperWatcher zkw;

    public ReplicationAdmin(Configuration conf) throws IOException {
        if (!conf.getBoolean("hbase.replication", true)) {
            throw new RuntimeException("hbase.replication isn't true, please enable it in order to use replication");
        }
        this.connection = HConnectionManager.getConnection(conf);
        try {
            this.zkw = this.createZooKeeperWatcher();
            try {
                this.replicationPeers = ReplicationFactory.getReplicationPeers(this.zkw, conf, this.connection);
                this.replicationPeers.init();
                this.replicationQueuesClient = ReplicationFactory.getReplicationQueuesClient(this.zkw, conf, this.connection);
                this.replicationQueuesClient.init();
            }
            catch (Exception exception) {
                if (this.zkw != null) {
                    this.zkw.close();
                }
                throw exception;
            }
        }
        catch (Exception exception) {
            if (this.connection != null) {
                this.connection.close();
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new IOException("Error initializing the replication admin client.", exception);
        }
    }

    private ZooKeeperWatcher createZooKeeperWatcher() throws IOException {
        return new ZooKeeperWatcher(this.connection.getConfiguration(), "ReplicationAdmin", new Abortable(){

            @Override
            public void abort(String why, Throwable e) {
                LOG.error(why, e);
            }

            @Override
            public boolean isAborted() {
                return false;
            }
        });
    }

    @Deprecated
    public void addPeer(String id, String clusterKey) throws ReplicationException {
        this.addPeer(id, new ReplicationPeerConfig().setClusterKey(clusterKey), null);
    }

    @Deprecated
    public void addPeer(String id, String clusterKey, String tableCFs) throws ReplicationException {
        this.replicationPeers.addPeer(id, new ReplicationPeerConfig().setClusterKey(clusterKey), tableCFs);
    }

    public void addPeer(String id, ReplicationPeerConfig peerConfig, Map<TableName, ? extends Collection<String>> tableCfs) throws ReplicationException {
        this.replicationPeers.addPeer(id, peerConfig, ReplicationAdmin.getTableCfsStr(tableCfs));
    }

    @VisibleForTesting
    static String getTableCfsStr(Map<TableName, ? extends Collection<String>> tableCfs) {
        String tableCfsStr = null;
        if (tableCfs != null) {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<TableName, ? extends Collection<String>> entry2 : tableCfs.entrySet()) {
                if (builder.length() > 0) {
                    builder.append(";");
                }
                builder.append(entry2.getKey());
                if (entry2.getValue() == null || entry2.getValue().isEmpty()) continue;
                builder.append(":");
                builder.append(StringUtils.join(entry2.getValue(), ","));
            }
            tableCfsStr = builder.toString();
        }
        return tableCfsStr;
    }

    public void removePeer(String id) throws ReplicationException {
        this.replicationPeers.removePeer(id);
    }

    public void enablePeer(String id) throws ReplicationException {
        this.replicationPeers.enablePeer(id);
    }

    public void disablePeer(String id) throws ReplicationException {
        this.replicationPeers.disablePeer(id);
    }

    public int getPeersCount() {
        return this.replicationPeers.getAllPeerIds().size();
    }

    @Deprecated
    public Map<String, String> listPeers() {
        Map<String, ReplicationPeerConfig> peers = this.listPeerConfigs();
        HashMap<String, String> ret = new HashMap<String, String>(peers.size());
        for (Map.Entry<String, ReplicationPeerConfig> entry2 : peers.entrySet()) {
            ret.put(entry2.getKey(), entry2.getValue().getClusterKey());
        }
        return ret;
    }

    public Map<String, ReplicationPeerConfig> listPeerConfigs() {
        return this.replicationPeers.getAllPeerConfigs();
    }

    public ReplicationPeerConfig getPeerConfig(String id) throws ReplicationException {
        return this.replicationPeers.getReplicationPeerConfig(id);
    }

    public String getPeerTableCFs(String id) throws ReplicationException {
        return this.replicationPeers.getPeerTableCFsConfig(id);
    }

    @Deprecated
    public void setPeerTableCFs(String id, String tableCFs) throws ReplicationException {
        this.replicationPeers.setPeerTableCFsConfig(id, tableCFs);
    }

    public void setPeerTableCFs(String id, Map<TableName, ? extends Collection<String>> tableCfs) throws ReplicationException {
        this.replicationPeers.setPeerTableCFsConfig(id, ReplicationAdmin.getTableCfsStr(tableCfs));
    }

    public boolean getPeerState(String id) throws ReplicationException {
        return this.replicationPeers.getStatusOfPeerFromBackingStore(id);
    }

    @Override
    public void close() throws IOException {
        if (this.zkw != null) {
            this.zkw.close();
        }
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public List<HashMap<String, String>> listReplicated() throws IOException {
        HTableDescriptor[] tables;
        ArrayList<HashMap<String, String>> replicationColFams = new ArrayList<HashMap<String, String>>();
        for (HTableDescriptor table : tables = this.connection.listTables()) {
            HColumnDescriptor[] columns = table.getColumnFamilies();
            String tableName = table.getNameAsString();
            for (HColumnDescriptor column : columns) {
                if (column.getScope() == 0) continue;
                HashMap<String, String> replicationEntry = new HashMap<String, String>();
                replicationEntry.put(TNAME, tableName);
                replicationEntry.put(CFNAME, column.getNameAsString());
                replicationEntry.put(REPLICATIONTYPE, REPLICATIONGLOBAL);
                replicationColFams.add(replicationEntry);
            }
        }
        return replicationColFams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableTableRep(TableName tableName) throws IOException {
        if (tableName == null) {
            throw new IllegalArgumentException("Table name cannot be null");
        }
        HBaseAdmin admin = null;
        try {
            admin = new HBaseAdmin(this.connection.getConfiguration());
            if (!admin.tableExists(tableName)) {
                throw new TableNotFoundException("Table '" + tableName.getNamespaceAsString() + "' does not exists.");
            }
        }
        finally {
            try {
                admin.close();
            }
            catch (IOException e) {
                LOG.warn("Failed to close admin connection.");
                LOG.debug("Details on failure to close admin connection.", e);
            }
        }
        byte[][] splits = this.getTableSplitRowKeys(tableName);
        this.checkAndSyncTableDescToPeers(tableName, splits);
        this.setTableRep(tableName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableTableRep(TableName tableName) throws IOException {
        if (tableName == null) {
            throw new IllegalArgumentException("Table name is null");
        }
        HBaseAdmin admin = null;
        try {
            admin = new HBaseAdmin(this.connection.getConfiguration());
            if (!admin.tableExists(tableName)) {
                throw new TableNotFoundException("Table '" + tableName.getNamespaceAsString() + "' does not exists.");
            }
        }
        finally {
            try {
                admin.close();
            }
            catch (IOException e) {
                LOG.warn("Failed to close admin connection.");
                LOG.debug("Details on failure to close admin connection.", e);
            }
        }
        this.setTableRep(tableName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[][] getTableSplitRowKeys(TableName tableName) throws IOException {
        HTable table = null;
        try {
            table = new HTable(this.connection.getConfiguration(), tableName);
            byte[][] startKeys = table.getStartKeys();
            if (startKeys.length == 1) {
                byte[][] byArray = null;
                return byArray;
            }
            byte[][] splits = new byte[startKeys.length - 1][];
            for (int i = 1; i < startKeys.length; ++i) {
                splits[i - 1] = startKeys[i];
            }
            byte[][] byArrayArray = splits;
            return byArrayArray;
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException e) {
                    LOG.warn("Unable to close table");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndSyncTableDescToPeers(TableName tableName, byte[][] splits) throws IOException {
        List<ReplicationPeer> repPeers = this.listValidReplicationPeers();
        if (repPeers == null || repPeers.size() <= 0) {
            throw new IllegalArgumentException("Found no peer cluster for replication.");
        }
        for (ReplicationPeer repPeer : repPeers) {
            Configuration peerConf = repPeer.getConfiguration();
            HTableDescriptor htd = null;
            HBaseAdmin repHBaseAdmin = null;
            try {
                repHBaseAdmin = new HBaseAdmin(peerConf);
                htd = this.connection.getHTableDescriptor(tableName);
                HTableDescriptor peerHtd = null;
                if (!repHBaseAdmin.tableExists(tableName)) {
                    repHBaseAdmin.createTable(htd, splits);
                    continue;
                }
                peerHtd = repHBaseAdmin.getTableDescriptor(tableName);
                if (peerHtd == null) {
                    throw new IllegalArgumentException("Failed to get table descriptor for table " + tableName.getNameAsString() + " from peer cluster " + repPeer.getId());
                }
                if (peerHtd.equals(htd)) continue;
                throw new IllegalArgumentException("Table " + tableName.getNameAsString() + " exists in peer cluster " + repPeer.getId() + ", but the table descriptors are not same when comapred with source cluster." + " Thus can not enable the table's replication switch.");
            }
            finally {
                if (repHBaseAdmin == null) continue;
                try {
                    repHBaseAdmin.close();
                }
                catch (IOException e) {
                    LOG.warn("Failed to close admin connection.");
                    LOG.debug("Details on failure to close admin connection.", e);
                }
            }
        }
    }

    private List<ReplicationPeer> listValidReplicationPeers() {
        Map<String, ReplicationPeerConfig> peers = this.listPeerConfigs();
        if (peers == null || peers.size() <= 0) {
            return null;
        }
        ArrayList<ReplicationPeer> validPeers = new ArrayList<ReplicationPeer>(peers.size());
        for (Map.Entry<String, ReplicationPeerConfig> peerEntry : peers.entrySet()) {
            String peerId = peerEntry.getKey();
            String clusterKey = peerEntry.getValue().getClusterKey();
            Configuration peerConf = new Configuration(this.connection.getConfiguration());
            Stat s2 = null;
            try {
                ZKUtil.applyClusterKeyToConf(peerConf, clusterKey);
                Pair<ReplicationPeerConfig, Configuration> pair2 = this.replicationPeers.getPeerConf(peerId);
                ReplicationPeerZKImpl peer = new ReplicationPeerZKImpl(peerConf, peerId, pair2.getFirst());
                s2 = this.zkw.getRecoverableZooKeeper().exists(peerConf.get("zookeeper.znode.parent"), null);
                if (null == s2) {
                    LOG.info(peerId + ' ' + clusterKey + " is invalid now.");
                    continue;
                }
                validPeers.add(peer);
            }
            catch (ReplicationException e) {
                LOG.warn("Failed to get valid replication peers. Error connecting to peer cluster with peerId=" + peerId);
                LOG.debug("Failure details to get valid replication peers.", e);
            }
            catch (KeeperException e) {
                LOG.warn("Failed to get valid replication peers. KeeperException code=" + e.code().intValue());
                LOG.debug("Failure details to get valid replication peers.", e);
            }
            catch (InterruptedException e) {
                LOG.warn("Failed to get valid replication peers due to InterruptedException.");
                LOG.debug("Failure details to get valid replication peers.", e);
                Thread.currentThread().interrupt();
            }
            catch (IOException e) {
                LOG.warn("Failed to get valid replication peers due to IOException.");
                LOG.debug("Failure details to get valid replication peers.", e);
            }
        }
        return validPeers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTableRep(TableName tableName, boolean isRepEnabled) throws IOException {
        HBaseAdmin admin = null;
        try {
            admin = new HBaseAdmin(this.connection.getConfiguration());
            HTableDescriptor htd = admin.getTableDescriptor(tableName);
            if (this.isTableRepEnabled(htd) ^ isRepEnabled) {
                boolean isOnlineSchemaUpdateEnabled = this.connection.getConfiguration().getBoolean("hbase.online.schema.update.enable", true);
                if (!isOnlineSchemaUpdateEnabled) {
                    admin.disableTable(tableName);
                }
                for (HColumnDescriptor hcd : htd.getFamilies()) {
                    hcd.setScope(isRepEnabled ? 1 : 0);
                }
                admin.modifyTable(tableName, htd);
                if (!isOnlineSchemaUpdateEnabled) {
                    admin.enableTable(tableName);
                }
            }
        }
        finally {
            if (admin != null) {
                try {
                    admin.close();
                }
                catch (IOException e) {
                    LOG.warn("Failed to close admin connection.");
                    LOG.debug("Details on failure to close admin connection.", e);
                }
            }
        }
    }

    private boolean isTableRepEnabled(HTableDescriptor htd) {
        for (HColumnDescriptor hcd : htd.getFamilies()) {
            if (hcd.getScope() == 1) continue;
            return false;
        }
        return true;
    }
}

