/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.coprocessor;

import java.io.IOException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.coprocessor.ColumnInterpreter;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class DoubleColumnInterpreter
extends ColumnInterpreter<Double, Double, HBaseProtos.EmptyMsg, HBaseProtos.DoubleMsg, HBaseProtos.DoubleMsg> {
    @Override
    public Double getValue(byte[] colFamily, byte[] colQualifier, Cell c) throws IOException {
        if (c == null || c.getValueLength() != 8) {
            return null;
        }
        return Bytes.toDouble(c.getValueArray(), c.getValueOffset());
    }

    @Override
    public Double add(Double d1, Double d2) {
        if (d1 == null || d2 == null) {
            return d1 == null ? d2 : d1;
        }
        return d1 + d2;
    }

    @Override
    public int compare(Double d1, Double d2) {
        if (d1 == null ^ d2 == null) {
            return d1 == null ? -1 : 1;
        }
        if (d1 == null) {
            return 0;
        }
        return d1.compareTo(d2);
    }

    @Override
    public Double getMaxValue() {
        return Double.MAX_VALUE;
    }

    @Override
    public Double increment(Double o) {
        return o == null ? null : Double.valueOf(o + 1.0);
    }

    @Override
    public Double multiply(Double d1, Double d2) {
        return d1 == null || d2 == null ? null : Double.valueOf(d1 * d2);
    }

    @Override
    public Double getMinValue() {
        return Double.MIN_VALUE;
    }

    @Override
    public double divideForAvg(Double d1, Long l2) {
        return l2 == null || d1 == null ? Double.NaN : d1 / l2.doubleValue();
    }

    @Override
    public Double castToReturnType(Double o) {
        return o;
    }

    @Override
    public Double castToCellType(Double d) {
        return d;
    }

    @Override
    public HBaseProtos.EmptyMsg getRequestData() {
        return HBaseProtos.EmptyMsg.getDefaultInstance();
    }

    @Override
    public void initialize(HBaseProtos.EmptyMsg msg) {
    }

    @Override
    public HBaseProtos.DoubleMsg getProtoForCellType(Double t) {
        HBaseProtos.DoubleMsg.Builder builder = HBaseProtos.DoubleMsg.newBuilder();
        return builder.setDoubleMsg(t).build();
    }

    @Override
    public HBaseProtos.DoubleMsg getProtoForPromotedType(Double s2) {
        HBaseProtos.DoubleMsg.Builder builder = HBaseProtos.DoubleMsg.newBuilder();
        return builder.setDoubleMsg(s2).build();
    }

    @Override
    public Double getPromotedValueFromProto(HBaseProtos.DoubleMsg r) {
        return r.getDoubleMsg();
    }

    @Override
    public Double getCellValueFromProto(HBaseProtos.DoubleMsg q) {
        return q.getDoubleMsg();
    }
}

