/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.coprocessor;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.coprocessor.ColumnInterpreter;
import org.apache.hadoop.hbase.ipc.BlockingRpcCallback;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AggregateProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;

@InterfaceAudience.Private
public class AggregationClient {
    private static final Log log = LogFactory.getLog(AggregationClient.class);
    Configuration conf;

    public AggregationClient(Configuration cfg) {
        this.conf = cfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R, S, P extends Message, Q extends Message, T extends Message> R max(TableName tableName, ColumnInterpreter<R, S, P, Q, T> ci, Scan scan2) throws Throwable {
        HTable table = null;
        try {
            table = new HTable(this.conf, tableName);
            R r = this.max(table, ci, scan2);
            return r;
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    public <R, S, P extends Message, Q extends Message, T extends Message> R max(HTable table, final ColumnInterpreter<R, S, P, Q, T> ci, Scan scan2) throws Throwable {
        final AggregateProtos.AggregateRequest requestArg = this.validateArgAndGetPB(scan2, ci, false);
        class MaxCallBack
        implements Batch.Callback<R> {
            R max = null;

            MaxCallBack() {
            }

            R getMax() {
                return this.max;
            }

            @Override
            public synchronized void update(byte[] region, byte[] row, R result2) {
                this.max = this.max == null || result2 != null && ci.compare(this.max, result2) < 0 ? result2 : this.max;
            }
        }
        MaxCallBack aMaxCallBack = new MaxCallBack();
        table.coprocessorService(AggregateProtos.AggregateService.class, scan2.getStartRow(), scan2.getStopRow(), new Batch.Call<AggregateProtos.AggregateService, R>(){

            @Override
            public R call(AggregateProtos.AggregateService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback<AggregateProtos.AggregateResponse> rpcCallback = new BlockingRpcCallback<AggregateProtos.AggregateResponse>();
                instance.getMax(controller, requestArg, rpcCallback);
                AggregateProtos.AggregateResponse response = rpcCallback.get();
                if (controller.failedOnException()) {
                    throw controller.getFailedOn();
                }
                if (response.getFirstPartCount() > 0) {
                    ByteString b = response.getFirstPart(0);
                    Object q = ProtobufUtil.getParsedGenericInstance(ci.getClass(), 3, b);
                    return ci.getCellValueFromProto(q);
                }
                return null;
            }
        }, aMaxCallBack);
        return aMaxCallBack.getMax();
    }

    private void validateParameters(Scan scan2, boolean canFamilyBeAbsent) throws IOException {
        if (scan2 == null || Bytes.equals(scan2.getStartRow(), scan2.getStopRow()) && !Bytes.equals(scan2.getStartRow(), HConstants.EMPTY_START_ROW) || Bytes.compareTo(scan2.getStartRow(), scan2.getStopRow()) > 0 && !Bytes.equals(scan2.getStopRow(), HConstants.EMPTY_END_ROW)) {
            throw new IOException("Agg client Exception: Startrow should be smaller than Stoprow");
        }
        if (!canFamilyBeAbsent && scan2.getFamilyMap().size() != 1) {
            throw new IOException("There must be only one family.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R, S, P extends Message, Q extends Message, T extends Message> R min(TableName tableName, ColumnInterpreter<R, S, P, Q, T> ci, Scan scan2) throws Throwable {
        HTable table = null;
        try {
            table = new HTable(this.conf, tableName);
            R r = this.min(table, ci, scan2);
            return r;
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    public <R, S, P extends Message, Q extends Message, T extends Message> R min(HTable table, final ColumnInterpreter<R, S, P, Q, T> ci, Scan scan2) throws Throwable {
        final AggregateProtos.AggregateRequest requestArg = this.validateArgAndGetPB(scan2, ci, false);
        class MinCallBack
        implements Batch.Callback<R> {
            private R min = null;

            MinCallBack() {
            }

            public R getMinimum() {
                return this.min;
            }

            @Override
            public synchronized void update(byte[] region, byte[] row, R result2) {
                this.min = this.min == null || result2 != null && ci.compare(result2, this.min) < 0 ? result2 : this.min;
            }
        }
        MinCallBack minCallBack = new MinCallBack();
        table.coprocessorService(AggregateProtos.AggregateService.class, scan2.getStartRow(), scan2.getStopRow(), new Batch.Call<AggregateProtos.AggregateService, R>(){

            @Override
            public R call(AggregateProtos.AggregateService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback<AggregateProtos.AggregateResponse> rpcCallback = new BlockingRpcCallback<AggregateProtos.AggregateResponse>();
                instance.getMin(controller, requestArg, rpcCallback);
                AggregateProtos.AggregateResponse response = rpcCallback.get();
                if (controller.failedOnException()) {
                    throw controller.getFailedOn();
                }
                if (response.getFirstPartCount() > 0) {
                    ByteString b = response.getFirstPart(0);
                    Object q = ProtobufUtil.getParsedGenericInstance(ci.getClass(), 3, b);
                    return ci.getCellValueFromProto(q);
                }
                return null;
            }
        }, minCallBack);
        log.debug("Min fom all regions is: " + minCallBack.getMinimum());
        return minCallBack.getMinimum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R, S, P extends Message, Q extends Message, T extends Message> long rowCount(TableName tableName, ColumnInterpreter<R, S, P, Q, T> ci, Scan scan2) throws Throwable {
        HTable table = null;
        try {
            table = new HTable(this.conf, tableName);
            long l = this.rowCount(table, ci, scan2);
            return l;
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    public <R, S, P extends Message, Q extends Message, T extends Message> long rowCount(HTable table, ColumnInterpreter<R, S, P, Q, T> ci, Scan scan2) throws Throwable {
        final AggregateProtos.AggregateRequest requestArg = this.validateArgAndGetPB(scan2, ci, true);
        class RowNumCallback
        implements Batch.Callback<Long> {
            private final AtomicLong rowCountL = new AtomicLong(0L);

            RowNumCallback() {
            }

            public long getRowNumCount() {
                return this.rowCountL.get();
            }

            @Override
            public void update(byte[] region, byte[] row, Long result2) {
                this.rowCountL.addAndGet(result2);
            }
        }
        RowNumCallback rowNum = new RowNumCallback();
        table.coprocessorService(AggregateProtos.AggregateService.class, scan2.getStartRow(), scan2.getStopRow(), new Batch.Call<AggregateProtos.AggregateService, Long>(){

            @Override
            public Long call(AggregateProtos.AggregateService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback<AggregateProtos.AggregateResponse> rpcCallback = new BlockingRpcCallback<AggregateProtos.AggregateResponse>();
                instance.getRowNum(controller, requestArg, rpcCallback);
                AggregateProtos.AggregateResponse response = rpcCallback.get();
                if (controller.failedOnException()) {
                    throw controller.getFailedOn();
                }
                byte[] bytes = AggregationClient.this.getBytesFromResponse(response.getFirstPart(0));
                ByteBuffer bb = ByteBuffer.allocate(8).put(bytes);
                bb.rewind();
                return bb.getLong();
            }
        }, rowNum);
        return rowNum.getRowNumCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R, S, P extends Message, Q extends Message, T extends Message> S sum(TableName tableName, ColumnInterpreter<R, S, P, Q, T> ci, Scan scan2) throws Throwable {
        HTable table = null;
        try {
            table = new HTable(this.conf, tableName);
            S s2 = this.sum(table, ci, scan2);
            return s2;
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    public <R, S, P extends Message, Q extends Message, T extends Message> S sum(HTable table, final ColumnInterpreter<R, S, P, Q, T> ci, Scan scan2) throws Throwable {
        final AggregateProtos.AggregateRequest requestArg = this.validateArgAndGetPB(scan2, ci, false);
        class SumCallBack
        implements Batch.Callback<S> {
            S sumVal = null;

            SumCallBack() {
            }

            public S getSumResult() {
                return this.sumVal;
            }

            @Override
            public synchronized void update(byte[] region, byte[] row, S result2) {
                this.sumVal = ci.add(this.sumVal, result2);
            }
        }
        SumCallBack sumCallBack = new SumCallBack();
        table.coprocessorService(AggregateProtos.AggregateService.class, scan2.getStartRow(), scan2.getStopRow(), new Batch.Call<AggregateProtos.AggregateService, S>(){

            @Override
            public S call(AggregateProtos.AggregateService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback<AggregateProtos.AggregateResponse> rpcCallback = new BlockingRpcCallback<AggregateProtos.AggregateResponse>();
                instance.getSum(controller, requestArg, rpcCallback);
                AggregateProtos.AggregateResponse response = rpcCallback.get();
                if (controller.failedOnException()) {
                    throw controller.getFailedOn();
                }
                if (response.getFirstPartCount() == 0) {
                    return null;
                }
                ByteString b = response.getFirstPart(0);
                Object t = ProtobufUtil.getParsedGenericInstance(ci.getClass(), 4, b);
                Object s2 = ci.getPromotedValueFromProto(t);
                return s2;
            }
        }, sumCallBack);
        return sumCallBack.getSumResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R, S, P extends Message, Q extends Message, T extends Message> Pair<S, Long> getAvgArgs(TableName tableName, ColumnInterpreter<R, S, P, Q, T> ci, Scan scan2) throws Throwable {
        HTable table = null;
        try {
            table = new HTable(this.conf, tableName);
            Pair<S, Long> pair2 = this.getAvgArgs(table, ci, scan2);
            return pair2;
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    private <R, S, P extends Message, Q extends Message, T extends Message> Pair<S, Long> getAvgArgs(HTable table, final ColumnInterpreter<R, S, P, Q, T> ci, Scan scan2) throws Throwable {
        final AggregateProtos.AggregateRequest requestArg = this.validateArgAndGetPB(scan2, ci, false);
        class AvgCallBack
        implements Batch.Callback<Pair<S, Long>> {
            S sum = null;
            Long rowCount = 0L;

            AvgCallBack() {
            }

            public Pair<S, Long> getAvgArgs() {
                return new Pair(this.sum, this.rowCount);
            }

            @Override
            public synchronized void update(byte[] region, byte[] row, Pair<S, Long> result2) {
                this.sum = ci.add(this.sum, result2.getFirst());
                this.rowCount = this.rowCount + result2.getSecond();
            }
        }
        AvgCallBack avgCallBack = new AvgCallBack();
        table.coprocessorService(AggregateProtos.AggregateService.class, scan2.getStartRow(), scan2.getStopRow(), new Batch.Call<AggregateProtos.AggregateService, Pair<S, Long>>(){

            @Override
            public Pair<S, Long> call(AggregateProtos.AggregateService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback<AggregateProtos.AggregateResponse> rpcCallback = new BlockingRpcCallback<AggregateProtos.AggregateResponse>();
                instance.getAvg(controller, requestArg, rpcCallback);
                AggregateProtos.AggregateResponse response = rpcCallback.get();
                if (controller.failedOnException()) {
                    throw controller.getFailedOn();
                }
                Pair<Object, Long> pair2 = new Pair<Object, Long>(null, 0L);
                if (response.getFirstPartCount() == 0) {
                    return pair2;
                }
                ByteString b = response.getFirstPart(0);
                Object t = ProtobufUtil.getParsedGenericInstance(ci.getClass(), 4, b);
                Object s2 = ci.getPromotedValueFromProto(t);
                pair2.setFirst(s2);
                ByteBuffer bb = ByteBuffer.allocate(8).put(AggregationClient.this.getBytesFromResponse(response.getSecondPart()));
                bb.rewind();
                pair2.setSecond(bb.getLong());
                return pair2;
            }
        }, avgCallBack);
        return avgCallBack.getAvgArgs();
    }

    public <R, S, P extends Message, Q extends Message, T extends Message> double avg(TableName tableName, ColumnInterpreter<R, S, P, Q, T> ci, Scan scan2) throws Throwable {
        Pair<S, Long> p = this.getAvgArgs(tableName, ci, scan2);
        return ci.divideForAvg(p.getFirst(), p.getSecond());
    }

    public <R, S, P extends Message, Q extends Message, T extends Message> double avg(HTable table, ColumnInterpreter<R, S, P, Q, T> ci, Scan scan2) throws Throwable {
        Pair<S, Long> p = this.getAvgArgs(table, ci, scan2);
        return ci.divideForAvg(p.getFirst(), p.getSecond());
    }

    private <R, S, P extends Message, Q extends Message, T extends Message> Pair<List<S>, Long> getStdArgs(HTable table, final ColumnInterpreter<R, S, P, Q, T> ci, Scan scan2) throws Throwable {
        final AggregateProtos.AggregateRequest requestArg = this.validateArgAndGetPB(scan2, ci, false);
        class StdCallback
        implements Batch.Callback<Pair<List<S>, Long>> {
            long rowCountVal = 0L;
            S sumVal = null;
            S sumSqVal = null;

            StdCallback() {
            }

            public Pair<List<S>, Long> getStdParams() {
                ArrayList l = new ArrayList();
                l.add(this.sumVal);
                l.add(this.sumSqVal);
                Pair p = new Pair(l, this.rowCountVal);
                return p;
            }

            @Override
            public synchronized void update(byte[] region, byte[] row, Pair<List<S>, Long> result2) {
                if (result2.getFirst().size() > 0) {
                    this.sumVal = ci.add(this.sumVal, result2.getFirst().get(0));
                    this.sumSqVal = ci.add(this.sumSqVal, result2.getFirst().get(1));
                    this.rowCountVal += result2.getSecond().longValue();
                }
            }
        }
        StdCallback stdCallback = new StdCallback();
        table.coprocessorService(AggregateProtos.AggregateService.class, scan2.getStartRow(), scan2.getStopRow(), new Batch.Call<AggregateProtos.AggregateService, Pair<List<S>, Long>>(){

            @Override
            public Pair<List<S>, Long> call(AggregateProtos.AggregateService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback<AggregateProtos.AggregateResponse> rpcCallback = new BlockingRpcCallback<AggregateProtos.AggregateResponse>();
                instance.getStd(controller, requestArg, rpcCallback);
                AggregateProtos.AggregateResponse response = rpcCallback.get();
                if (controller.failedOnException()) {
                    throw controller.getFailedOn();
                }
                Pair pair2 = new Pair(new ArrayList(), 0L);
                if (response.getFirstPartCount() == 0) {
                    return pair2;
                }
                ArrayList list2 = new ArrayList();
                for (int i = 0; i < response.getFirstPartCount(); ++i) {
                    ByteString b = response.getFirstPart(i);
                    Object t = ProtobufUtil.getParsedGenericInstance(ci.getClass(), 4, b);
                    Object s2 = ci.getPromotedValueFromProto(t);
                    list2.add(s2);
                }
                pair2.setFirst(list2);
                ByteBuffer bb = ByteBuffer.allocate(8).put(AggregationClient.this.getBytesFromResponse(response.getSecondPart()));
                bb.rewind();
                pair2.setSecond(bb.getLong());
                return pair2;
            }
        }, stdCallback);
        return stdCallback.getStdParams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R, S, P extends Message, Q extends Message, T extends Message> double std(TableName tableName, ColumnInterpreter<R, S, P, Q, T> ci, Scan scan2) throws Throwable {
        HTable table = null;
        try {
            table = new HTable(this.conf, tableName);
            double d = this.std(table, ci, scan2);
            return d;
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    public <R, S, P extends Message, Q extends Message, T extends Message> double std(HTable table, ColumnInterpreter<R, S, P, Q, T> ci, Scan scan2) throws Throwable {
        Pair<List<S>, Long> p = this.getStdArgs(table, ci, scan2);
        double res = 0.0;
        double avg = ci.divideForAvg(p.getFirst().get(0), p.getSecond());
        double avgOfSumSq = ci.divideForAvg(p.getFirst().get(1), p.getSecond());
        res = avgOfSumSq - avg * avg;
        res = Math.pow(res, 0.5);
        return res;
    }

    private <R, S, P extends Message, Q extends Message, T extends Message> Pair<NavigableMap<byte[], List<S>>, List<S>> getMedianArgs(HTable table, final ColumnInterpreter<R, S, P, Q, T> ci, Scan scan2) throws Throwable {
        final AggregateProtos.AggregateRequest requestArg = this.validateArgAndGetPB(scan2, ci, false);
        final TreeMap map2 = new TreeMap(Bytes.BYTES_COMPARATOR);
        class StdCallback
        implements Batch.Callback<List<S>> {
            S sumVal = null;
            S sumWeights = null;

            StdCallback() {
            }

            public Pair<NavigableMap<byte[], List<S>>, List<S>> getMedianParams() {
                ArrayList l = new ArrayList();
                l.add(this.sumVal);
                l.add(this.sumWeights);
                Pair p = new Pair(map2, l);
                return p;
            }

            @Override
            public synchronized void update(byte[] region, byte[] row, List<S> result2) {
                map2.put(row, result2);
                this.sumVal = ci.add(this.sumVal, result2.get(0));
                this.sumWeights = ci.add(this.sumWeights, result2.get(1));
            }
        }
        StdCallback stdCallback = new StdCallback();
        table.coprocessorService(AggregateProtos.AggregateService.class, scan2.getStartRow(), scan2.getStopRow(), new Batch.Call<AggregateProtos.AggregateService, List<S>>(){

            @Override
            public List<S> call(AggregateProtos.AggregateService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback<AggregateProtos.AggregateResponse> rpcCallback = new BlockingRpcCallback<AggregateProtos.AggregateResponse>();
                instance.getMedian(controller, requestArg, rpcCallback);
                AggregateProtos.AggregateResponse response = rpcCallback.get();
                if (controller.failedOnException()) {
                    throw controller.getFailedOn();
                }
                ArrayList list2 = new ArrayList();
                for (int i = 0; i < response.getFirstPartCount(); ++i) {
                    ByteString b = response.getFirstPart(i);
                    Object t = ProtobufUtil.getParsedGenericInstance(ci.getClass(), 4, b);
                    Object s2 = ci.getPromotedValueFromProto(t);
                    list2.add(s2);
                }
                return list2;
            }
        }, stdCallback);
        return stdCallback.getMedianParams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R, S, P extends Message, Q extends Message, T extends Message> R median(TableName tableName, ColumnInterpreter<R, S, P, Q, T> ci, Scan scan2) throws Throwable {
        HTable table = null;
        try {
            table = new HTable(this.conf, tableName);
            R r = this.median(table, ci, scan2);
            return r;
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R, S, P extends Message, Q extends Message, T extends Message> R median(HTable table, ColumnInterpreter<R, S, P, Q, T> ci, Scan scan2) throws Throwable {
        Pair<NavigableMap<byte[], List<S>>, List<S>> p = this.getMedianArgs(table, ci, scan2);
        byte[] startRow = null;
        byte[] colFamily = scan2.getFamilies()[0];
        NavigableSet<byte[]> quals = scan2.getFamilyMap().get(colFamily);
        NavigableMap<byte[], List<S>> map2 = p.getFirst();
        S sumVal = p.getSecond().get(0);
        S sumWeights = p.getSecond().get(1);
        double halfSumVal = ci.divideForAvg(sumVal, 2L);
        double movingSumVal = 0.0;
        boolean weighted = false;
        if (quals.size() > 1) {
            weighted = true;
            halfSumVal = ci.divideForAvg(sumWeights, 2L);
        }
        for (Map.Entry entry2 : map2.entrySet()) {
            Object s2 = weighted ? ((List)entry2.getValue()).get(1) : ((List)entry2.getValue()).get(0);
            double newSumVal = movingSumVal + ci.divideForAvg(s2, 1L);
            if (newSumVal > halfSumVal) break;
            movingSumVal = newSumVal;
            startRow = (byte[])entry2.getKey();
        }
        Scan scan22 = new Scan(scan2);
        if (startRow != null) {
            scan22.setStartRow(startRow);
        }
        ResultScanner scanner = null;
        try {
            int cacheSize = scan22.getCaching();
            if (!scan22.getCacheBlocks() || scan22.getCaching() < 2) {
                scan22.setCacheBlocks(true);
                cacheSize = 5;
                scan22.setCaching(cacheSize);
            }
            scanner = table.getScanner(scan22);
            Result[] results = null;
            byte[] qualifier = quals.pollFirst();
            byte[] weightQualifier = weighted ? quals.pollLast() : qualifier;
            R value2 = null;
            do {
                if ((results = scanner.next(cacheSize)) == null || results.length <= 0) continue;
                for (int i = 0; i < results.length; ++i) {
                    Result r = results[i];
                    KeyValue kv = r.getColumnLatest(colFamily, weightQualifier);
                    R newValue = ci.getValue(colFamily, weightQualifier, (Cell)kv);
                    S s3 = ci.castToReturnType(newValue);
                    double newSumVal = movingSumVal + ci.divideForAvg(s3, 1L);
                    if (newSumVal > halfSumVal) {
                        R r2 = value2;
                        return r2;
                    }
                    movingSumVal = newSumVal;
                    kv = r.getColumnLatest(colFamily, qualifier);
                    value2 = ci.getValue(colFamily, qualifier, (Cell)kv);
                }
            } while (results != null && results.length > 0);
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
        return null;
    }

    <R, S, P extends Message, Q extends Message, T extends Message> AggregateProtos.AggregateRequest validateArgAndGetPB(Scan scan2, ColumnInterpreter<R, S, P, Q, T> ci, boolean canFamilyBeAbsent) throws IOException {
        this.validateParameters(scan2, canFamilyBeAbsent);
        AggregateProtos.AggregateRequest.Builder requestBuilder = AggregateProtos.AggregateRequest.newBuilder();
        requestBuilder.setInterpreterClassName(ci.getClass().getCanonicalName());
        MessageLite columnInterpreterSpecificData = null;
        P p = ci.getRequestData();
        columnInterpreterSpecificData = (MessageLite)p;
        if (p != null) {
            requestBuilder.setInterpreterSpecificBytes(columnInterpreterSpecificData.toByteString());
        }
        requestBuilder.setScan(ProtobufUtil.toScan(scan2));
        return requestBuilder.build();
    }

    byte[] getBytesFromResponse(ByteString response) {
        ByteBuffer bb = response.asReadOnlyByteBuffer();
        bb.rewind();
        byte[] bytes = bb.hasArray() ? bb.array() : response.toByteArray();
        return bytes;
    }
}

