/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.RegionServerCallable;
import org.apache.hadoop.hbase.client.ResultStatsUtil;
import org.apache.hadoop.hbase.client.RetryingCallable;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.client.ServerStatisticTracker;

@InterfaceAudience.Private
public class StatsTrackingRpcRetryingCaller<T>
extends RpcRetryingCaller<T> {
    private final ServerStatisticTracker stats;

    public StatsTrackingRpcRetryingCaller(long pause, int retries, int startLogErrorsCnt, ServerStatisticTracker stats) {
        super(pause, retries, startLogErrorsCnt);
        this.stats = stats;
    }

    @Override
    public T callWithRetries(RetryingCallable<T> callable, int callTimeout) throws IOException, RuntimeException {
        T result2 = super.callWithRetries(callable, callTimeout);
        return this.updateStatsAndUnwrap(result2, callable);
    }

    @Override
    public T callWithoutRetries(RetryingCallable<T> callable, int callTimeout) throws IOException, RuntimeException {
        T result2 = super.callWithRetries(callable, callTimeout);
        return this.updateStatsAndUnwrap(result2, callable);
    }

    private T updateStatsAndUnwrap(T result2, RetryingCallable<T> callable) {
        if (!(callable instanceof RegionServerCallable)) {
            return result2;
        }
        RegionServerCallable regionCallable = (RegionServerCallable)callable;
        HRegionLocation location = regionCallable.getLocation();
        return ResultStatsUtil.updateStats(result2, this.stats, location);
    }
}

