/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Query;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.IncompatibleFilterException;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class Scan
extends Query {
    private static final Log LOG = LogFactory.getLog(Scan.class);
    private static final String RAW_ATTR = "_raw_";
    @Deprecated
    public static final String HINT_LOOKAHEAD = "_look_ahead_";
    private byte[] startRow = HConstants.EMPTY_START_ROW;
    private byte[] stopRow = HConstants.EMPTY_END_ROW;
    private int maxVersions = 1;
    private int batch = -1;
    private int storeLimit = -1;
    private int storeOffset = 0;
    private boolean getScan;
    public static final String SCAN_ATTRIBUTES_METRICS_ENABLE = "scan.attributes.metrics.enable";
    public static final String SCAN_ATTRIBUTES_METRICS_DATA = "scan.attributes.metrics.data";
    public static final String SCAN_ATTRIBUTES_TABLE_NAME = "scan.attributes.table.name";
    private int caching = -1;
    private long maxResultSize = -1L;
    private boolean cacheBlocks = true;
    private boolean reversed = false;
    private TimeRange tr = new TimeRange();
    private Map<byte[], NavigableSet<byte[]>> familyMap = new TreeMap<byte[], NavigableSet<byte[]>>(Bytes.BYTES_COMPARATOR);
    private Boolean loadColumnFamiliesOnDemand = null;
    private boolean small = false;

    public Scan() {
    }

    public Scan(byte[] startRow, Filter filter2) {
        this(startRow);
        this.filter = filter2;
    }

    public Scan(byte[] startRow) {
        this.startRow = startRow;
    }

    public Scan(byte[] startRow, byte[] stopRow) {
        this.startRow = startRow;
        this.stopRow = stopRow;
        this.getScan = this.isStartRowAndEqualsStopRow();
    }

    public Scan(Scan scan2) throws IOException {
        this.startRow = scan2.getStartRow();
        this.stopRow = scan2.getStopRow();
        this.maxVersions = scan2.getMaxVersions();
        this.batch = scan2.getBatch();
        this.storeLimit = scan2.getMaxResultsPerColumnFamily();
        this.storeOffset = scan2.getRowOffsetPerColumnFamily();
        this.caching = scan2.getCaching();
        this.maxResultSize = scan2.getMaxResultSize();
        this.cacheBlocks = scan2.getCacheBlocks();
        this.getScan = scan2.isGetScan();
        this.filter = scan2.getFilter();
        this.loadColumnFamiliesOnDemand = scan2.getLoadColumnFamiliesOnDemandValue();
        TimeRange ctr = scan2.getTimeRange();
        this.tr = new TimeRange(ctr.getMin(), ctr.getMax());
        this.reversed = scan2.isReversed();
        this.small = scan2.isSmall();
        Map<byte[], NavigableSet<byte[]>> fams = scan2.getFamilyMap();
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry2 : fams.entrySet()) {
            byte[] fam = entry2.getKey();
            NavigableSet<byte[]> cols = entry2.getValue();
            if (cols != null && cols.size() > 0) {
                for (byte[] col : cols) {
                    this.addColumn(fam, col);
                }
                continue;
            }
            this.addFamily(fam);
        }
        for (Map.Entry<Object, Object> entry3 : scan2.getAttributesMap().entrySet()) {
            this.setAttribute((String)entry3.getKey(), (byte[])entry3.getValue());
        }
    }

    public Scan(Get get2) {
        this.startRow = get2.getRow();
        this.stopRow = get2.getRow();
        this.filter = get2.getFilter();
        this.cacheBlocks = get2.getCacheBlocks();
        this.maxVersions = get2.getMaxVersions();
        this.storeLimit = get2.getMaxResultsPerColumnFamily();
        this.storeOffset = get2.getRowOffsetPerColumnFamily();
        this.tr = get2.getTimeRange();
        this.familyMap = get2.getFamilyMap();
        this.getScan = true;
        for (Map.Entry<String, byte[]> attr : get2.getAttributesMap().entrySet()) {
            this.setAttribute(attr.getKey(), attr.getValue());
        }
    }

    public boolean isGetScan() {
        return this.getScan || this.isStartRowAndEqualsStopRow();
    }

    private boolean isStartRowAndEqualsStopRow() {
        return this.startRow != null && this.startRow.length > 0 && Bytes.equals(this.startRow, this.stopRow);
    }

    public Scan addFamily(byte[] family) {
        this.familyMap.remove(family);
        this.familyMap.put(family, null);
        return this;
    }

    public Scan addColumn(byte[] family, byte[] qualifier) {
        NavigableSet<byte[]> set = this.familyMap.get(family);
        if (set == null) {
            set = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        }
        if (qualifier == null) {
            qualifier = HConstants.EMPTY_BYTE_ARRAY;
        }
        set.add(qualifier);
        this.familyMap.put(family, set);
        return this;
    }

    public Scan setTimeRange(long minStamp, long maxStamp) throws IOException {
        this.tr = new TimeRange(minStamp, maxStamp);
        return this;
    }

    public Scan setTimeStamp(long timestamp) throws IOException {
        try {
            this.tr = new TimeRange(timestamp, timestamp + 1L);
        }
        catch (IOException e) {
            LOG.error("TimeRange failed, likely caused by integer overflow. ", e);
            throw e;
        }
        return this;
    }

    public Scan setStartRow(byte[] startRow) {
        this.startRow = startRow;
        return this;
    }

    public Scan setStopRow(byte[] stopRow) {
        this.stopRow = stopRow;
        return this;
    }

    public Scan setMaxVersions() {
        this.maxVersions = Integer.MAX_VALUE;
        return this;
    }

    public Scan setMaxVersions(int maxVersions) {
        this.maxVersions = maxVersions;
        return this;
    }

    public void setBatch(int batch) {
        if (this.hasFilter() && this.filter.hasFilterRow()) {
            throw new IncompatibleFilterException("Cannot set batch on a scan using a filter that returns true for filter.hasFilterRow");
        }
        this.batch = batch;
    }

    public void setMaxResultsPerColumnFamily(int limit) {
        this.storeLimit = limit;
    }

    public void setRowOffsetPerColumnFamily(int offset) {
        this.storeOffset = offset;
    }

    public void setCaching(int caching) {
        this.caching = caching;
    }

    public long getMaxResultSize() {
        return this.maxResultSize;
    }

    public void setMaxResultSize(long maxResultSize) {
        this.maxResultSize = maxResultSize;
    }

    @Override
    public Scan setFilter(Filter filter2) {
        super.setFilter(filter2);
        return this;
    }

    public Scan setFamilyMap(Map<byte[], NavigableSet<byte[]>> familyMap) {
        this.familyMap = familyMap;
        return this;
    }

    public Map<byte[], NavigableSet<byte[]>> getFamilyMap() {
        return this.familyMap;
    }

    public int numFamilies() {
        if (this.hasFamilies()) {
            return this.familyMap.size();
        }
        return 0;
    }

    public boolean hasFamilies() {
        return !this.familyMap.isEmpty();
    }

    public byte[][] getFamilies() {
        if (this.hasFamilies()) {
            return (byte[][])this.familyMap.keySet().toArray((T[])new byte[0][0]);
        }
        return null;
    }

    public byte[] getStartRow() {
        return this.startRow;
    }

    public byte[] getStopRow() {
        return this.stopRow;
    }

    public int getMaxVersions() {
        return this.maxVersions;
    }

    public int getBatch() {
        return this.batch;
    }

    public int getMaxResultsPerColumnFamily() {
        return this.storeLimit;
    }

    public int getRowOffsetPerColumnFamily() {
        return this.storeOffset;
    }

    public int getCaching() {
        return this.caching;
    }

    public TimeRange getTimeRange() {
        return this.tr;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    public boolean hasFilter() {
        return this.filter != null;
    }

    public void setCacheBlocks(boolean cacheBlocks) {
        this.cacheBlocks = cacheBlocks;
    }

    public boolean getCacheBlocks() {
        return this.cacheBlocks;
    }

    public Scan setReversed(boolean reversed2) {
        this.reversed = reversed2;
        return this;
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public void setLoadColumnFamiliesOnDemand(boolean value2) {
        this.loadColumnFamiliesOnDemand = value2;
    }

    public Boolean getLoadColumnFamiliesOnDemandValue() {
        return this.loadColumnFamiliesOnDemand;
    }

    public boolean doLoadColumnFamiliesOnDemand() {
        return this.loadColumnFamiliesOnDemand != null && this.loadColumnFamiliesOnDemand != false;
    }

    @Override
    public Map<String, Object> getFingerprint() {
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        ArrayList<String> families = new ArrayList<String>();
        if (this.familyMap.size() == 0) {
            map2.put("families", "ALL");
            return map2;
        }
        map2.put("families", families);
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry2 : this.familyMap.entrySet()) {
            families.add(Bytes.toStringBinary(entry2.getKey()));
        }
        return map2;
    }

    @Override
    public Map<String, Object> toMap(int maxCols) {
        Map<String, Object> map2 = this.getFingerprint();
        HashMap familyColumns = new HashMap();
        map2.put("families", familyColumns);
        map2.put("startRow", Bytes.toStringBinary(this.startRow));
        map2.put("stopRow", Bytes.toStringBinary(this.stopRow));
        map2.put("maxVersions", this.maxVersions);
        map2.put("batch", this.batch);
        map2.put("caching", this.caching);
        map2.put("maxResultSize", this.maxResultSize);
        map2.put("cacheBlocks", this.cacheBlocks);
        map2.put("loadColumnFamiliesOnDemand", this.loadColumnFamiliesOnDemand);
        ArrayList<Long> timeRange = new ArrayList<Long>();
        timeRange.add(this.tr.getMin());
        timeRange.add(this.tr.getMax());
        map2.put("timeRange", timeRange);
        int colCount = 0;
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry2 : this.familyMap.entrySet()) {
            ArrayList<String> columns = new ArrayList<String>();
            familyColumns.put(Bytes.toStringBinary(entry2.getKey()), columns);
            if (entry2.getValue() == null) {
                ++colCount;
                --maxCols;
                columns.add("ALL");
                continue;
            }
            colCount += entry2.getValue().size();
            if (maxCols <= 0) continue;
            for (byte[] column : entry2.getValue()) {
                if (--maxCols <= 0) continue;
                columns.add(Bytes.toStringBinary(column));
            }
        }
        map2.put("totalColumns", colCount);
        if (this.filter != null) {
            map2.put("filter", this.filter.toString());
        }
        if (this.getId() != null) {
            map2.put("id", this.getId());
        }
        return map2;
    }

    public void setRaw(boolean raw2) {
        this.setAttribute(RAW_ATTR, Bytes.toBytes(raw2));
    }

    public boolean isRaw() {
        byte[] attr = this.getAttribute(RAW_ATTR);
        return attr == null ? false : Bytes.toBoolean(attr);
    }

    public void setSmall(boolean small) {
        this.small = small;
    }

    public boolean isSmall() {
        return this.small;
    }
}

