/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.ClientScanner;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.ReversedScannerCallable;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScannerCallable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ExceptionUtil;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ReversedClientScanner
extends ClientScanner {
    private static final Log LOG = LogFactory.getLog(ReversedClientScanner.class);
    static byte[] MAX_BYTE_ARRAY = Bytes.createMaxByteArray(9);

    public ReversedClientScanner(Configuration conf, Scan scan2, TableName tableName, HConnection connection) throws IOException {
        super(conf, scan2, tableName, connection);
    }

    @Override
    protected boolean nextScanner(int nbRows, boolean done) throws IOException {
        byte[] localStartKey;
        if (this.callable != null) {
            this.callable.setClose();
            this.caller.callWithRetries(this.callable);
            this.callable = null;
        }
        boolean locateTheClosestFrontRow = true;
        if (this.currentRegion != null) {
            byte[] startKey = this.currentRegion.getStartKey();
            if (startKey == null || Bytes.equals(startKey, HConstants.EMPTY_BYTE_ARRAY) || this.checkScanStopRow(startKey) || done) {
                this.close();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Finished " + this.currentRegion);
                }
                return false;
            }
            localStartKey = startKey;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Finished " + this.currentRegion);
            }
        } else {
            localStartKey = this.scan.getStartRow();
            if (!Bytes.equals(localStartKey, HConstants.EMPTY_BYTE_ARRAY)) {
                locateTheClosestFrontRow = false;
            }
        }
        if (LOG.isDebugEnabled() && this.currentRegion != null) {
            LOG.debug("Advancing internal scanner to startKey at '" + Bytes.toStringBinary(localStartKey) + "'");
        }
        try {
            byte[] locateStartRow = locateTheClosestFrontRow ? this.createClosestRowBefore(localStartKey) : null;
            this.callable = this.getScannerCallable(localStartKey, nbRows, locateStartRow);
            this.caller.callWithRetries(this.callable);
            this.currentRegion = this.callable.getHRegionInfo();
            if (this.scanMetrics != null) {
                this.scanMetrics.countOfRegions.incrementAndGet();
            }
        }
        catch (IOException e) {
            ExceptionUtil.rethrowIfInterrupt(e);
            this.close();
            throw e;
        }
        return true;
    }

    protected ScannerCallable getScannerCallable(byte[] localStartKey, int nbRows, byte[] locateStartRow) {
        this.scan.setStartRow(localStartKey);
        ReversedScannerCallable s2 = new ReversedScannerCallable(this.getConnection(), this.getTable(), this.scan, this.scanMetrics, locateStartRow, this.rpcControllerFactory.newController());
        s2.setCaching(nbRows);
        return s2;
    }

    @Override
    protected boolean checkScanStopRow(byte[] startKey) {
        byte[] stopRow;
        int cmp;
        return this.scan.getStopRow().length > 0 && (cmp = Bytes.compareTo(stopRow = this.scan.getStopRow(), 0, stopRow.length, startKey, 0, startKey.length)) >= 0;
    }

    protected byte[] createClosestRowBefore(byte[] row) {
        if (row == null) {
            throw new IllegalArgumentException("The passed row is empty");
        }
        if (Bytes.equals(row, HConstants.EMPTY_BYTE_ARRAY)) {
            return MAX_BYTE_ARRAY;
        }
        if (row[row.length - 1] == 0) {
            return Arrays.copyOf(row, row.length - 1);
        }
        byte[] closestFrontRow = Arrays.copyOf(row, row.length);
        closestFrontRow[row.length - 1] = (byte)((closestFrontRow[row.length - 1] & 0xFF) - 1);
        closestFrontRow = Bytes.add(closestFrontRow, MAX_BYTE_ARRAY);
        return closestFrontRow;
    }
}

