/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.WrongRowIOException;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class Put
extends Mutation
implements HeapSize,
Comparable<Row> {
    public Put(byte[] row) {
        this(row, Long.MAX_VALUE);
    }

    public Put(byte[] row, long ts) {
        this(row, 0, row.length, ts);
    }

    public Put(byte[] rowArray, int rowOffset, int rowLength) {
        this(rowArray, rowOffset, rowLength, Long.MAX_VALUE);
    }

    public Put(ByteBuffer row, long ts) {
        if (ts < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + ts);
        }
        Put.checkRow(row);
        this.row = new byte[row.remaining()];
        row.get(this.row);
        this.ts = ts;
    }

    public Put(ByteBuffer row) {
        this(row, Long.MAX_VALUE);
    }

    public Put(byte[] rowArray, int rowOffset, int rowLength, long ts) {
        Put.checkRow(rowArray, rowOffset, rowLength);
        this.row = Bytes.copy(rowArray, rowOffset, rowLength);
        this.ts = ts;
        if (ts < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + ts);
        }
    }

    public Put(Put putToCopy) {
        this(putToCopy.getRow(), putToCopy.ts);
        this.familyMap = new TreeMap(Bytes.BYTES_COMPARATOR);
        for (Map.Entry entry2 : putToCopy.getFamilyCellMap().entrySet()) {
            this.familyMap.put(entry2.getKey(), entry2.getValue());
        }
        this.durability = putToCopy.durability;
        for (Map.Entry<Object, Object> entry3 : putToCopy.getAttributesMap().entrySet()) {
            this.setAttribute((String)entry3.getKey(), (byte[])entry3.getValue());
        }
    }

    public Put add(byte[] family, byte[] qualifier, byte[] value2) {
        return this.add(family, qualifier, this.ts, value2);
    }

    public Put addImmutable(byte[] family, byte[] qualifier, byte[] value2) {
        return this.addImmutable(family, qualifier, this.ts, value2);
    }

    public Put addImmutable(byte[] family, byte[] qualifier, byte[] value2, Tag[] tag) {
        return this.addImmutable(family, qualifier, this.ts, value2, tag);
    }

    public Put add(byte[] family, byte[] qualifier, long ts, byte[] value2) {
        if (ts < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + ts);
        }
        List<Cell> list2 = this.getCellList(family);
        KeyValue kv = this.createPutKeyValue(family, qualifier, ts, value2);
        list2.add(kv);
        this.familyMap.put(CellUtil.cloneFamily(kv), list2);
        return this;
    }

    public Put addImmutable(byte[] family, byte[] qualifier, long ts, byte[] value2) {
        if (ts < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + ts);
        }
        List<Cell> list2 = this.getCellList(family);
        KeyValue kv = this.createPutKeyValue(family, qualifier, ts, value2);
        list2.add(kv);
        this.familyMap.put(family, list2);
        return this;
    }

    public Put addImmutable(byte[] family, byte[] qualifier, long ts, byte[] value2, Tag[] tag) {
        List<Cell> list2 = this.getCellList(family);
        KeyValue kv = this.createPutKeyValue(family, qualifier, ts, value2, tag);
        list2.add(kv);
        this.familyMap.put(family, list2);
        return this;
    }

    public Put addImmutable(byte[] family, ByteBuffer qualifier, long ts, ByteBuffer value2, Tag[] tag) {
        if (ts < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + ts);
        }
        List<Cell> list2 = this.getCellList(family);
        KeyValue kv = this.createPutKeyValue(family, qualifier, ts, value2, tag);
        list2.add(kv);
        this.familyMap.put(family, list2);
        return this;
    }

    public Put add(byte[] family, ByteBuffer qualifier, long ts, ByteBuffer value2) {
        if (ts < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + ts);
        }
        List<Cell> list2 = this.getCellList(family);
        KeyValue kv = this.createPutKeyValue(family, qualifier, ts, value2, null);
        list2.add(kv);
        this.familyMap.put(CellUtil.cloneFamily(kv), list2);
        return this;
    }

    public Put addImmutable(byte[] family, ByteBuffer qualifier, long ts, ByteBuffer value2) {
        if (ts < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + ts);
        }
        List<Cell> list2 = this.getCellList(family);
        KeyValue kv = this.createPutKeyValue(family, qualifier, ts, value2, null);
        list2.add(kv);
        this.familyMap.put(family, list2);
        return this;
    }

    public Put add(Cell kv) throws IOException {
        byte[] family = CellUtil.cloneFamily(kv);
        List<Cell> list2 = this.getCellList(family);
        int res = Bytes.compareTo(this.row, 0, this.row.length, kv.getRowArray(), kv.getRowOffset(), kv.getRowLength());
        if (res != 0) {
            throw new WrongRowIOException("The row in " + kv.toString() + " doesn't match the original one " + Bytes.toStringBinary(this.row));
        }
        list2.add(kv);
        this.familyMap.put(family, list2);
        return this;
    }

    public boolean has(byte[] family, byte[] qualifier) {
        return this.has(family, qualifier, this.ts, new byte[0], true, true);
    }

    public boolean has(byte[] family, byte[] qualifier, long ts) {
        return this.has(family, qualifier, ts, new byte[0], false, true);
    }

    public boolean has(byte[] family, byte[] qualifier, byte[] value2) {
        return this.has(family, qualifier, this.ts, value2, true, false);
    }

    public boolean has(byte[] family, byte[] qualifier, long ts, byte[] value2) {
        return this.has(family, qualifier, ts, value2, false, false);
    }

    private boolean has(byte[] family, byte[] qualifier, long ts, byte[] value2, boolean ignoreTS, boolean ignoreValue) {
        List<Cell> list2 = this.getCellList(family);
        if (list2.size() == 0) {
            return false;
        }
        if (!ignoreTS && !ignoreValue) {
            for (Cell cell : list2) {
                if (!CellUtil.matchingFamily(cell, family) || !CellUtil.matchingQualifier(cell, qualifier) || !CellUtil.matchingValue(cell, value2) || cell.getTimestamp() != ts) continue;
                return true;
            }
        } else if (ignoreValue && !ignoreTS) {
            for (Cell cell : list2) {
                if (!CellUtil.matchingFamily(cell, family) || !CellUtil.matchingQualifier(cell, qualifier) || cell.getTimestamp() != ts) continue;
                return true;
            }
        } else if (!ignoreValue && ignoreTS) {
            for (Cell cell : list2) {
                if (!CellUtil.matchingFamily(cell, family) || !CellUtil.matchingQualifier(cell, qualifier) || !CellUtil.matchingValue(cell, value2)) continue;
                return true;
            }
        } else {
            for (Cell cell : list2) {
                if (!CellUtil.matchingFamily(cell, family) || !CellUtil.matchingQualifier(cell, qualifier)) continue;
                return true;
            }
        }
        return false;
    }

    public List<Cell> get(byte[] family, byte[] qualifier) {
        ArrayList<Cell> filteredList = new ArrayList<Cell>();
        for (Cell cell : this.getCellList(family)) {
            if (!CellUtil.matchingQualifier(cell, qualifier)) continue;
            filteredList.add(cell);
        }
        return filteredList;
    }
}

