/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Attributes;
import org.apache.hadoop.hbase.client.Operation;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class OperationWithAttributes
extends Operation
implements Attributes {
    private Map<String, byte[]> attributes;
    public static final String ID_ATRIBUTE = "_operation.attributes.id";

    @Override
    public void setAttribute(String name, byte[] value2) {
        if (this.attributes == null && value2 == null) {
            return;
        }
        if (this.attributes == null) {
            this.attributes = new HashMap<String, byte[]>();
        }
        if (value2 == null) {
            this.attributes.remove(name);
            if (this.attributes.isEmpty()) {
                this.attributes = null;
            }
        } else {
            this.attributes.put(name, value2);
        }
    }

    @Override
    public byte[] getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    @Override
    public Map<String, byte[]> getAttributesMap() {
        if (this.attributes == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.attributes);
    }

    protected long getAttributeSize() {
        long size2 = 0L;
        if (this.attributes != null) {
            size2 += (long)ClassSize.align(this.attributes.size() * ClassSize.MAP_ENTRY);
            for (Map.Entry<String, byte[]> entry2 : this.attributes.entrySet()) {
                size2 += (long)ClassSize.align(ClassSize.STRING + entry2.getKey().length());
                size2 += (long)ClassSize.align(ClassSize.ARRAY + entry2.getValue().length);
            }
        }
        return size2;
    }

    public void setId(String id) {
        this.setAttribute(ID_ATRIBUTE, Bytes.toBytes(id));
    }

    public String getId() {
        byte[] attr = this.getAttribute(ID_ATRIBUTE);
        return attr == null ? null : Bytes.toString(attr);
    }
}

