/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.OperationWithAttributes;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class Mutation
extends OperationWithAttributes
implements Row,
CellScannable,
HeapSize {
    public static final long MUTATION_OVERHEAD = ClassSize.align(ClassSize.OBJECT + 2 * ClassSize.REFERENCE + 8 + ClassSize.REFERENCE + ClassSize.REFERENCE + ClassSize.TREEMAP);
    private static final String CONSUMED_CLUSTER_IDS = "_cs.id";
    private static final String OP_ATTRIBUTE_TTL = "_ttl";
    protected byte[] row = null;
    protected long ts = Long.MAX_VALUE;
    protected Durability durability = Durability.USE_DEFAULT;
    protected NavigableMap<byte[], List<Cell>> familyMap = new TreeMap<byte[], List<Cell>>(Bytes.BYTES_COMPARATOR);

    @Override
    public CellScanner cellScanner() {
        return CellUtil.createCellScanner(this.getFamilyCellMap());
    }

    List<Cell> getCellList(byte[] family) {
        ArrayList list2 = (ArrayList)this.familyMap.get(family);
        if (list2 == null) {
            list2 = new ArrayList();
        }
        return list2;
    }

    KeyValue createPutKeyValue(byte[] family, byte[] qualifier, long ts, byte[] value2) {
        return new KeyValue(this.row, family, qualifier, ts, KeyValue.Type.Put, value2);
    }

    KeyValue createPutKeyValue(byte[] family, byte[] qualifier, long ts, byte[] value2, Tag[] tags) {
        KeyValue kvWithTag = new KeyValue(this.row, family, qualifier, ts, value2, tags);
        return kvWithTag;
    }

    KeyValue createPutKeyValue(byte[] family, ByteBuffer qualifier, long ts, ByteBuffer value2, Tag[] tags) {
        return new KeyValue(this.row, 0, this.row == null ? 0 : this.row.length, family, 0, family == null ? 0 : family.length, qualifier, ts, KeyValue.Type.Put, value2, tags != null ? Arrays.asList(tags) : null);
    }

    @Override
    public Map<String, Object> getFingerprint() {
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        ArrayList<String> families = new ArrayList<String>();
        map2.put("families", families);
        for (Map.Entry entry2 : this.familyMap.entrySet()) {
            families.add(Bytes.toStringBinary((byte[])entry2.getKey()));
        }
        return map2;
    }

    @Override
    public Map<String, Object> toMap(int maxCols) {
        Map<String, Object> map2 = this.getFingerprint();
        HashMap columns = new HashMap();
        map2.put("families", columns);
        map2.put("row", Bytes.toStringBinary(this.row));
        int colCount = 0;
        for (Map.Entry entry2 : this.familyMap.entrySet()) {
            ArrayList<Map<String, Object>> qualifierDetails = new ArrayList<Map<String, Object>>();
            columns.put(Bytes.toStringBinary((byte[])entry2.getKey()), qualifierDetails);
            colCount += ((List)entry2.getValue()).size();
            if (maxCols <= 0) continue;
            for (Cell cell : (List)entry2.getValue()) {
                if (--maxCols <= 0) continue;
                KeyValue kv = KeyValueUtil.ensureKeyValue(cell);
                Map<String, Object> kvMap = kv.toStringMap();
                kvMap.remove("row");
                kvMap.remove("family");
                qualifierDetails.add(kvMap);
            }
        }
        map2.put("totalColumns", colCount);
        if (this.getId() != null) {
            map2.put("id", this.getId());
        }
        if (this.getTTL() != Long.MAX_VALUE) {
            map2.put("ttl", this.getTTL());
        }
        return map2;
    }

    @Deprecated
    public boolean getWriteToWAL() {
        return this.durability == Durability.SKIP_WAL;
    }

    @Deprecated
    public void setWriteToWAL(boolean write2) {
        this.setDurability(write2 ? Durability.USE_DEFAULT : Durability.SKIP_WAL);
    }

    public void setDurability(Durability d) {
        this.durability = d;
    }

    public Durability getDurability() {
        return this.durability;
    }

    public NavigableMap<byte[], List<Cell>> getFamilyCellMap() {
        return this.familyMap;
    }

    public void setFamilyCellMap(NavigableMap<byte[], List<Cell>> map2) {
        this.familyMap = map2;
    }

    @Deprecated
    public NavigableMap<byte[], List<KeyValue>> getFamilyMap() {
        TreeMap<byte[], List<KeyValue>> fm = new TreeMap<byte[], List<KeyValue>>(Bytes.BYTES_COMPARATOR);
        for (Map.Entry e : this.familyMap.entrySet()) {
            ArrayList<KeyValue> kvl = new ArrayList<KeyValue>(((List)e.getValue()).size());
            for (Cell c : (List)e.getValue()) {
                kvl.add(KeyValueUtil.ensureKeyValue(c));
            }
            fm.put((byte[])e.getKey(), (List<KeyValue>)kvl);
        }
        return fm;
    }

    @Deprecated
    public void setFamilyMap(NavigableMap<byte[], List<KeyValue>> map2) {
        TreeMap<byte[], List<Cell>> fm = new TreeMap<byte[], List<Cell>>(Bytes.BYTES_COMPARATOR);
        for (Map.Entry e : map2.entrySet()) {
            fm.put((byte[])e.getKey(), Lists.newArrayList((Iterable)e.getValue()));
        }
        this.familyMap = fm;
    }

    public boolean isEmpty() {
        return this.familyMap.isEmpty();
    }

    @Override
    public byte[] getRow() {
        return this.row;
    }

    @Override
    public int compareTo(Row d) {
        return Bytes.compareTo(this.getRow(), d.getRow());
    }

    public long getTimeStamp() {
        return this.ts;
    }

    public void setClusterIds(List<UUID> clusterIds) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeInt(clusterIds.size());
        for (UUID clusterId : clusterIds) {
            out.writeLong(clusterId.getMostSignificantBits());
            out.writeLong(clusterId.getLeastSignificantBits());
        }
        this.setAttribute(CONSUMED_CLUSTER_IDS, out.toByteArray());
    }

    public List<UUID> getClusterIds() {
        ArrayList<UUID> clusterIds = new ArrayList<UUID>();
        byte[] bytes = this.getAttribute(CONSUMED_CLUSTER_IDS);
        if (bytes != null) {
            ByteArrayDataInput in = ByteStreams.newDataInput(bytes);
            int numClusters = in.readInt();
            for (int i = 0; i < numClusters; ++i) {
                clusterIds.add(new UUID(in.readLong(), in.readLong()));
            }
        }
        return clusterIds;
    }

    @InterfaceStability.Unstable
    public void setCellVisibility(CellVisibility expression) {
        this.setAttribute("VISIBILITY", ProtobufUtil.toCellVisibility(expression).toByteArray());
    }

    @InterfaceStability.Unstable
    public CellVisibility getCellVisibility() throws DeserializationException {
        byte[] cellVisibilityBytes = this.getAttribute("VISIBILITY");
        if (cellVisibilityBytes == null) {
            return null;
        }
        return ProtobufUtil.toCellVisibility(cellVisibilityBytes);
    }

    public int size() {
        int size2 = 0;
        for (List cells : this.familyMap.values()) {
            size2 += cells.size();
        }
        return size2;
    }

    public int numFamilies() {
        return this.familyMap.size();
    }

    @Override
    public long heapSize() {
        long heapsize = MUTATION_OVERHEAD;
        heapsize += (long)ClassSize.align(ClassSize.ARRAY + this.row.length);
        heapsize += (long)ClassSize.align(this.familyMap.size() * ClassSize.MAP_ENTRY);
        for (Map.Entry entry2 : this.familyMap.entrySet()) {
            heapsize += (long)ClassSize.align(ClassSize.ARRAY + ((byte[])entry2.getKey()).length);
            heapsize += (long)ClassSize.align(ClassSize.ARRAYLIST);
            int size2 = ((List)entry2.getValue()).size();
            heapsize += (long)ClassSize.align(ClassSize.ARRAY + size2 * ClassSize.REFERENCE);
            for (Cell cell : (List)entry2.getValue()) {
                KeyValue kv = KeyValueUtil.ensureKeyValue(cell);
                heapsize += kv.heapSize();
            }
        }
        heapsize += this.getAttributeSize();
        return ClassSize.align(heapsize += this.extraHeapSize());
    }

    @InterfaceStability.Unstable
    public byte[] getACL() {
        return this.getAttribute("acl");
    }

    @InterfaceStability.Unstable
    public void setACL(String user, Permission perms) {
        this.setAttribute("acl", ProtobufUtil.toUsersAndPermissions(user, perms).toByteArray());
    }

    @InterfaceStability.Unstable
    public void setACL(Map<String, Permission> perms) {
        ArrayListMultimap<String, Permission> permMap = ArrayListMultimap.create();
        for (Map.Entry<String, Permission> entry2 : perms.entrySet()) {
            permMap.put(entry2.getKey(), entry2.getValue());
        }
        this.setAttribute("acl", ProtobufUtil.toUsersAndPermissions(permMap).toByteArray());
    }

    @Deprecated
    public boolean getACLStrategy() {
        return false;
    }

    @Deprecated
    public void setACLStrategy(boolean cellFirstStrategy) {
    }

    @InterfaceStability.Unstable
    public long getTTL() {
        byte[] ttlBytes = this.getAttribute(OP_ATTRIBUTE_TTL);
        if (ttlBytes != null) {
            return Bytes.toLong(ttlBytes);
        }
        return Long.MAX_VALUE;
    }

    @InterfaceStability.Unstable
    public Mutation setTTL(long ttl) {
        this.setAttribute(OP_ATTRIBUTE_TTL, Bytes.toBytes(ttl));
        return this;
    }

    protected long extraHeapSize() {
        return 0L;
    }

    static byte[] checkRow(byte[] row) {
        return Mutation.checkRow(row, 0, row == null ? 0 : row.length);
    }

    static byte[] checkRow(byte[] row, int offset, int length) {
        if (row == null) {
            throw new IllegalArgumentException("Row buffer is null");
        }
        if (length == 0) {
            throw new IllegalArgumentException("Row length is 0");
        }
        if (length > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Row length " + length + " is > " + Short.MAX_VALUE);
        }
        return row;
    }

    static void checkRow(ByteBuffer row) {
        if (row == null) {
            throw new IllegalArgumentException("Row buffer is null");
        }
        if (row.remaining() == 0) {
            throw new IllegalArgumentException("Row length is 0");
        }
        if (row.remaining() > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Row length " + row.remaining() + " is > " + Short.MAX_VALUE);
        }
    }
}

