/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Row;

@InterfaceAudience.Private
public class HTableUtil {
    private static final int INITIAL_LIST_SIZE = 250;

    public static void bucketRsPut(HTable htable, List<Put> puts) throws IOException {
        Map<String, List<Put>> putMap = HTableUtil.createRsPutMap(htable, puts);
        for (List<Put> rsPuts : putMap.values()) {
            htable.put(rsPuts);
        }
        htable.flushCommits();
    }

    public static void bucketRsBatch(HTable htable, List<Row> rows) throws IOException {
        try {
            Map<String, List<Row>> rowMap = HTableUtil.createRsRowMap(htable, rows);
            for (List<Row> rsRows : rowMap.values()) {
                htable.batch(rsRows);
            }
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException().initCause(e);
        }
    }

    private static Map<String, List<Put>> createRsPutMap(HTable htable, List<Put> puts) throws IOException {
        HashMap<String, List<Put>> putMap = new HashMap<String, List<Put>>();
        for (Put put2 : puts) {
            HRegionLocation rl = htable.getRegionLocation(put2.getRow());
            String hostname = rl.getHostname();
            ArrayList<Put> recs = (ArrayList<Put>)putMap.get(hostname);
            if (recs == null) {
                recs = new ArrayList<Put>(250);
                putMap.put(hostname, recs);
            }
            recs.add(put2);
        }
        return putMap;
    }

    private static Map<String, List<Row>> createRsRowMap(HTable htable, List<Row> rows) throws IOException {
        HashMap<String, List<Row>> rowMap = new HashMap<String, List<Row>>();
        for (Row row : rows) {
            HRegionLocation rl = htable.getRegionLocation(row.getRow());
            String hostname = rl.getHostname();
            ArrayList<Row> recs = (ArrayList<Row>)rowMap.get(hostname);
            if (recs == null) {
                recs = new ArrayList<Row>(250);
                rowMap.put(hostname, recs);
            }
            recs.add(row);
        }
        return rowMap;
    }
}

