/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;

class HConnectionKey {
    static final String[] CONNECTION_PROPERTIES = new String[]{"hbase.zookeeper.quorum", "zookeeper.znode.parent", "hbase.zookeeper.property.clientPort", "hbase.zookeeper.recoverable.waittime", "hbase.client.pause", "hbase.client.retries.number", "hbase.rpc.timeout", HConstants.HBASE_CLIENT_PREFETCH_LIMIT, "hbase.meta.scanner.caching", "hbase.client.instance.id", "hbase.client.rpc.codec", "hbase.rpc.controllerfactory.class"};
    private Map<String, String> properties;
    private String username;

    HConnectionKey(Configuration conf) {
        HashMap<String, String> m = new HashMap<String, String>();
        if (conf != null) {
            for (String property : CONNECTION_PROPERTIES) {
                String value2 = conf.get(property);
                if (value2 == null) continue;
                m.put(property, value2);
            }
        }
        this.properties = Collections.unmodifiableMap(m);
        try {
            UserProvider provider = UserProvider.instantiate(conf);
            User currentUser = provider.getCurrent();
            if (currentUser != null) {
                this.username = currentUser.getName();
            }
        }
        catch (IOException ioe) {
            HConnectionManager.LOG.warn("Error obtaining current user, skipping username in HConnectionKey", ioe);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        if (this.username != null) {
            result2 = this.username.hashCode();
        }
        for (String property : CONNECTION_PROPERTIES) {
            String value2 = this.properties.get(property);
            if (value2 == null) continue;
            result2 = 31 * result2 + value2.hashCode();
        }
        return result2;
    }

    @SuppressWarnings(value={"ES_COMPARING_STRINGS_WITH_EQ"}, justification="Optimization")
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HConnectionKey that = (HConnectionKey)obj;
        if (this.username != null && !this.username.equals(that.username)) {
            return false;
        }
        if (this.username == null && that.username != null) {
            return false;
        }
        if (this.properties == null) {
            if (that.properties != null) {
                return false;
            }
        } else {
            if (that.properties == null) {
                return false;
            }
            for (String property : CONNECTION_PROPERTIES) {
                String thatValue;
                String thisValue = this.properties.get(property);
                if (thisValue == (thatValue = that.properties.get(property)) || thisValue != null && thisValue.equals(thatValue)) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return "HConnectionKey{properties=" + this.properties + ", username='" + this.username + '\'' + '}';
    }
}

