/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Action;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.DelayingRunner;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.MultiAction;
import org.apache.hadoop.hbase.client.MultiResponse;
import org.apache.hadoop.hbase.client.MultiServerCallable;
import org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.ServerStatisticTracker;
import org.apache.hadoop.hbase.client.backoff.ServerStatistics;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.cloudera.htrace.Trace;

class AsyncProcess<CResult> {
    private static final Log LOG = LogFactory.getLog(AsyncProcess.class);
    public static final String START_LOG_ERRORS_AFTER_COUNT_KEY = "hbase.client.start.log.errors.counter";
    public static final int DEFAULT_START_LOG_ERRORS_AFTER_COUNT = 9;
    protected static final AtomicLong COUNTER = new AtomicLong();
    protected final long id;
    private final int startLogErrorsCnt;
    protected final HConnection hConnection;
    protected final TableName tableName;
    protected final ExecutorService pool;
    protected final AsyncProcessCallback<CResult> callback;
    protected final BatchErrors errors = new BatchErrors();
    protected final AtomicBoolean hasError = new AtomicBoolean(false);
    protected final AtomicLong tasksSent = new AtomicLong(0L);
    protected final AtomicLong tasksDone = new AtomicLong(0L);
    protected final AtomicLong retriesCnt = new AtomicLong(0L);
    protected final ConcurrentMap<byte[], AtomicInteger> taskCounterPerRegion = new ConcurrentSkipListMap<byte[], AtomicInteger>(Bytes.BYTES_COMPARATOR);
    protected final ConcurrentMap<ServerName, AtomicInteger> taskCounterPerServer = new ConcurrentHashMap<ServerName, AtomicInteger>();
    protected final int timeout;
    protected final int maxTotalConcurrentTasks;
    protected final int maxConcurrentTasksPerRegion;
    protected final int maxConcurrentTasksPerServer;
    protected final long pause;
    protected int numTries;
    protected int serverTrackerTimeout;
    protected RpcRetryingCallerFactory rpcCallerFactory;
    private RpcControllerFactory rpcFactory;

    public AsyncProcess(HConnection hc, TableName tableName, ExecutorService pool, AsyncProcessCallback<CResult> callback, Configuration conf, RpcRetryingCallerFactory rpcCaller, RpcControllerFactory rpcFactory) {
        if (hc == null) {
            throw new IllegalArgumentException("HConnection cannot be null.");
        }
        this.hConnection = hc;
        this.tableName = tableName;
        this.pool = pool;
        this.callback = callback;
        this.id = COUNTER.incrementAndGet();
        this.pause = conf.getLong("hbase.client.pause", 100L);
        this.numTries = conf.getInt("hbase.client.retries.number", 31);
        this.timeout = conf.getInt("hbase.rpc.timeout", 60000);
        this.maxTotalConcurrentTasks = conf.getInt("hbase.client.max.total.tasks", 100);
        this.maxConcurrentTasksPerServer = conf.getInt("hbase.client.max.perserver.tasks", 2);
        this.maxConcurrentTasksPerRegion = conf.getInt("hbase.client.max.perregion.tasks", 1);
        this.startLogErrorsCnt = conf.getInt(START_LOG_ERRORS_AFTER_COUNT_KEY, 9);
        if (this.maxTotalConcurrentTasks <= 0) {
            throw new IllegalArgumentException("maxTotalConcurrentTasks=" + this.maxTotalConcurrentTasks);
        }
        if (this.maxConcurrentTasksPerServer <= 0) {
            throw new IllegalArgumentException("maxConcurrentTasksPerServer=" + this.maxConcurrentTasksPerServer);
        }
        if (this.maxConcurrentTasksPerRegion <= 0) {
            throw new IllegalArgumentException("maxConcurrentTasksPerRegion=" + this.maxConcurrentTasksPerRegion);
        }
        this.serverTrackerTimeout = 0;
        for (int i = 0; i < this.numTries; ++i) {
            this.serverTrackerTimeout = (int)((long)this.serverTrackerTimeout + ConnectionUtils.getPauseTime(this.pause, i));
        }
        this.rpcCallerFactory = rpcCaller;
        Preconditions.checkNotNull(rpcFactory);
        this.rpcFactory = rpcFactory;
    }

    public void submit(List<? extends Row> rows, boolean atLeastOne) throws InterruptedIOException {
        this.submit(rows, atLeastOne, null);
    }

    public void submit(List<? extends Row> rows, boolean atLeastOne, Batch.Callback<CResult> batchCallback) throws InterruptedIOException {
        if (rows.isEmpty()) {
            return;
        }
        HashMap<HRegionLocation, MultiAction<Row>> actionsByServer = new HashMap<HRegionLocation, MultiAction<Row>>();
        ArrayList<Action<Row>> retainedActions = new ArrayList<Action<Row>>(rows.size());
        long currentTaskCnt = this.tasksDone.get();
        boolean alreadyLooped = false;
        NonceGenerator ng = this.hConnection.getNonceGenerator();
        do {
            if (alreadyLooped) {
                this.waitForNextTaskDone(currentTaskCnt);
                currentTaskCnt = this.tasksDone.get();
            } else {
                alreadyLooped = true;
            }
            this.waitForMaximumCurrentTasks(this.maxTotalConcurrentTasks - 1);
            HashMap<Long, Boolean> regionIncluded = new HashMap<Long, Boolean>();
            HashMap<ServerName, Boolean> serverIncluded = new HashMap<ServerName, Boolean>();
            int posInList = -1;
            Iterator<? extends Row> it = rows.iterator();
            while (it.hasNext()) {
                Row r = it.next();
                HRegionLocation loc = this.findDestLocation(r, posInList);
                if (loc == null) {
                    it.remove();
                    continue;
                }
                if (!this.canTakeOperation(loc, regionIncluded, serverIncluded)) continue;
                Action<Row> action = new Action<Row>(r, ++posInList);
                this.setNonce(ng, r, action);
                retainedActions.add(action);
                this.addAction(loc, action, actionsByServer, ng);
                it.remove();
            }
        } while (retainedActions.isEmpty() && atLeastOne && !this.hasError());
        HConnectionManager.ServerErrorTracker errorsByServer = this.createServerErrorTracker();
        this.sendMultiAction(retainedActions, actionsByServer, 1, errorsByServer, batchCallback);
    }

    private void addAction(HRegionLocation loc, Action<Row> action, Map<HRegionLocation, MultiAction<Row>> actionsByServer, NonceGenerator ng) {
        byte[] regionName = loc.getRegionInfo().getRegionName();
        MultiAction<Row> multiAction = actionsByServer.get(loc);
        if (multiAction == null) {
            multiAction = new MultiAction();
            actionsByServer.put(loc, multiAction);
        }
        if (action.hasNonce() && !multiAction.hasNonceGroup()) {
            multiAction.setNonceGroup(ng.getNonceGroup());
        }
        multiAction.add(regionName, action);
    }

    private HRegionLocation findDestLocation(Row row, int posInList) {
        if (row == null) {
            throw new IllegalArgumentException("#" + this.id + ", row cannot be null");
        }
        HRegionLocation loc = null;
        IOException locationException = null;
        try {
            loc = this.hConnection.locateRegion(this.tableName, row.getRow());
            if (loc == null) {
                locationException = new IOException("#" + this.id + ", no location found, aborting submit for" + " tableName=" + this.tableName + " rowkey=" + Arrays.toString(row.getRow()));
            }
        }
        catch (IOException e) {
            locationException = e;
        }
        if (locationException != null) {
            this.manageError(posInList, row, false, locationException, null);
            return null;
        }
        return loc;
    }

    protected boolean canTakeOperation(HRegionLocation loc, Map<Long, Boolean> regionsIncluded, Map<ServerName, Boolean> serversIncluded) {
        long regionId = loc.getRegionInfo().getRegionId();
        Boolean regionPrevious = regionsIncluded.get(regionId);
        if (regionPrevious != null) {
            return regionPrevious;
        }
        Boolean serverPrevious = serversIncluded.get(loc.getServerName());
        if (Boolean.FALSE.equals(serverPrevious)) {
            regionsIncluded.put(regionId, Boolean.FALSE);
            return false;
        }
        AtomicInteger regionCnt = (AtomicInteger)this.taskCounterPerRegion.get(loc.getRegionInfo().getRegionName());
        if (regionCnt != null && regionCnt.get() >= this.maxConcurrentTasksPerRegion) {
            regionsIncluded.put(regionId, Boolean.FALSE);
            return false;
        }
        if (serverPrevious == null) {
            boolean ok;
            int newServers = 0;
            for (Map.Entry<ServerName, Boolean> kv : serversIncluded.entrySet()) {
                if (!kv.getValue().booleanValue()) continue;
                ++newServers;
            }
            boolean bl = ok = (long)newServers + this.getCurrentTasksCount() < (long)this.maxTotalConcurrentTasks;
            if (ok) {
                AtomicInteger serverCnt = (AtomicInteger)this.taskCounterPerServer.get(loc.getServerName());
                boolean bl2 = ok = serverCnt == null || serverCnt.get() < this.maxConcurrentTasksPerServer;
            }
            if (!ok) {
                regionsIncluded.put(regionId, Boolean.FALSE);
                serversIncluded.put(loc.getServerName(), Boolean.FALSE);
                return false;
            }
            serversIncluded.put(loc.getServerName(), Boolean.TRUE);
        } else assert (serverPrevious.equals(Boolean.TRUE));
        regionsIncluded.put(regionId, Boolean.TRUE);
        return true;
    }

    public void submitAll(List<? extends Row> rows) {
        ArrayList<Action<Row>> actions = new ArrayList<Action<Row>>(rows.size());
        int posInList = -1;
        NonceGenerator ng = this.hConnection.getNonceGenerator();
        for (Row row : rows) {
            Put put2;
            ++posInList;
            if (row instanceof Put && (put2 = (Put)row).isEmpty()) {
                throw new IllegalArgumentException("No columns to insert for #" + (posInList + 1) + " item");
            }
            Action<Row> action = new Action<Row>(row, posInList);
            this.setNonce(ng, row, action);
            actions.add(action);
        }
        HConnectionManager.ServerErrorTracker errorsByServer = this.createServerErrorTracker();
        this.submit(actions, actions, 1, errorsByServer);
    }

    private void setNonce(NonceGenerator ng, Row r, Action<Row> action) {
        if (!(r instanceof Append) && !(r instanceof Increment)) {
            return;
        }
        action.setNonce(ng.newNonce());
    }

    private void submit(List<Action<Row>> initialActions, List<Action<Row>> currentActions, int numAttempt, HConnectionManager.ServerErrorTracker errorsByServer) {
        if (numAttempt > 1) {
            this.retriesCnt.incrementAndGet();
        }
        HashMap<HRegionLocation, MultiAction<Row>> actionsByServer = new HashMap<HRegionLocation, MultiAction<Row>>();
        NonceGenerator ng = this.hConnection.getNonceGenerator();
        for (Action<Row> action : currentActions) {
            HRegionLocation loc = this.findDestLocation(action.getAction(), action.getOriginalIndex());
            if (loc == null) continue;
            this.addAction(loc, action, actionsByServer, ng);
        }
        if (!actionsByServer.isEmpty()) {
            this.sendMultiAction(initialActions, actionsByServer, numAttempt, errorsByServer, null);
        }
    }

    public void sendMultiAction(List<Action<Row>> initialActions, Map<HRegionLocation, MultiAction<Row>> actionsByServer, int numAttempt, HConnectionManager.ServerErrorTracker errorsByServer, Batch.Callback<CResult> batchCallback) {
        for (Map.Entry<HRegionLocation, MultiAction<Row>> e : actionsByServer.entrySet()) {
            HRegionLocation loc = e.getKey();
            MultiAction<Row> multiAction = e.getValue();
            Collection<Runnable> runnables = this.getNewMultiActionRunnable(initialActions, loc, multiAction, numAttempt, errorsByServer, batchCallback);
            for (Runnable runnable : runnables) {
                try {
                    this.incTaskCounters(multiAction.getRegions(), loc.getServerName());
                    this.pool.submit(runnable);
                }
                catch (RejectedExecutionException ree) {
                    this.decTaskCounters(multiAction.getRegions(), loc.getServerName());
                    LOG.warn("#" + this.id + ", the task was rejected by the pool. This is unexpected." + " Server is " + loc.getServerName(), ree);
                    this.receiveGlobalFailure(initialActions, multiAction, loc, numAttempt, ree, errorsByServer);
                }
            }
        }
    }

    private Runnable getNewSingleServerRunnable(final List<Action<Row>> initialActions, final HRegionLocation loc, final MultiAction<Row> multiAction, final int numAttempt, final HConnectionManager.ServerErrorTracker errorsByServer, final Batch.Callback<CResult> batchCallback) {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public void run() {
                block8: {
                    try {
                        MultiResponse res;
                        MultiServerCallable<Row> callable = AsyncProcess.this.createCallable(loc, multiAction);
                        try {
                            res = AsyncProcess.this.createCaller(callable).callWithoutRetries(callable, AsyncProcess.this.timeout);
                        }
                        catch (IOException e) {
                            AsyncProcess.this.receiveGlobalFailure(initialActions, multiAction, loc, numAttempt, e, errorsByServer);
                            AsyncProcess.this.decTaskCounters(multiAction.getRegions(), loc.getServerName());
                            return;
                        }
                        catch (Throwable t) {
                            LOG.error("#" + AsyncProcess.this.id + ", Caught throwable while calling. This is unexpected." + " Retrying. Server is " + loc.getServerName() + ", tableName=" + AsyncProcess.this.tableName, t);
                            AsyncProcess.this.receiveGlobalFailure(initialActions, multiAction, loc, numAttempt, t, errorsByServer);
                            AsyncProcess.this.decTaskCounters(multiAction.getRegions(), loc.getServerName());
                            return;
                        }
                        AsyncProcess.this.receiveMultiAction(initialActions, multiAction, loc, res, numAttempt, errorsByServer, batchCallback);
                        break block8;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        AsyncProcess.this.decTaskCounters(multiAction.getRegions(), loc.getServerName());
                    }
                }
            }
        };
    }

    private Collection<? extends Runnable> getNewMultiActionRunnable(List<Action<Row>> initialActions, HRegionLocation loc, MultiAction<Row> multiAction, int numAttempt, HConnectionManager.ServerErrorTracker errorsByServer, Batch.Callback<CResult> batchCallback) {
        if (this.hConnection.getStatisticsTracker() == null) {
            ArrayList<Runnable> toReturn = new ArrayList<Runnable>(1);
            toReturn.add(Trace.wrap("AsyncProcess.sendMultiAction", this.getNewSingleServerRunnable(initialActions, loc, multiAction, numAttempt, errorsByServer, batchCallback)));
            return toReturn;
        }
        HashMap actions = new HashMap(multiAction.size());
        for (Map.Entry entry2 : multiAction.actions.entrySet()) {
            Long backoff = this.getBackoff(loc);
            DelayingRunner runner = (DelayingRunner)actions.get(backoff);
            if (runner == null) {
                actions.put(backoff, new DelayingRunner(backoff, entry2));
                continue;
            }
            runner.add(entry2);
        }
        ArrayList<Runnable> toReturn = new ArrayList<Runnable>(actions.size());
        for (DelayingRunner runner : actions.values()) {
            String traceText = "AsyncProcess.sendMultiAction";
            Runnable runnable = this.getNewSingleServerRunnable(initialActions, loc, runner.getActions(), numAttempt, errorsByServer, batchCallback);
            if (runner.getSleepTime() > 0L) {
                runner.setRunner(runnable);
                traceText = "AsyncProcess.clientBackoff.sendMultiAction";
                runnable = runner;
            }
            runnable = Trace.wrap(traceText, runnable);
            toReturn.add(runnable);
        }
        return toReturn;
    }

    private Long getBackoff(HRegionLocation location) {
        ServerStatisticTracker tracker = this.hConnection.getStatisticsTracker();
        ServerStatistics stats = tracker.getStats(location.getServerName());
        return this.hConnection.getBackoffPolicy().getBackoffTime(location.getServerName(), location.getRegionInfo().getRegionName(), stats);
    }

    protected MultiServerCallable<Row> createCallable(HRegionLocation location, MultiAction<Row> multi) {
        return new MultiServerCallable<Row>(this.hConnection, this.tableName, location, this.rpcFactory, multi);
    }

    protected RpcRetryingCaller<MultiResponse> createCaller(MultiServerCallable<Row> callable) {
        return this.rpcCallerFactory.newCaller();
    }

    private boolean manageError(int originalIndex, Row row, boolean canRetry, Throwable throwable, HRegionLocation location) {
        if (canRetry && throwable != null && throwable instanceof DoNotRetryIOException) {
            canRetry = false;
        }
        byte[] region = null;
        if (canRetry && this.callback != null) {
            region = location == null ? null : location.getRegionInfo().getEncodedNameAsBytes();
            canRetry = this.callback.retriableFailure(originalIndex, row, region, throwable);
        }
        if (!canRetry) {
            if (this.callback != null) {
                if (region == null && location != null) {
                    region = location.getRegionInfo().getEncodedNameAsBytes();
                }
                this.callback.failure(originalIndex, region, row, throwable);
            }
            this.errors.add(throwable, row, location);
            this.hasError.set(true);
        }
        return canRetry;
    }

    private void receiveGlobalFailure(List<Action<Row>> initialActions, MultiAction<Row> rsActions, HRegionLocation location, int numAttempt, Throwable t, HConnectionManager.ServerErrorTracker errorsByServer) {
        this.hConnection.updateCachedLocations(this.tableName, rsActions.actions.values().iterator().next().get(0).getAction().getRow(), null, location);
        errorsByServer.reportServerError(location);
        boolean canRetry = errorsByServer.canRetryMore(numAttempt);
        ArrayList<Action<Row>> toReplay = new ArrayList<Action<Row>>(initialActions.size());
        for (Map.Entry e : rsActions.actions.entrySet()) {
            for (Action action : e.getValue()) {
                if (!this.manageError(action.getOriginalIndex(), action.getAction(), canRetry, t, location)) continue;
                toReplay.add(action);
            }
        }
        this.logAndResubmit(initialActions, location, toReplay, numAttempt, rsActions.size(), t, errorsByServer);
    }

    private void logAndResubmit(List<Action<Row>> initialActions, HRegionLocation oldLocation, List<Action<Row>> toReplay, int numAttempt, int failureCount, Throwable throwable, HConnectionManager.ServerErrorTracker errorsByServer) {
        if (toReplay.isEmpty()) {
            if (failureCount != 0) {
                LOG.warn(this.createLog(numAttempt, failureCount, toReplay.size(), oldLocation.getServerName(), throwable, -1L, false, errorsByServer.getStartTrackingTime()));
            } else if (numAttempt > this.startLogErrorsCnt + 1) {
                LOG.info(this.createLog(numAttempt, failureCount, 0, oldLocation.getServerName(), throwable, -1L, false, errorsByServer.getStartTrackingTime()));
            }
            return;
        }
        long backOffTime = errorsByServer.calculateBackoffTime(oldLocation, this.pause);
        if (numAttempt > this.startLogErrorsCnt) {
            LOG.info(this.createLog(numAttempt, failureCount, toReplay.size(), oldLocation.getServerName(), throwable, backOffTime, true, errorsByServer.getStartTrackingTime()));
        }
        try {
            Thread.sleep(backOffTime);
        }
        catch (InterruptedException e) {
            LOG.warn("#" + this.id + ", not sent: " + toReplay.size() + " operations, " + oldLocation, e);
            Thread.currentThread().interrupt();
            return;
        }
        this.submit(initialActions, toReplay, numAttempt + 1, errorsByServer);
    }

    private void receiveMultiAction(List<Action<Row>> initialActions, MultiAction<Row> multiAction, HRegionLocation location, MultiResponse responses, int numAttempt, HConnectionManager.ServerErrorTracker errorsByServer, Batch.Callback<CResult> batchCallback) {
        assert (responses != null);
        ArrayList<Action<Row>> toReplay = new ArrayList<Action<Row>>();
        Throwable throwable = null;
        int failureCount = 0;
        boolean canRetry = true;
        for (Map.Entry<byte[], List<Pair<Integer, Object>>> entry2 : responses.getResults().entrySet()) {
            boolean regionFailureRegistered = false;
            for (Pair<Integer, Object> regionResult : entry2.getValue()) {
                Object result2 = regionResult.getSecond();
                if (result2 == null || result2 instanceof Throwable) {
                    throwable = (Throwable)result2;
                    Action<Row> correspondingAction = initialActions.get(regionResult.getFirst());
                    Row row = correspondingAction.getAction();
                    ++failureCount;
                    if (!regionFailureRegistered) {
                        regionFailureRegistered = true;
                        this.hConnection.updateCachedLocations(this.tableName, row.getRow(), result2, location);
                        if (failureCount == 1) {
                            errorsByServer.reportServerError(location);
                            canRetry = errorsByServer.canRetryMore(numAttempt);
                        }
                    }
                    if (!this.manageError(correspondingAction.getOriginalIndex(), row, canRetry, throwable, location)) continue;
                    toReplay.add(correspondingAction);
                    continue;
                }
                if (this.callback == null && batchCallback == null) continue;
                int index2 = regionResult.getFirst();
                Action<Row> correspondingAction = initialActions.get(index2);
                Row row = correspondingAction.getAction();
                if (this.callback != null) {
                    this.callback.success(index2, entry2.getKey(), row, result2);
                }
                if (batchCallback == null) continue;
                batchCallback.update(entry2.getKey(), row.getRow(), result2);
            }
        }
        for (Map.Entry<byte[], Object> entry3 : responses.getExceptions().entrySet()) {
            throwable = (Throwable)entry3.getValue();
            byte[] region = entry3.getKey();
            List actions = multiAction.actions.get(region);
            if (actions == null || actions.isEmpty()) {
                throw new IllegalStateException("Wrong response for the region: " + HRegionInfo.encodeRegionName(region));
            }
            if (failureCount == 0) {
                errorsByServer.reportServerError(location);
                canRetry = errorsByServer.canRetryMore(numAttempt);
            }
            this.hConnection.updateCachedLocations(this.tableName, actions.get(0).getAction().getRow(), (Object)throwable, location);
            failureCount += actions.size();
            for (Action action : actions) {
                Row row = action.getAction();
                if (!this.manageError(action.getOriginalIndex(), row, canRetry, throwable, location)) continue;
                toReplay.add(action);
            }
        }
        this.logAndResubmit(initialActions, location, toReplay, numAttempt, failureCount, throwable, errorsByServer);
    }

    private String createLog(int numAttempt, int failureCount, int replaySize, ServerName sn, Throwable error, long backOffTime, boolean willRetry, String startTime) {
        StringBuilder sb = new StringBuilder();
        sb.append("#").append(this.id).append(", table=").append(this.tableName).append(", attempt=").append(numAttempt).append("/").append(this.numTries).append(" ");
        if (failureCount > 0 || error != null) {
            sb.append("failed ").append(failureCount).append(" ops").append(", last exception: ").append(error == null ? "null" : error);
        } else {
            sb.append("SUCCEEDED");
        }
        sb.append(" on ").append(sn);
        sb.append(", tracking started ").append(startTime);
        if (willRetry) {
            sb.append(", retrying after ").append(backOffTime).append(" ms").append(", replay ").append(replaySize).append(" ops.");
        } else if (failureCount > 0) {
            sb.append(" - FAILED, NOT RETRYING ANYMORE");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForNextTaskDone(long currentNumberOfTask) throws InterruptedIOException {
        AtomicLong atomicLong = this.tasksDone;
        synchronized (atomicLong) {
            while (currentNumberOfTask == this.tasksDone.get()) {
                try {
                    this.tasksDone.wait(100L);
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException("#" + this.id + ", interrupted." + " currentNumberOfTask=" + currentNumberOfTask + ",  tableName=" + this.tableName + ", tasksDone=" + this.tasksDone.get());
                }
            }
        }
    }

    private void waitForMaximumCurrentTasks(int max2) throws InterruptedIOException {
        long lastLog = EnvironmentEdgeManager.currentTimeMillis();
        long currentTasksDone = this.tasksDone.get();
        while (this.tasksSent.get() - currentTasksDone > (long)max2) {
            long now = EnvironmentEdgeManager.currentTimeMillis();
            if (now > lastLog + 10000L) {
                lastLog = now;
                LOG.info("#" + this.id + ", waiting for some tasks to finish. Expected max=" + max2 + ", tasksSent=" + this.tasksSent.get() + ", tasksDone=" + this.tasksDone.get() + ", currentTasksDone=" + currentTasksDone + ", retries=" + this.retriesCnt.get() + " hasError=" + this.hasError() + ", tableName=" + this.tableName);
            }
            this.waitForNextTaskDone(currentTasksDone);
            currentTasksDone = this.tasksDone.get();
        }
    }

    private long getCurrentTasksCount() {
        return this.tasksSent.get() - this.tasksDone.get();
    }

    public void waitUntilDone() throws InterruptedIOException {
        this.waitForMaximumCurrentTasks(0);
    }

    public boolean hasError() {
        return this.hasError.get();
    }

    public List<? extends Row> getFailedOperations() {
        return this.errors.actions;
    }

    public void clearErrors() {
        this.errors.clear();
        this.hasError.set(false);
    }

    public RetriesExhaustedWithDetailsException getErrors() {
        return this.errors.makeException();
    }

    protected void incTaskCounters(Collection<byte[]> regions, ServerName sn) {
        this.tasksSent.incrementAndGet();
        AtomicInteger serverCnt = (AtomicInteger)this.taskCounterPerServer.get(sn);
        if (serverCnt == null) {
            this.taskCounterPerServer.putIfAbsent(sn, new AtomicInteger());
            serverCnt = (AtomicInteger)this.taskCounterPerServer.get(sn);
        }
        serverCnt.incrementAndGet();
        for (byte[] regBytes : regions) {
            AtomicInteger oldCnt;
            AtomicInteger regionCnt = (AtomicInteger)this.taskCounterPerRegion.get(regBytes);
            if (regionCnt == null && (oldCnt = this.taskCounterPerRegion.putIfAbsent(regBytes, regionCnt = new AtomicInteger())) != null) {
                regionCnt = oldCnt;
            }
            regionCnt.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decTaskCounters(Collection<byte[]> regions, ServerName sn) {
        for (byte[] regBytes : regions) {
            AtomicInteger regionCnt = (AtomicInteger)this.taskCounterPerRegion.get(regBytes);
            regionCnt.decrementAndGet();
        }
        ((AtomicInteger)this.taskCounterPerServer.get(sn)).decrementAndGet();
        this.tasksDone.incrementAndGet();
        AtomicLong atomicLong = this.tasksDone;
        synchronized (atomicLong) {
            this.tasksDone.notifyAll();
        }
    }

    protected HConnectionManager.ServerErrorTracker createServerErrorTracker() {
        return new HConnectionManager.ServerErrorTracker(this.serverTrackerTimeout, this.numTries);
    }

    private static class BatchErrors {
        private final List<Throwable> throwables = new ArrayList<Throwable>();
        private final List<Row> actions = new ArrayList<Row>();
        private final List<String> addresses = new ArrayList<String>();

        private BatchErrors() {
        }

        public synchronized void add(Throwable ex, Row row, HRegionLocation location) {
            if (row == null) {
                throw new IllegalArgumentException("row cannot be null. location=" + location);
            }
            this.throwables.add(ex);
            this.actions.add(row);
            this.addresses.add(location != null ? location.getServerName().toString() : "null location");
        }

        private synchronized RetriesExhaustedWithDetailsException makeException() {
            return new RetriesExhaustedWithDetailsException(new ArrayList<Throwable>(this.throwables), new ArrayList<Row>(this.actions), new ArrayList<String>(this.addresses));
        }

        public synchronized void clear() {
            this.throwables.clear();
            this.actions.clear();
            this.addresses.clear();
        }
    }

    static interface AsyncProcessCallback<CResult> {
        public void success(int var1, byte[] var2, Row var3, CResult var4);

        public boolean failure(int var1, byte[] var2, Row var3, Throwable var4);

        public boolean retriableFailure(int var1, Row var2, byte[] var3, Throwable var4);
    }
}

