/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.catalog;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;

@InterfaceAudience.Private
public class MetaReader {
    private static final Log LOG = LogFactory.getLog(MetaReader.class);
    static final byte[] META_REGION_PREFIX;

    public static Map<HRegionInfo, ServerName> fullScan(CatalogTracker catalogTracker, Set<TableName> disabledTables) throws IOException {
        return MetaReader.fullScan(catalogTracker, disabledTables, false);
    }

    public static Map<HRegionInfo, ServerName> fullScan(CatalogTracker catalogTracker, final Set<TableName> disabledTables, final boolean excludeOfflinedSplitParents) throws IOException {
        final TreeMap<HRegionInfo, ServerName> regions = new TreeMap<HRegionInfo, ServerName>();
        Visitor v = new Visitor(){

            @Override
            public boolean visit(Result r) throws IOException {
                if (r == null || r.isEmpty()) {
                    return true;
                }
                Pair<HRegionInfo, ServerName> region = HRegionInfo.getHRegionInfoAndServerName(r);
                HRegionInfo hri = region.getFirst();
                if (hri == null) {
                    return true;
                }
                if (hri.getTable() == null) {
                    return true;
                }
                if (disabledTables.contains(hri.getTable())) {
                    return true;
                }
                if (excludeOfflinedSplitParents && hri.isSplitParent()) {
                    return true;
                }
                regions.put(hri, region.getSecond());
                return true;
            }
        };
        MetaReader.fullScan(catalogTracker, v);
        return regions;
    }

    public static List<Result> fullScan(CatalogTracker catalogTracker) throws IOException {
        CollectAllVisitor v = new CollectAllVisitor();
        MetaReader.fullScan(catalogTracker, v, null);
        return v.getResults();
    }

    public static List<Result> fullScanOfMeta(CatalogTracker catalogTracker) throws IOException {
        CollectAllVisitor v = new CollectAllVisitor();
        MetaReader.fullScan(catalogTracker, v, null);
        return v.getResults();
    }

    public static void fullScan(CatalogTracker catalogTracker, Visitor visitor) throws IOException {
        MetaReader.fullScan(catalogTracker, visitor, null);
    }

    private static HTable getHTable(CatalogTracker catalogTracker, TableName tableName) throws IOException {
        HConnection c = catalogTracker.getConnection();
        if (c == null) {
            throw new NullPointerException("No connection");
        }
        return new HTable(tableName, c);
    }

    static HTable getCatalogHTable(CatalogTracker catalogTracker) throws IOException {
        return MetaReader.getMetaHTable(catalogTracker);
    }

    static HTable getMetaHTable(CatalogTracker ct) throws IOException {
        return MetaReader.getHTable(ct, TableName.META_TABLE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Result get(HTable t, Get g) throws IOException {
        try {
            Result result2 = t.get(g);
            return result2;
        }
        finally {
            t.close();
        }
    }

    static ServerName readRegionLocation(CatalogTracker catalogTracker, byte[] regionName) throws IOException {
        Pair<HRegionInfo, ServerName> pair2 = MetaReader.getRegion(catalogTracker, regionName);
        return pair2 == null || pair2.getSecond() == null ? null : pair2.getSecond();
    }

    public static Pair<HRegionInfo, ServerName> getRegion(CatalogTracker catalogTracker, byte[] regionName) throws IOException {
        Get get2 = new Get(regionName);
        get2.addFamily(HConstants.CATALOG_FAMILY);
        Result r = MetaReader.get(MetaReader.getCatalogHTable(catalogTracker), get2);
        return r == null || r.isEmpty() ? null : HRegionInfo.getHRegionInfoAndServerName(r);
    }

    public static Result getRegionResult(CatalogTracker catalogTracker, byte[] regionName) throws IOException {
        Get get2 = new Get(regionName);
        get2.addFamily(HConstants.CATALOG_FAMILY);
        return MetaReader.get(MetaReader.getCatalogHTable(catalogTracker), get2);
    }

    public static Pair<HRegionInfo, HRegionInfo> getRegionsFromMergeQualifier(CatalogTracker catalogTracker, byte[] regionName) throws IOException {
        Result result2 = MetaReader.getRegionResult(catalogTracker, regionName);
        HRegionInfo mergeA = HRegionInfo.getHRegionInfo(result2, HConstants.MERGEA_QUALIFIER);
        HRegionInfo mergeB = HRegionInfo.getHRegionInfo(result2, HConstants.MERGEB_QUALIFIER);
        if (mergeA == null && mergeB == null) {
            return null;
        }
        return new Pair<HRegionInfo, HRegionInfo>(mergeA, mergeB);
    }

    public static boolean tableExists(CatalogTracker catalogTracker, final TableName tableName) throws IOException {
        if (tableName.equals(TableName.META_TABLE_NAME)) {
            return true;
        }
        CollectingVisitor<HRegionInfo> visitor = new CollectingVisitor<HRegionInfo>(){
            private HRegionInfo current = null;

            @Override
            public boolean visit(Result r) throws IOException {
                this.current = HRegionInfo.getHRegionInfo(r, HConstants.REGIONINFO_QUALIFIER);
                if (this.current == null) {
                    LOG.warn("No serialized HRegionInfo in " + r);
                    return true;
                }
                if (!MetaReader.isInsideTable(this.current, tableName)) {
                    return false;
                }
                super.visit(r);
                return false;
            }

            @Override
            void add(Result r) {
                this.results.add(this.current);
            }
        };
        MetaReader.fullScan(catalogTracker, visitor, MetaReader.getTableStartRowForMeta(tableName));
        return visitor.getResults().size() >= 1;
    }

    public static List<HRegionInfo> getTableRegions(CatalogTracker catalogTracker, TableName tableName) throws IOException {
        return MetaReader.getTableRegions(catalogTracker, tableName, false);
    }

    public static List<HRegionInfo> getTableRegions(CatalogTracker catalogTracker, TableName tableName, boolean excludeOfflinedSplitParents) throws IOException {
        List<Pair<HRegionInfo, ServerName>> result2 = null;
        try {
            result2 = MetaReader.getTableRegionsAndLocations(catalogTracker, tableName, excludeOfflinedSplitParents);
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException().initCause(e);
        }
        return MetaReader.getListOfHRegionInfos(result2);
    }

    static List<HRegionInfo> getListOfHRegionInfos(List<Pair<HRegionInfo, ServerName>> pairs) {
        if (pairs == null || pairs.isEmpty()) {
            return null;
        }
        ArrayList<HRegionInfo> result2 = new ArrayList<HRegionInfo>(pairs.size());
        for (Pair<HRegionInfo, ServerName> pair2 : pairs) {
            result2.add(pair2.getFirst());
        }
        return result2;
    }

    static boolean isInsideTable(HRegionInfo current, TableName tableName) {
        return tableName.equals(current.getTable());
    }

    static byte[] getTableStartRowForMeta(TableName tableName) {
        byte[] startRow = new byte[tableName.getName().length + 2];
        System.arraycopy(tableName.getName(), 0, startRow, 0, tableName.getName().length);
        startRow[startRow.length - 2] = 44;
        startRow[startRow.length - 1] = 44;
        return startRow;
    }

    public static Scan getScanForTableName(TableName tableName) {
        String strName = tableName.getNameAsString();
        byte[] startKey = Bytes.toBytes(strName + ",,");
        byte[] stopKey = Bytes.toBytes(strName + " ,,");
        Scan scan2 = new Scan(startKey);
        scan2.setStopRow(stopKey);
        return scan2;
    }

    public static List<Pair<HRegionInfo, ServerName>> getTableRegionsAndLocations(CatalogTracker catalogTracker, TableName tableName) throws IOException, InterruptedException {
        return MetaReader.getTableRegionsAndLocations(catalogTracker, tableName, true);
    }

    public static List<Pair<HRegionInfo, ServerName>> getTableRegionsAndLocations(CatalogTracker catalogTracker, final TableName tableName, final boolean excludeOfflinedSplitParents) throws IOException, InterruptedException {
        if (tableName.equals(TableName.META_TABLE_NAME)) {
            ServerName serverName = catalogTracker.getMetaLocation();
            ArrayList<Pair<HRegionInfo, ServerName>> list2 = new ArrayList<Pair<HRegionInfo, ServerName>>();
            list2.add(new Pair<HRegionInfo, ServerName>(HRegionInfo.FIRST_META_REGIONINFO, serverName));
            return list2;
        }
        CollectingVisitor<Pair<HRegionInfo, ServerName>> visitor = new CollectingVisitor<Pair<HRegionInfo, ServerName>>(){
            private Pair<HRegionInfo, ServerName> current = null;

            @Override
            public boolean visit(Result r) throws IOException {
                HRegionInfo hri = HRegionInfo.getHRegionInfo(r, HConstants.REGIONINFO_QUALIFIER);
                if (hri == null) {
                    LOG.warn("No serialized HRegionInfo in " + r);
                    return true;
                }
                if (!MetaReader.isInsideTable(hri, tableName)) {
                    return false;
                }
                if (excludeOfflinedSplitParents && hri.isSplitParent()) {
                    return true;
                }
                ServerName sn = HRegionInfo.getServerName(r);
                this.current = new Pair<HRegionInfo, ServerName>(hri, sn);
                return super.visit(r);
            }

            @Override
            void add(Result r) {
                this.results.add(this.current);
            }
        };
        MetaReader.fullScan(catalogTracker, visitor, MetaReader.getTableStartRowForMeta(tableName));
        return visitor.getResults();
    }

    public static NavigableMap<HRegionInfo, Result> getServerUserRegions(CatalogTracker catalogTracker, final ServerName serverName) throws IOException {
        TreeMap<HRegionInfo, Result> hris = new TreeMap<HRegionInfo, Result>();
        CollectingVisitor<Result> v = new CollectingVisitor<Result>(){

            @Override
            void add(Result r) {
                if (r == null || r.isEmpty()) {
                    return;
                }
                if (HRegionInfo.getHRegionInfo(r) == null) {
                    return;
                }
                ServerName sn = HRegionInfo.getServerName(r);
                if (sn != null && sn.equals(serverName)) {
                    this.results.add(r);
                }
            }
        };
        MetaReader.fullScan(catalogTracker, v);
        List results = v.getResults();
        if (results != null && !results.isEmpty()) {
            for (Result r : results) {
                HRegionInfo hri = HRegionInfo.getHRegionInfo(r);
                if (hri == null) continue;
                hris.put(hri, r);
            }
        }
        return hris;
    }

    public static void fullScanMetaAndPrint(CatalogTracker catalogTracker) throws IOException {
        Visitor v = new Visitor(){

            @Override
            public boolean visit(Result r) throws IOException {
                if (r == null || r.isEmpty()) {
                    return true;
                }
                LOG.info("fullScanMetaAndPrint.Current Meta Row: " + r);
                HRegionInfo hrim = HRegionInfo.getHRegionInfo(r);
                LOG.info("fullScanMetaAndPrint.HRI Print= " + hrim);
                return true;
            }
        };
        MetaReader.fullScan(catalogTracker, v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fullScan(CatalogTracker catalogTracker, Visitor visitor, byte[] startrow) throws IOException {
        Scan scan2 = new Scan();
        if (startrow != null) {
            scan2.setStartRow(startrow);
        }
        if (startrow == null) {
            int caching = catalogTracker.getConnection().getConfiguration().getInt("hbase.meta.scanner.caching", 100);
            scan2.setCaching(caching);
        }
        scan2.addFamily(HConstants.CATALOG_FAMILY);
        HTable metaTable = MetaReader.getMetaHTable(catalogTracker);
        ResultScanner scanner = null;
        try {
            Result data2;
            scanner = metaTable.getScanner(scan2);
            while ((data2 = scanner.next()) != null && (data2.isEmpty() || visitor.visit(data2))) {
            }
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
            metaTable.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getRegionCount(Configuration c, String tableName) throws IOException {
        HTable t = new HTable(c, tableName);
        try {
            int n = t.getRegionLocations().size();
            return n;
        }
        finally {
            t.close();
        }
    }

    static {
        int len = HRegionInfo.FIRST_META_REGIONINFO.getRegionName().length - 2;
        META_REGION_PREFIX = new byte[len];
        System.arraycopy(HRegionInfo.FIRST_META_REGIONINFO.getRegionName(), 0, META_REGION_PREFIX, 0, len);
    }

    static class CollectAllVisitor
    extends CollectingVisitor<Result> {
        CollectAllVisitor() {
        }

        @Override
        void add(Result r) {
            this.results.add(r);
        }
    }

    static abstract class CollectingVisitor<T>
    implements Visitor {
        final List<T> results = new ArrayList<T>();

        CollectingVisitor() {
        }

        @Override
        public boolean visit(Result r) throws IOException {
            if (r == null || r.isEmpty()) {
                return true;
            }
            this.add(r);
            return true;
        }

        abstract void add(Result var1);

        List<T> getResults() {
            return this.results;
        }
    }

    public static interface Visitor {
        public boolean visit(Result var1) throws IOException;
    }
}

