/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.example;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.backup.example.HFileArchiveManager;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class ZKTableArchiveClient
extends Configured {
    private static final String ZOOKEEPER_ZNODE_HFILE_ARCHIVE_KEY = "zookeeper.znode.hfile.archive";
    private HConnection connection;

    public ZKTableArchiveClient(Configuration conf, HConnection connection) {
        super(conf);
        this.connection = connection;
    }

    public void enableHFileBackupAsync(byte[] table) throws IOException, KeeperException {
        this.createHFileArchiveManager().enableHFileBackup(table).stop();
    }

    public void disableHFileBackup(String table) throws IOException, KeeperException {
        this.disableHFileBackup(Bytes.toBytes(table));
    }

    public void disableHFileBackup(byte[] table) throws IOException, KeeperException {
        this.createHFileArchiveManager().disableHFileBackup(table).stop();
    }

    public void disableHFileBackup() throws IOException, KeeperException {
        this.createHFileArchiveManager().disableHFileBackup().stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getArchivingEnabled(byte[] table) throws IOException, KeeperException {
        HFileArchiveManager manager = this.createHFileArchiveManager();
        try {
            boolean bl = manager.isArchivingEnabled(table);
            return bl;
        }
        finally {
            manager.stop();
        }
    }

    public boolean getArchivingEnabled(String table) throws IOException, KeeperException {
        return this.getArchivingEnabled(Bytes.toBytes(table));
    }

    private synchronized HFileArchiveManager createHFileArchiveManager() throws KeeperException, IOException {
        return new HFileArchiveManager(this.connection, this.getConf());
    }

    public static String getArchiveZNode(Configuration conf, ZooKeeperWatcher zooKeeper) {
        return ZKUtil.joinZNode(zooKeeper.baseZNode, conf.get(ZOOKEEPER_ZNODE_HFILE_ARCHIVE_KEY, "hfilearchive"));
    }
}

