/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.example;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.backup.example.HFileArchiveTableMonitor;
import org.apache.hadoop.hbase.backup.example.ZKTableArchiveClient;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class TableHFileArchiveTracker
extends ZooKeeperListener {
    private static final Log LOG = LogFactory.getLog(TableHFileArchiveTracker.class);
    public static final String HFILE_ARCHIVE_ZNODE_PARENT = "hfilearchive";
    private HFileArchiveTableMonitor monitor;
    private String archiveHFileZNode;
    private boolean stopped = false;

    private TableHFileArchiveTracker(ZooKeeperWatcher watcher, HFileArchiveTableMonitor monitor) {
        super(watcher);
        watcher.registerListener(this);
        this.monitor = monitor;
        this.archiveHFileZNode = ZKTableArchiveClient.getArchiveZNode(watcher.getConfiguration(), watcher);
    }

    public void start() throws KeeperException {
        LOG.debug("Starting hfile archive tracker...");
        this.checkEnabledAndUpdate();
        LOG.debug("Finished starting hfile archive tracker!");
    }

    @Override
    public void nodeCreated(String path) {
        if (!path.startsWith(this.archiveHFileZNode)) {
            return;
        }
        LOG.debug("Archive node: " + path + " created");
        String table = path.substring(this.archiveHFileZNode.length());
        if (table.length() == 0) {
            this.checkEnabledAndUpdate();
            return;
        }
        try {
            this.addAndReWatchTable(path);
        }
        catch (KeeperException e) {
            LOG.warn("Couldn't read zookeeper data for table for path:" + path + ", not preserving a table.", e);
        }
    }

    @Override
    public void nodeChildrenChanged(String path) {
        if (!path.startsWith(this.archiveHFileZNode)) {
            return;
        }
        LOG.debug("Archive node: " + path + " children changed.");
        try {
            this.updateWatchedTables();
        }
        catch (KeeperException e) {
            LOG.error("Failed to update tables to archive", e);
        }
    }

    private void addAndReWatchTable(String tableZnode) throws KeeperException {
        this.getMonitor().addTable(ZKUtil.getNodeName(tableZnode));
        if (!ZKUtil.watchAndCheckExists(this.watcher, tableZnode)) {
            this.safeStopTrackingTable(tableZnode);
        }
    }

    private void safeStopTrackingTable(String tableZnode) throws KeeperException {
        this.getMonitor().removeTable(ZKUtil.getNodeName(tableZnode));
        if (ZKUtil.checkExists(this.watcher, tableZnode) >= 0) {
            this.addAndReWatchTable(tableZnode);
        }
    }

    @Override
    public void nodeDeleted(String path) {
        if (!path.startsWith(this.archiveHFileZNode)) {
            return;
        }
        LOG.debug("Archive node: " + path + " deleted");
        String table = path.substring(this.archiveHFileZNode.length());
        if (table.length() == 0) {
            this.clearTables();
            this.checkEnabledAndUpdate();
            return;
        }
        this.getMonitor().removeTable(ZKUtil.getNodeName(path));
    }

    private void checkEnabledAndUpdate() {
        try {
            if (ZKUtil.watchAndCheckExists(this.watcher, this.archiveHFileZNode)) {
                LOG.debug(this.archiveHFileZNode + " znode does exist, checking for tables to archive");
                this.updateWatchedTables();
            } else {
                LOG.debug("Archiving not currently enabled, waiting");
            }
        }
        catch (KeeperException e) {
            LOG.warn("Failed to watch for archiving znode", e);
        }
    }

    private void updateWatchedTables() throws KeeperException {
        LOG.debug("Updating watches on tables to archive.");
        List<String> tables = ZKUtil.listChildrenAndWatchThem(this.watcher, this.archiveHFileZNode);
        LOG.debug("Starting archive for tables:" + tables);
        if (tables != null && tables.size() > 0) {
            this.getMonitor().setArchiveTables(tables);
        } else {
            LOG.debug("No tables to archive.");
            this.clearTables();
        }
    }

    private void clearTables() {
        this.getMonitor().clearArchive();
    }

    public boolean keepHFiles(String tableName) {
        return this.getMonitor().shouldArchiveTable(tableName);
    }

    public final HFileArchiveTableMonitor getMonitor() {
        return this.monitor;
    }

    public static TableHFileArchiveTracker create(Configuration conf) throws ZooKeeperConnectionException, IOException {
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(conf, "hfileArchiveCleaner", null);
        return TableHFileArchiveTracker.create(zkw, new HFileArchiveTableMonitor());
    }

    private static TableHFileArchiveTracker create(ZooKeeperWatcher zkw, HFileArchiveTableMonitor monitor) {
        return new TableHFileArchiveTracker(zkw, monitor);
    }

    public ZooKeeperWatcher getZooKeeperWatcher() {
        return this.watcher;
    }

    public void stop() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        this.watcher.close();
    }
}

