/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.text.MessageFormat;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public final class Waiter {
    private static final Log LOG = LogFactory.getLog(Waiter.class);
    public static final String HBASE_TEST_WAIT_FOR_RATIO = "hbase.test.wait.for.ratio";
    private static float HBASE_WAIT_FOR_RATIO_DEFAULT = 1.0f;
    private static float waitForRatio = -1.0f;

    private Waiter() {
    }

    public static float getWaitForRatio(Configuration conf) {
        if (waitForRatio < 0.0f) {
            waitForRatio = System.getProperty(HBASE_TEST_WAIT_FOR_RATIO) != null ? Float.parseFloat(System.getProperty(HBASE_TEST_WAIT_FOR_RATIO)) : conf.getFloat(HBASE_TEST_WAIT_FOR_RATIO, HBASE_WAIT_FOR_RATIO_DEFAULT);
        }
        return waitForRatio;
    }

    public static void sleep(Configuration conf, long time) {
        try {
            Thread.sleep((long)(Waiter.getWaitForRatio(conf) * (float)time));
        }
        catch (InterruptedException ex) {
            LOG.warn(MessageFormat.format("Sleep interrupted, {0}", ex.toString()));
        }
    }

    public static <E extends Exception> long waitFor(Configuration conf, long timeout, Predicate<E> predicate) throws E {
        return Waiter.waitFor(conf, timeout, 100L, true, predicate);
    }

    public static <E extends Exception> long waitFor(Configuration conf, long timeout, long interval, Predicate<E> predicate) throws E {
        return Waiter.waitFor(conf, timeout, interval, true, predicate);
    }

    public static <E extends Exception> long waitFor(Configuration conf, long timeout, long interval, boolean failIfTimeout, Predicate<E> predicate) throws E {
        long started = System.currentTimeMillis();
        long adjustedTimeout = (long)(Waiter.getWaitForRatio(conf) * (float)timeout);
        long mustEnd = started + adjustedTimeout;
        long remainderWait = 0L;
        long sleepInterval = 0L;
        Boolean eval = false;
        Boolean interrupted = false;
        try {
            LOG.info(MessageFormat.format("Waiting up to [{0}] milli-secs(wait.for.ratio=[{1}])", adjustedTimeout, Float.valueOf(Waiter.getWaitForRatio(conf))));
            while (!(eval = Boolean.valueOf(predicate.evaluate())).booleanValue() && (remainderWait = mustEnd - System.currentTimeMillis()) > 0L) {
                try {
                    sleepInterval = remainderWait > interval ? interval : remainderWait;
                    Thread.sleep(sleepInterval);
                }
                catch (InterruptedException e) {
                    eval = predicate.evaluate();
                    interrupted = true;
                    break;
                }
            }
            if (!eval.booleanValue()) {
                if (interrupted.booleanValue()) {
                    LOG.warn(MessageFormat.format("Waiting interrupted after [{0}] msec", System.currentTimeMillis() - started));
                } else if (failIfTimeout) {
                    Assert.fail((String)MessageFormat.format("Waiting timed out after [{0}] msec", adjustedTimeout));
                } else {
                    LOG.warn(MessageFormat.format("Waiting timed out after [{0}] msec", adjustedTimeout));
                }
            }
            return eval != false || interrupted != false ? System.currentTimeMillis() - started : -1L;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @InterfaceAudience.Private
    public static interface Predicate<E extends Exception> {
        public boolean evaluate() throws E;
    }
}

