/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestCellUtil {
    @Test
    public void testCreateCellScannerOverflow() throws IOException {
        this.consume(this.doCreateCellScanner(1, 1), 1);
        this.consume(this.doCreateCellScanner(3, 0), 0);
        this.consume(this.doCreateCellScanner(3, 3), 9);
        this.consume(this.doCreateCellScanner(0, 1), 0);
        int hundredK = 100000;
        this.consume(this.doCreateCellScanner(100000, 0), 0);
        this.consume(this.doCreateCellArray(1), 1);
        this.consume(this.doCreateCellArray(0), 0);
        this.consume(this.doCreateCellArray(3), 3);
        ArrayList<TestCellScannable> cells = new ArrayList<TestCellScannable>(100000);
        for (int i = 0; i < 100000; ++i) {
            cells.add(new TestCellScannable(1));
        }
        this.consume(CellUtil.createCellScanner(cells), 100000);
        TreeMap<byte[], List<Cell>> m = new TreeMap<byte[], List<Cell>>(Bytes.BYTES_COMPARATOR);
        ArrayList<TestCell> cellArray = new ArrayList<TestCell>(100000);
        for (int i = 0; i < 100000; ++i) {
            cellArray.add(new TestCell(i));
        }
        m.put(new byte[]{102}, cellArray);
        this.consume(CellUtil.createCellScanner(m), 100000);
    }

    private CellScanner doCreateCellArray(int itemsPerList) {
        Cell[] cells = new Cell[itemsPerList];
        for (int i = 0; i < itemsPerList; ++i) {
            cells[i] = new TestCell(i);
        }
        return CellUtil.createCellScanner(cells);
    }

    private CellScanner doCreateCellScanner(int listsCount, final int itemsPerList) throws IOException {
        ArrayList<1> cells = new ArrayList<1>(listsCount);
        for (int i = 0; i < listsCount; ++i) {
            CellScannable cs = new CellScannable(){

                @Override
                public CellScanner cellScanner() {
                    return new TestCellScanner(itemsPerList);
                }
            };
            cells.add(cs);
        }
        return CellUtil.createCellScanner(cells);
    }

    private void consume(CellScanner scanner, int expected) throws IOException {
        int count2 = 0;
        while (scanner.advance()) {
            ++count2;
        }
        Assert.assertEquals((long)expected, (long)count2);
    }

    @Test
    public void testOverlappingKeys() {
        byte[] empty = HConstants.EMPTY_BYTE_ARRAY;
        byte[] a = Bytes.toBytes("a");
        byte[] b = Bytes.toBytes("b");
        byte[] c = Bytes.toBytes("c");
        byte[] d = Bytes.toBytes("d");
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(a, b, a, b));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(a, c, a, b));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(a, b, a, c));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(b, c, a, c));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(a, c, b, c));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(a, d, b, c));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(b, c, a, d));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(empty, b, a, b));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(empty, b, a, c));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(a, b, empty, b));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(a, b, empty, c));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(a, empty, a, b));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(a, empty, a, c));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(a, b, empty, empty));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(empty, empty, a, b));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys(a, b, c, d));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys(c, d, a, b));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys(b, c, c, d));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys(b, c, c, empty));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys(b, c, d, empty));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys(c, d, b, c));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys(c, empty, b, c));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys(d, empty, b, c));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys(b, c, a, b));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys(b, c, empty, b));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys(b, c, empty, a));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys(a, b, b, c));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys(empty, b, b, c));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys(empty, a, b, c));
    }

    private class TestCell
    implements Cell {
        private final byte[] row;

        TestCell(int i) {
            this.row = Bytes.toBytes(i);
        }

        @Override
        public byte[] getRowArray() {
            return this.row;
        }

        @Override
        public int getRowOffset() {
            return 0;
        }

        @Override
        public short getRowLength() {
            return (short)this.row.length;
        }

        @Override
        public byte[] getFamilyArray() {
            return null;
        }

        @Override
        public int getFamilyOffset() {
            return 0;
        }

        @Override
        public byte getFamilyLength() {
            return 0;
        }

        @Override
        public byte[] getQualifierArray() {
            return null;
        }

        @Override
        public int getQualifierOffset() {
            return 0;
        }

        @Override
        public int getQualifierLength() {
            return 0;
        }

        @Override
        public long getTimestamp() {
            return 0L;
        }

        @Override
        public byte getTypeByte() {
            return 0;
        }

        @Override
        public long getMvccVersion() {
            return 0L;
        }

        @Override
        public byte[] getValueArray() {
            return null;
        }

        @Override
        public int getValueOffset() {
            return 0;
        }

        @Override
        public int getValueLength() {
            return 0;
        }

        @Override
        public byte[] getTagsArray() {
            return null;
        }

        @Override
        public int getTagsOffset() {
            return 0;
        }

        @Override
        public short getTagsLength() {
            return 0;
        }

        @Override
        public int getTagsLengthUnsigned() {
            return 0;
        }

        @Override
        public byte[] getValue() {
            return null;
        }

        @Override
        public byte[] getFamily() {
            return null;
        }

        @Override
        public byte[] getQualifier() {
            return null;
        }

        @Override
        public byte[] getRow() {
            return null;
        }
    }

    private class TestCellScanner
    implements CellScanner {
        private int count = 0;
        private Cell current = null;
        private final int cellsCount;

        TestCellScanner(int cellsCount) {
            this.cellsCount = cellsCount;
        }

        @Override
        public Cell current() {
            return this.current;
        }

        @Override
        public boolean advance() throws IOException {
            if (this.count < this.cellsCount) {
                this.current = new TestCell(this.count);
                ++this.count;
                return true;
            }
            return false;
        }
    }

    private class TestCellScannable
    implements CellScannable {
        private final int cellsCount;

        TestCellScannable(int cellsCount) {
            this.cellsCount = cellsCount;
        }

        @Override
        public CellScanner cellScanner() {
            return new TestCellScanner(this.cellsCount);
        }
    }
}

